/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.math.AABB;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.PollutantFreeAir;
import com.endertech.minecraft.mods.adpother.pollution.AbstractPollution;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class PointPollution
extends AbstractPollution {
    protected World world;
    protected Biome biome;
    protected Vec3d position;
    protected CommonTime.Stamp lastUpdate;
    protected CommonTime.Interval ttl;

    public PointPollution(World world, Vec3d position) {
        this.world = world;
        this.position = position;
        this.ttl = CommonTime.Interval.seconds((double)1.0);
    }

    public boolean isOutdated() {
        return this.lastUpdate == null || CommonTime.Interval.passedFrom((CommonTime.Stamp)this.lastUpdate).moreThan(this.ttl);
    }

    public IBlockState getState(Pollutant<?> pollutant) {
        return this.getWorld().func_180495_p(this.getBlockPos());
    }

    public Vec3d getPosition() {
        return this.position;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.position.field_72450_a, this.position.field_72448_b, this.position.field_72449_c);
    }

    public World getWorld() {
        return this.world;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public void update() {
        BlockPos blockPos = this.getBlockPos();
        this.biome = this.world.func_180494_b(blockPos);
        this.lastUpdate = CommonTime.Stamp.now();
        if (!ForgeWorld.isServerSide((World)this.world)) {
            return;
        }
        ChunkPos center = new ChunkPos(blockPos);
        FloatBounds distanceBounds = FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(24.0f));
        ArrayList<ChunkPollution> chunksPollution = new ArrayList<ChunkPollution>();
        for (ChunkPos chunkPos : ForgeWorld.Position.getAroundHoriz((ChunkPos)center, (boolean)true, (ChunkPos[])new ChunkPos[]{center})) {
            if (!this.world.func_175667_e(chunkPos.func_180331_a(0, 0, 0))) continue;
            ChunkPollution pollution = WorldData.getChunkPollution(this.world, new ChunkLoc(this.world, chunkPos));
            chunksPollution.add(pollution);
        }
        List cleanAirSources = this.world.func_72872_a(PollutantFreeAir.class, AABB.BLOCK.func_191194_a(this.position).func_186662_g(32.0));
        this.infoForPollutant.clear();
        for (Pollutant pollutant : Main.getPollutants().getAll()) {
            float cleanAirFactor;
            int cumulativeAmount = chunksPollution.stream().mapToInt(chunkPollution -> {
                int amount = chunkPollution.getInfoFor(pollutant).map(info -> info.getAmount()).orElse(0);
                ChunkBounds chunkBounds = chunkPollution.getLocation().getBounds();
                Vec3d chunkCenter = ForgeWorld.getBlockCenter((BlockPos)new BlockPos(chunkBounds.getX().center().intValue(), 0, chunkBounds.getZ().center().intValue()).func_177963_a(0.0, this.position.field_72448_b, 0.0)).toVec3d();
                float distance = (float)this.position.func_72438_d(chunkCenter);
                float factor = distanceBounds.approxFactor(Float.valueOf(distance));
                amount = IntBounds.from((Integer)0, (Integer)amount).approxDown(factor);
                return amount;
            }).sum();
            if (cumulativeAmount > 0 && (cleanAirFactor = (float)cleanAirSources.stream().filter(air -> air.func_70089_S() && air.getPollutant().isPresent() && air.getPollutant().get() == pollutant).mapToDouble(air -> air.getConcentrationAt(this.position).toFraction()).sum()) > 0.0f) {
                cumulativeAmount -= Math.round((float)cumulativeAmount * cleanAirFactor);
            }
            if (cumulativeAmount <= 0 && !pollutant.isSamePollutant(this.getState(pollutant))) continue;
            this.getOrCreateInfoFor(pollutant).setAmount(cumulativeAmount);
        }
    }

    @Override
    public void readFrom(NBTTagCompound compound) {
        super.readFrom(compound);
        this.position = ForgeNBT.readVec3d((NBTTagCompound)compound, (String)"position").toVec3d();
        this.ttl = CommonTime.Interval.seconds((double)compound.func_74769_h("ttl"));
    }

    @Override
    public void writeTo(NBTTagCompound compound) {
        super.writeTo(compound);
        ForgeNBT.writeVec3d((NBTTagCompound)compound, (String)"position", (Vect3d)Vect3d.from((Vec3d)this.position));
        compound.func_74780_a("ttl", this.ttl.inSeconds());
    }
}

