/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.api.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.mods.adpother.Main;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Logger;

public class Weather2 {
    private static Weather2 instance;
    private final Logger logger = Main.instance.getLogger();
    private Method getWindAngle = null;
    private Method getWindSpeed = null;
    private Constructor<?> mathsVec3 = null;

    public static Optional<IWind> getWindAt(World world, BlockPos pos) {
        if (instance == null) {
            instance = new Weather2();
        }
        return instance.getWind(world, pos);
    }

    private Weather2() {
        this.logger.debug("Weather2 support initialization");
        if (Loader.isModLoaded((String)"weather2remaster")) {
            try {
                this.logger.debug("Found Weather 2 - Remastered");
                Class<?> classWindReader = Class.forName("net.mrbt0907.weather2.api.WindReader");
                Class<?> classVec3 = Class.forName("net.mrbt0907.weather2.util.Maths$Vec3");
                this.mathsVec3 = classVec3.getConstructor(BlockPos.class);
                this.getWindAngle = classWindReader.getMethod("getWindAngle", World.class, classVec3);
                this.getWindSpeed = classWindReader.getMethod("getWindSpeed", World.class, classVec3);
            }
            catch (Exception e) {
                this.logger.debug(e.toString());
            }
        } else if (Loader.isModLoaded((String)"weather2")) {
            try {
                this.logger.debug("Found Weather 2 (original)");
                Class<?> classWindReader = Class.forName("weather2.api.WindDataHelper");
                this.getWindAngle = classWindReader.getMethod("getWindAngle", World.class, BlockPos.class);
                this.getWindSpeed = classWindReader.getMethod("getWindSpeed", World.class, BlockPos.class);
            }
            catch (Exception e2) {
                this.logger.debug(e2.toString());
            }
        } else {
            return;
        }
        if (this.getWindAngle == null || this.getWindSpeed == null) {
            this.logger.debug("Unable to initialize Weather2 support");
        }
    }

    private Optional<IWind> getWind(World world, BlockPos pos) {
        if (this.getWindAngle != null && this.getWindSpeed != null) {
            try {
                float speed;
                BlockPos position = this.mathsVec3 != null ? this.mathsVec3.newInstance(pos) : pos;
                CommonMath.Angle angle = CommonMath.Angle.fromDegrees((double)((Float)this.getWindAngle.invoke(null, world, position)).floatValue());
                float strength = speed = ((Float)this.getWindSpeed.invoke(null, world, position)).floatValue();
                Wind.StaticWind wind = Wind.StaticWind.from((float)strength, (CommonMath.Angle)angle);
                return Optional.of(wind);
            }
            catch (Exception e) {
                this.logger.debug(e.toString());
            }
        }
        return Optional.empty();
    }
}

