/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.generator.customization.property;

import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import net.gegy1000.terrarium.server.world.generator.customization.property.PropertyValue;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PropertyKey<T> {
    private final String identifier;
    private final Class<T> type;

    public PropertyKey(String identifier, Class<T> type) {
        this.identifier = identifier;
        this.type = type;
    }

    public abstract JsonElement serializeValue(PropertyValue<T> var1);

    public abstract PropertyValue<T> makeValue(T var1);

    @Nullable
    public abstract PropertyValue<T> parseValue(JsonElement var1);

    public String getIdentifier() {
        return this.identifier;
    }

    public Class<T> getType() {
        return this.type;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PropertyKey && obj.getClass() == this.getClass() && ((PropertyKey)obj).getIdentifier().equals(this.identifier);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return I18n.func_135052_a((String)("property.terrarium." + this.identifier + ".name"), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedTooltip() {
        return I18n.func_135052_a((String)("property.terrarium." + this.identifier + ".tooltip"), (Object[])new Object[0]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.identifier + ")";
    }
}

