/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.raster;

import java.util.Arrays;
import java.util.Optional;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.DataKey;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.AbstractRaster;
import net.gegy1000.terrarium.server.world.data.raster.Raster;

public final class BitRaster
extends AbstractRaster<char[]> {
    private static final int WORD_SIZE_BYTES = 2;
    private static final int WORD_SIZE_BITS = 16;
    private static final int BIT_MASK = 15;

    private BitRaster(char[] data, int width, int height) {
        super(data, width, height);
    }

    private static int wordCount(int bits) {
        return (bits + 16 - 1) / 16;
    }

    public static BitRaster create(int width, int height) {
        int bits = width * height;
        char[] array = new char[BitRaster.wordCount(bits)];
        return new BitRaster(array, width, height);
    }

    public static BitRaster create(DataView view) {
        return BitRaster.create(view.width(), view.height());
    }

    public static Sampler sampler(DataKey<BitRaster> key) {
        return new Sampler(key);
    }

    public void set(int x, int y, boolean value) {
        if (value) {
            this.put(x, y);
        } else {
            this.remove(x, y);
        }
    }

    public void put(int x, int y) {
        int index = this.index(x, y);
        int bitIndex = index & 0xF;
        char[] cArray = (char[])this.rawData;
        int n = BitRaster.wordIndex(index);
        cArray[n] = (char)(cArray[n] | 1 << bitIndex);
    }

    public void remove(int x, int y) {
        int index = this.index(x, y);
        int bitIndex = index & 0xF;
        char[] cArray = (char[])this.rawData;
        int n = BitRaster.wordIndex(index);
        cArray[n] = (char)(cArray[n] & ~(1 << bitIndex));
    }

    public boolean get(int x, int y) {
        int index = this.index(x, y);
        int bitIndex = index & 0xF;
        char word = ((char[])this.rawData)[BitRaster.wordIndex(index)];
        return (word >> bitIndex & 1) != 0;
    }

    public void transform(Transformer transformer) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                boolean source = this.get(x, y);
                this.set(x, y, transformer.apply(source, x, y));
            }
        }
    }

    public void iterate(Iterator iterator) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                boolean value = this.get(x, y);
                iterator.accept(value, x, y);
            }
        }
    }

    public BitRaster copy() {
        return new BitRaster(Arrays.copyOf((char[])this.rawData, ((char[])this.rawData).length), this.width, this.height);
    }

    private static int wordIndex(int index) {
        return index / 16;
    }

    public static class Sampler
    implements Raster.Sampler<BitRaster> {
        private final DataKey<BitRaster> key;
        private boolean defaultValue;

        Sampler(DataKey<BitRaster> key) {
            this.key = key;
        }

        public Sampler setDefaultValue(boolean value) {
            this.defaultValue = value;
            return this;
        }

        public boolean sample(ColumnDataCache dataCache, int x, int z) {
            Optional<BitRaster> optional = dataCache.joinData(x >> 4, z >> 4, this.key);
            if (optional.isPresent()) {
                BitRaster raster = optional.get();
                return raster.get(x & 0xF, z & 0xF);
            }
            return this.defaultValue;
        }

        @Override
        public BitRaster sample(ColumnDataCache dataCache, DataView view) {
            BitRaster raster = BitRaster.create(view);
            if (this.defaultValue) {
                Arrays.fill((char[])raster.rawData, '\uffff');
            }
            AbstractRaster.sampleInto(raster, dataCache, view, this.key);
            return raster;
        }
    }

    public static interface Iterator {
        public void accept(boolean var1, int var2, int var3);
    }

    public static interface Transformer {
        public boolean apply(boolean var1, int var2, int var3);
    }
}

