/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.gegy1000.justnow.future.Future;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.server.world.data.DataContext;
import net.gegy1000.terrarium.server.world.data.DataKey;
import net.gegy1000.terrarium.server.world.data.DataOp;
import net.gegy1000.terrarium.server.world.data.DataSample;
import net.gegy1000.terrarium.server.world.data.DataStore;
import net.gegy1000.terrarium.server.world.data.DataView;

public final class DataGenerator {
    private final ImmutableMap<DataKey<?>, DataOp<?>> attachedData;

    private DataGenerator(ImmutableMap<DataKey<?>, DataOp<?>> attachedData) {
        this.attachedData = attachedData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Future<DataSample> generate(DataView view, Collection<DataKey<?>> keys) {
        ImmutableMap.Builder futures = ImmutableMap.builder();
        for (DataKey<?> key : keys) {
            DataOp op = (DataOp)this.attachedData.get(key);
            if (op == null) continue;
            Future<Optional> future = op.apply(view, DataContext.INSTANCE).handle((result, throwable) -> {
                if (throwable != null) {
                    Terrarium.LOGGER.error("Failed to load DataOp result", throwable);
                    return Optional.empty();
                }
                return result;
            });
            futures.put(key, future);
        }
        return Future.joinAll(futures.build()).map(result -> {
            DataStore store = this.buildDataStore((Map<DataKey<?>, Optional<?>>)result);
            return new DataSample(view, store);
        });
    }

    private DataStore buildDataStore(Map<DataKey<?>, Optional<?>> result) {
        DataStore store = new DataStore();
        for (Map.Entry<DataKey<?>, Optional<?>> entry : result.entrySet()) {
            DataKey<?> key = entry.getKey();
            Optional<?> value = entry.getValue();
            if (value == null || !value.isPresent()) continue;
            store.putUnchecked(key, value.get());
        }
        return store;
    }

    public Future<DataSample> generate(DataView view) {
        return this.generate(view, (Collection<DataKey<?>>)this.attachedData.keySet());
    }

    public static class Builder {
        private final Map<DataKey<?>, DataOp<?>> attachedData = new Reference2ObjectOpenHashMap();

        private Builder() {
        }

        public <T> Builder put(DataKey<T> key, DataOp<T> data) {
            this.attachedData.put(key, data);
            return this;
        }

        public <T> DataOp<T> get(DataKey<T> key) {
            return this.attachedData.get(key);
        }

        public <T> DataOp<T> remove(DataKey<T> key) {
            return this.attachedData.remove(key);
        }

        public DataGenerator build() {
            return new DataGenerator(ImmutableMap.copyOf(this.attachedData));
        }
    }
}

