/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class WeightedPool<T>
implements Iterable<Entry<T>> {
    private final List<Entry<T>> entries;
    private float totalWeight;

    private WeightedPool(List<Entry<T>> entries) {
        this.entries = entries;
        for (Entry<T> entry : entries) {
            this.totalWeight += ((Entry)entry).weight;
        }
    }

    public WeightedPool() {
        this.entries = new ArrayList<Entry<T>>();
    }

    public WeightedPool<T> add(T value, float weight) {
        if (weight <= 0.0f) {
            throw new IllegalArgumentException("weight must be positive");
        }
        this.entries.add(new Entry<T>(value, weight));
        this.totalWeight += weight;
        return this;
    }

    public WeightedPool<T> remove(T value) {
        this.entries.removeIf(e -> ((Entry)e).value.equals(value));
        return this;
    }

    public WeightedPool<T> addAll(Iterable<Entry<T>> entries) {
        for (Entry<T> entry : entries) {
            this.entries.add(entry);
            this.totalWeight += ((Entry)entry).weight;
        }
        return this;
    }

    @Nullable
    public T sampleOrNull(float sample) {
        sample *= this.totalWeight;
        float w = 0.0f;
        for (Entry<T> entry : this.entries) {
            if (!((w += ((Entry)entry).weight) > sample)) continue;
            return (T)((Entry)entry).value;
        }
        return null;
    }

    @Nullable
    public T sampleOrNull(Random random) {
        return this.sampleOrNull(random.nextFloat());
    }

    @Nonnull
    public T sampleOrExcept(Random random) {
        T sample = this.sampleOrNull(random.nextFloat());
        return (T)Preconditions.checkNotNull(sample, (Object)"empty pool");
    }

    public Entry<T> get(int index) {
        return this.entries.get(index);
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public String toString() {
        return String.format("WeightedPool{entries=%d, totalWeight=%s}", this.entries.size(), Float.valueOf(this.totalWeight));
    }

    @Override
    public Iterator<Entry<T>> iterator() {
        return this.entries.iterator();
    }

    public static class Entry<T> {
        private final T value;
        private final float weight;

        Entry(T value, float weight) {
            this.value = value;
            this.weight = weight;
        }

        public T getValue() {
            return this.value;
        }

        public float getWeight() {
            return this.weight;
        }
    }
}

