/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server;

import dev.gegy.gengen.api.GenericWorldType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.gegy1000.terrarium.server.capability.TerrariumAuxCaps;
import net.gegy1000.terrarium.server.capability.TerrariumCapabilities;
import net.gegy1000.terrarium.server.world.TerrariumWorldType;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;
import net.gegy1000.terrarium.server.world.generator.customization.PropertySchema;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="terrarium")
public class TerrariumUserTracker {
    private static final Set<EntityPlayer> TERRARIUM_USERS = new HashSet<EntityPlayer>();
    private static GenerationSettings providedSettings;

    public static void markPlayerUsingTerrarium(EntityPlayer player) {
        TERRARIUM_USERS.add(player);
    }

    public static void provideSettings(World world, String settings) {
        if (world == null) {
            return;
        }
        TerrariumWorldType worldType = GenericWorldType.unwrapAs(world.func_175624_G(), TerrariumWorldType.class);
        if (worldType == null) {
            return;
        }
        PropertySchema schema = worldType.buildPropertySchema();
        providedSettings = GenerationSettings.parse(schema, settings);
        TerrariumAuxCaps aux = (TerrariumAuxCaps)world.getCapability(TerrariumCapabilities.aux(), null);
        if (aux == null) {
            return;
        }
        Collection<ICapabilityProvider> capabilities = worldType.createCapabilities(world, providedSettings);
        for (ICapabilityProvider provider : capabilities) {
            aux.addAux(provider);
        }
    }

    public static boolean usesTerrarium(EntityPlayer player) {
        return TERRARIUM_USERS.contains(player);
    }

    public static Set<EntityPlayer> getTerrariumUsers() {
        return new HashSet<EntityPlayer>(TERRARIUM_USERS);
    }

    @Nullable
    public static GenerationSettings getProvidedSettings() {
        return providedSettings;
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        TERRARIUM_USERS.remove(event.player);
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        TERRARIUM_USERS.removeAll(event.getWorld().field_73010_i);
    }
}

