/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.ecology.maxent;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.world.ecology.GrowthIndicator;
import net.gegy1000.earth.server.world.ecology.GrowthPredictors;
import net.gegy1000.earth.server.world.ecology.maxent.feature.MaxentFeature;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class MaxentCompiler {
    private static final Path DEBUG_ROOT = Paths.get("mods/terrarium/debug/maxent", new String[0]);
    private static final AtomicInteger COUNTER = new AtomicInteger(0);

    private static String nextClassName() {
        return "CompiledMaxent" + COUNTER.incrementAndGet();
    }

    public static GrowthIndicator compileFeature(MaxentFeature feature) {
        String className = MaxentCompiler.nextClassName();
        byte[] bytes = MaxentCompiler.compileFeatureBytes(className, feature);
        try {
            Class<?> definedClass = MaxentCompiler.defineClass(className, bytes);
            return (GrowthIndicator)definedClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to define feature on ClassLoader", e);
        }
    }

    private static Class<?> defineClass(final String className, final byte[] bytes) throws ClassNotFoundException {
        if (TerrariumEarth.isDeobfuscatedEnvironment()) {
            MaxentCompiler.debugWriteClass(className, bytes);
        }
        ClassLoader classLoader = new ClassLoader(TerrariumEarth.class.getClassLoader()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (name.equals(className)) {
                    return super.defineClass(name, bytes, 0, bytes.length);
                }
                return super.loadClass(name);
            }
        };
        return classLoader.loadClass(className);
    }

    private static byte[] compileFeatureBytes(String name, MaxentFeature feature) {
        ClassWriter writer = new ClassWriter(3);
        writer.visit(52, 1, name, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(GrowthIndicator.class)});
        MethodVisitor constructor = writer.visitMethod(1, "<init>", "()V", null, null);
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        constructor.visitInsn(177);
        constructor.visitMaxs(0, 0);
        MethodVisitor evaluate = writer.visitMethod(1, "evaluate", "(" + Type.getDescriptor(GrowthPredictors.class) + ")F", null, null);
        feature.emitBytecode(evaluate);
        evaluate.visitInsn(174);
        evaluate.visitMaxs(0, 0);
        return writer.toByteArray();
    }

    private static void debugWriteClass(String className, byte[] bytes) {
        try {
            if (!Files.exists(DEBUG_ROOT, new LinkOption[0])) {
                Files.createDirectories(DEBUG_ROOT, new FileAttribute[0]);
            }
            Path path = DEBUG_ROOT.resolve(className + ".class");
            Files.write(path, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            TerrariumEarth.LOGGER.warn("Failed to write compiled maxent class", (Throwable)e);
        }
    }
}

