/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.data;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedList;
import javax.annotation.Nullable;
import javax.vecmath.Vector2d;
import net.gegy1000.earth.server.shared.SharedEarthData;
import net.gegy1000.earth.server.world.data.EarthApiKeys;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.server.world.data.source.Geocoder;

public class GoogleGeocoder
implements Geocoder {
    private static final String GEOCODER_ADDRESS = "https://maps.googleapis.com/maps/api/geocode/json?address=%s&key=%s";
    private static final String SUGGESTION_ADDRESS = "https://maps.googleapis.com/maps/api/place/autocomplete/json?input=%s&types=geocode&key=%s";
    private static final JsonParser JSON_PARSER = new JsonParser();

    @Override
    @Nullable
    public Vector2d get(String place) throws IOException {
        EarthApiKeys keys = SharedEarthData.instance().get(SharedEarthData.API_KEYS);
        if (keys == null) {
            return null;
        }
        String key = keys.getGeocoderKey();
        if (Strings.isNullOrEmpty((String)key)) {
            return null;
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(String.format(GEOCODER_ADDRESS, URLEncoder.encode(place, "UTF-8"), key)).openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", "terrarium");
        connection.setRequestProperty("Referer", "https://github.com/gegy1000/Terrarium");
        connection.setConnectTimeout(4000);
        connection.setReadTimeout(30000);
        try (InputStreamReader input = new InputStreamReader(new BufferedInputStream(connection.getInputStream()));){
            JsonObject root = (JsonObject)JSON_PARSER.parse((Reader)input);
            this.handleResponseStatus(root);
            if (root.has("results")) {
                JsonArray results = root.getAsJsonArray("results");
                for (JsonElement element : results) {
                    JsonObject result = element.getAsJsonObject();
                    if (!result.has("geometry")) continue;
                    JsonObject geometry = result.getAsJsonObject("geometry");
                    JsonObject location = geometry.getAsJsonObject("location");
                    Vector2d vector2d = new Vector2d(location.get("lat").getAsDouble(), location.get("lng").getAsDouble());
                    return vector2d;
                }
            }
            Terrarium.LOGGER.warn("Got geocoder response for {} with no result: {}", (Object)place, (Object)root);
        }
        return null;
    }

    @Override
    public String[] suggest(String place) throws IOException {
        EarthApiKeys keys = SharedEarthData.instance().get(SharedEarthData.API_KEYS);
        if (keys == null) {
            return null;
        }
        String key = keys.getAutocompleteKey();
        if (Strings.isNullOrEmpty((String)key)) {
            return null;
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(String.format(SUGGESTION_ADDRESS, URLEncoder.encode(place, "UTF-8"), key)).openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", "terrarium");
        connection.setRequestProperty("Referer", "https://github.com/gegy1000/Terrarium");
        connection.setConnectTimeout(2000);
        connection.setReadTimeout(30000);
        try (InputStreamReader input = new InputStreamReader(new BufferedInputStream(connection.getInputStream()));){
            JsonObject root = (JsonObject)JSON_PARSER.parse((Reader)input);
            this.handleResponseStatus(root);
            if (root.has("predictions")) {
                LinkedList<String> predictions = new LinkedList<String>();
                JsonArray predictionsArray = root.getAsJsonArray("predictions");
                for (JsonElement element : predictionsArray) {
                    JsonObject prediction = element.getAsJsonObject();
                    predictions.add(prediction.get("description").getAsString());
                }
                String[] stringArray = predictions.toArray(new String[0]);
                return stringArray;
            }
        }
        return new String[0];
    }

    private void handleResponseStatus(JsonObject root) throws IOException {
        if (root.has("status")) {
            String status = root.get("status").getAsString();
            if (status.equalsIgnoreCase("OVER_QUERY_LIMIT")) {
                throw new IOException("Reached query limit for Google API! Try again in a few minutes");
            }
            if (status.equalsIgnoreCase("REQUEST_DENIED")) {
                throw new IOException(root.get("error_message").getAsString());
            }
        }
    }
}

