/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.composer.structure.data;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;

public final class LossyColumnSet {
    private final long[] table;
    private final int capacity;
    private final int mask;

    public LossyColumnSet(int capacity) {
        this.capacity = MathHelper.func_151236_b((int)capacity);
        this.mask = this.capacity - 1;
        this.table = new long[this.capacity];
        this.clear();
    }

    private static int hash(long key) {
        return HashCommon.long2int((long)HashCommon.mix((long)key));
    }

    public boolean set(int x, int z) {
        long key = ChunkPos.func_77272_a((int)x, (int)z);
        int idx = LossyColumnSet.hash(key) & this.mask;
        long existing = this.table[idx];
        this.table[idx] = key;
        return existing == key;
    }

    public boolean contains(int x, int z) {
        long key = ChunkPos.func_77272_a((int)x, (int)z);
        int idx = LossyColumnSet.hash(key) & this.mask;
        return this.table[idx] == key;
    }

    public void clear() {
        Arrays.fill(this.table, Long.MIN_VALUE);
    }
}

