/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.composer.structure;

import dev.gegy.gengen.api.HeightFunction;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.earth.server.world.compatibility.ColumnCompatibilityWorld;
import net.gegy1000.earth.server.world.composer.structure.ColumnStructureComposer;
import net.gegy1000.earth.server.world.composer.structure.placement.CellStructurePlacement;
import net.gegy1000.terrarium.server.capability.TerrariumCapabilities;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.util.Lazy;
import net.gegy1000.terrarium.server.world.composer.structure.StructureComposer;
import net.minecraft.init.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.WoodlandMansion;

public final class MansionStructureComposer {
    private static final List<Biome> MANSION_BIOMES = Arrays.asList(Biomes.field_76767_f, Biomes.field_150583_P, Biomes.field_76782_w, Biomes.field_76768_g, Biomes.field_150585_R);

    public static StructureComposer create(WorldServer world, HeightFunction surfaceFunction) {
        CellStructurePlacement placement = new CellStructurePlacement(80, 20, 10387319).setPredicate(MansionStructureComposer::canSpawnAt);
        Lazy<CompatChunkGenerator> overworld = Lazy.of(() -> new CompatChunkGenerator((World)world));
        return ColumnStructureComposer.builder().setStructureName("Mansion").setPlacement(placement).setSurfaceFunction(surfaceFunction).setStartConstructor((w, r, x, z) -> MansionStructureComposer.makeStart((CompatChunkGenerator)((Object)((Object)overworld.get())), w, r, x, z)).build(world);
    }

    private static StructureStart makeStart(CompatChunkGenerator overworld, World world, Random random, int chunkX, int chunkZ) {
        if (world instanceof ColumnCompatibilityWorld) {
            overworld.setupAt(((ColumnCompatibilityWorld)world).getMinY());
        }
        return new WoodlandMansion.Start(world, (ChunkGeneratorOverworld)overworld, random, chunkX, chunkZ);
    }

    private static boolean canSpawnAt(World world, int chunkX, int chunkZ) {
        int x = (chunkX << 4) + 8;
        int z = (chunkZ << 4) + 8;
        return world.func_72959_q().func_76940_a(x, z, 16, MANSION_BIOMES);
    }

    static final class CompatChunkGenerator
    extends ChunkGeneratorOverworld {
        private final Lazy<Optional<TerrariumWorld>> terrarium;
        private int minY;

        CompatChunkGenerator(World world) {
            super(world, world.func_72912_H().func_76063_b(), false, null);
            this.terrarium = Lazy.ofCapability(world, TerrariumCapabilities.world());
        }

        void setupAt(int minY) {
            this.minY = minY;
        }

        public void func_185976_a(int x, int z, ChunkPrimer primer) {
            Optional heightOpt = this.terrarium.get().flatMap(terrarium -> terrarium.getDataCache().joinData(x, z, EarthData.TERRAIN_HEIGHT));
            heightOpt.ifPresent(heightRaster -> {
                for (int localZ = 0; localZ < 16; ++localZ) {
                    for (int localX = 0; localX < 16; ++localX) {
                        int height = heightRaster.get(localX, localZ) - this.minY;
                        if (height < 0 || height >= 255) continue;
                        primer.func_177855_a(localX, height, localZ, field_185982_a);
                    }
                }
            });
        }
    }
}

