/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.composer.decoration;

import dev.gegy.gengen.api.CubicPos;
import dev.gegy.gengen.api.writer.ChunkPopulationWriter;
import dev.gegy.gengen.util.SpatialRandom;
import java.util.Random;
import net.gegy1000.earth.server.world.compatibility.ColumnCompatibility;
import net.gegy1000.earth.server.world.compatibility.ColumnCompatibilityWorld;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.util.Profiler;
import net.gegy1000.terrarium.server.util.ThreadedProfiler;
import net.gegy1000.terrarium.server.world.composer.decoration.DecorationComposer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class EarthCompatComposer
implements DecorationComposer {
    private static final long DECORATION_SEED = 1569264434830154879L;
    private final SpatialRandom random;
    private final ColumnCompatibility compatibility;

    public EarthCompatComposer(WorldServer world) {
        this.random = new SpatialRandom((World)world, 1569264434830154879L);
        this.compatibility = new ColumnCompatibility(world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void composeDecoration(TerrariumWorld terrarium, CubicPos pos, ChunkPopulationWriter writer) {
        Loader loader = Loader.instance();
        ModContainer activeMod = loader.activeModContainer();
        loader.setActiveModContainer(null);
        try (Profiler.Handle compatibility = ThreadedProfiler.get().push("compatibility");){
            this.compatibility.generateInColumn(terrarium, pos, this::runCompatibilityGenerators);
        }
        finally {
            loader.setActiveModContainer(activeMod);
        }
    }

    private void runCompatibilityGenerators(ColumnCompatibilityWorld world, ChunkPos columnPos) {
        Profiler profiler = ThreadedProfiler.get();
        this.random.setSeed(columnPos.field_77276_a, columnPos.field_77275_b);
        world.firePopulateEvent((Random)this.random, true);
        world.firePopulateEvent((Random)this.random, PopulateChunkEvent.Populate.EventType.DUNGEON);
        world.firePopulateEvent((Random)this.random, PopulateChunkEvent.Populate.EventType.ICE);
        world.firePopulateEvent((Random)this.random, PopulateChunkEvent.Populate.EventType.LAKE);
        world.firePopulateEvent((Random)this.random, PopulateChunkEvent.Populate.EventType.LAVA);
        try (Profiler.Handle decorate = profiler.push("decorate");){
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre((World)world, (Random)this.random, columnPos));
            try (Profiler.Handle ores = profiler.push("ores");){
                world.fireOreGenEvent((Random)this.random, true);
                world.fireOreGenEvent((Random)this.random, OreGenEvent.GenerateMinable.EventType.DIRT);
                world.fireOreGenEvent((Random)this.random, OreGenEvent.GenerateMinable.EventType.GRAVEL);
                world.fireOreGenEvent((Random)this.random, OreGenEvent.GenerateMinable.EventType.DIORITE);
                world.fireOreGenEvent((Random)this.random, OreGenEvent.GenerateMinable.EventType.GRANITE);
                world.fireOreGenEvent((Random)this.random, OreGenEvent.GenerateMinable.EventType.ANDESITE);
                world.fireOreGenEvent((Random)this.random, OreGenEvent.GenerateMinable.EventType.COAL);
                world.fireOreGenEvent((Random)this.random, OreGenEvent.GenerateMinable.EventType.IRON);
                world.fireOreGenEvent((Random)this.random, OreGenEvent.GenerateMinable.EventType.GOLD);
                world.fireOreGenEvent((Random)this.random, OreGenEvent.GenerateMinable.EventType.REDSTONE);
                world.fireOreGenEvent((Random)this.random, OreGenEvent.GenerateMinable.EventType.DIAMOND);
                world.fireOreGenEvent((Random)this.random, OreGenEvent.GenerateMinable.EventType.LAPIS);
                world.fireOreGenEvent((Random)this.random, false);
            }
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.SAND);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.CLAY);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.SAND_PASS2);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.TREE);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.FLOWERS);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.GRASS);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.LILYPAD);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.SHROOM);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.PUMPKIN);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.CACTUS);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.LAKE_WATER);
            world.fireDecorateEvent(this.random, DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA);
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post((World)world, (Random)this.random, columnPos));
        }
        var5_5 = null;
        try (Profiler.Handle modded = profiler.push("modded_generators");){
            world.runModdedGenerators();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        world.firePopulateEvent((Random)this.random, false);
    }
}

