/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.util.zoom;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.gegy1000.earth.server.util.zoom.ForZoom;
import net.gegy1000.earth.server.util.zoom.ZoomLevels;

public final class Zoomable<T>
implements ForZoom<T> {
    private final ZoomLevels levels;
    private final Int2ObjectMap<T> internal;
    private T orElse;

    private Zoomable(ZoomLevels levels, Int2ObjectMap<T> internal) {
        this.levels = levels;
        this.internal = internal;
    }

    public Zoomable<T> orElse(T value) {
        this.orElse = value;
        return this;
    }

    public static <T> Zoomable<T> create(ZoomLevels levels, IntFunction<T> function) {
        Int2ObjectOpenHashMap internal = new Int2ObjectOpenHashMap();
        levels.stream().forEach(arg_0 -> Zoomable.lambda$create$0((Int2ObjectMap)internal, function, arg_0));
        return new Zoomable<T>(levels, internal);
    }

    @Override
    public T forZoom(int zoom) {
        return (T)this.internal.getOrDefault((Object)zoom, this.orElse);
    }

    public ZoomLevels getLevels() {
        return this.levels;
    }

    public boolean contains(int zoom) {
        return this.levels.contains(zoom);
    }

    public <R> Zoomable<R> map(Map<T, R> map) {
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap(this.internal.size());
        for (Int2ObjectMap.Entry entry : this.internal.int2ObjectEntrySet()) {
            int zoom = entry.getIntKey();
            Object value = entry.getValue();
            result.put(zoom, map.apply(zoom, value));
        }
        return new Zoomable<T>(this.levels, result);
    }

    public <R> Zoomable<R> mapValue(Function<T, R> map) {
        return this.map((zoom, value) -> map.apply(value));
    }

    private static /* synthetic */ void lambda$create$0(Int2ObjectMap internal, IntFunction function, int zoom) {
        internal.put(zoom, function.apply(zoom));
    }

    public static interface Map<T, R> {
        public R apply(int var1, T var2);
    }
}

