/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui.preview;

import java.util.concurrent.atomic.AtomicInteger;
import net.gegy1000.earth.client.gui.preview.PreviewMeshBuilder;
import net.gegy1000.earth.client.terrain.TerrainMesh;
import net.gegy1000.earth.client.terrain.TerrainMeshData;
import net.gegy1000.justnow.executor.CurrentThreadExecutor;
import net.gegy1000.justnow.future.Cancelable;
import net.gegy1000.justnow.future.Future;
import net.gegy1000.terrarium.server.world.TerrariumWorldType;
import net.gegy1000.terrarium.server.world.data.source.DataSourceReader;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;

public final class WorldPreview
implements AutoCloseable {
    public static final int RADIUS = 256;
    public static final int SIZE = 513;
    public static final int GRANULARITY = 2;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private TerrainMesh mesh;
    private Cancelable<TerrainMeshData> meshFuture;

    public void rebuild(TerrariumWorldType worldType, GenerationSettings settings) {
        if (this.meshFuture != null) {
            this.meshFuture.cancel();
            DataSourceReader.INSTANCE.cancelLoading();
        }
        this.meshFuture = Future.cancelable(PreviewMeshBuilder.build(worldType, settings));
    }

    public void render() {
        TerrainMesh mesh;
        Cancelable<TerrainMeshData> future = this.meshFuture;
        if (future != null && this.advanceMeshFuture(future)) {
            this.meshFuture = null;
        }
        if ((mesh = this.mesh) != null) {
            mesh.render();
        }
    }

    private boolean advanceMeshFuture(Future<TerrainMeshData> future) {
        TerrainMeshData data = CurrentThreadExecutor.advance(future);
        if (data != null) {
            this.uploadMesh(data);
            return true;
        }
        return false;
    }

    private void uploadMesh(TerrainMeshData data) {
        if (this.mesh != null) {
            this.mesh.delete();
        }
        this.mesh = data.upload();
    }

    public void delete() {
        if (this.mesh != null) {
            this.mesh.delete();
        }
        if (this.meshFuture != null) {
            this.meshFuture.cancel();
        }
        this.referenceCount.set(0);
        DataSourceReader.INSTANCE.clear();
    }

    public WorldPreview retain() {
        this.referenceCount.getAndIncrement();
        return this;
    }

    public void release() {
        if (this.referenceCount.decrementAndGet() <= 0) {
            this.delete();
        }
    }

    public boolean isGenerateInactive() {
        return this.meshFuture == null;
    }

    @Override
    public void close() {
        this.release();
    }
}

