/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui;

import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.message.ModifyDownloadMessage;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EarthPreloadProgressGui
extends GuiScreen {
    private static final int EXIT_BUTTON = 0;
    private static final int RUN_IN_BACKGROUND_BUTTON = 1;
    private static final int BAR_HEIGHT = 14;
    private static final int BAR_BACKGROUND_COLOR = -16777216;
    private static final int BAR_COLOR = -13408734;
    private long count;
    private final long total;
    private GuiButton exitButton;

    public EarthPreloadProgressGui(long count, long total) {
        this.count = count;
        this.total = total;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.exitButton = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.earth.run_in_background", (Object[])new Object[0])));
    }

    private String getExitText() {
        if (this.isComplete()) {
            return I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]);
    }

    private boolean isComplete() {
        return this.total > 0L && this.count >= this.total;
    }

    public void update(long count) {
        this.count = count;
        if (this.count >= this.total) {
            this.exitButton.field_146126_j = this.getExitText();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (!button.field_146124_l) {
            return;
        }
        if (!this.isComplete()) {
            if (button.field_146127_k == 0) {
                TerrariumEarth.NETWORK.sendToServer((IMessage)new ModifyDownloadMessage(true, false));
            } else if (button.field_146127_k == 1) {
                TerrariumEarth.NETWORK.sendToServer((IMessage)new ModifyDownloadMessage(false, true));
            }
        }
        this.field_146297_k.func_147108_a(null);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.earth.preload.downloading", (Object[])new Object[0]), centerX, 20, 0xFFFFFF);
        this.drawProgressBar(this.count, this.total, centerY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawProgressBar(long count, long total, int y) {
        double progress;
        int barWidth = MathHelper.func_76143_f((double)((double)this.field_146294_l * 0.75));
        int minX = (this.field_146294_l - barWidth) / 2;
        int minY = y - 7;
        int maxX = (this.field_146294_l + barWidth) / 2;
        int maxY = y + 7;
        Gui.func_73734_a((int)minX, (int)minY, (int)maxX, (int)maxY, (int)-16777216);
        double d = progress = total != 0L ? (double)count / (double)total : 0.0;
        if (progress > 0.0) {
            int progressX = MathHelper.func_76128_c((double)((double)(minX + 1) + (double)(maxX - minX - 2) * progress));
            Gui.func_73734_a((int)(minX + 1), (int)(minY + 1), (int)progressX, (int)(maxY - 1), (int)-13408734);
        }
        int centerX = (minX + maxX) / 2;
        int centerY = (minY + maxY - this.field_146289_q.field_78288_b) / 2 + 1;
        String percentageString = String.format("%.0f%%", progress * 100.0);
        this.func_73732_a(this.field_146289_q, percentageString, centerX, centerY, 0xA0A0A0);
    }
}

