/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client;

import java.lang.reflect.Field;
import net.gegy1000.terrarium.Terrarium;
import net.minecraft.client.Minecraft;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LoadingWorldGetter {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static Field worldSettingsField;

    public static void onPostInit() {
        try {
            worldSettingsField = LoadingWorldGetter.reflectWorldSettingsField();
        }
        catch (Exception e) {
            Terrarium.LOGGER.warn("Failed to reflect world settings field", (Throwable)e);
        }
    }

    private static Field reflectWorldSettingsField() throws Exception {
        Field worldSettingsField = null;
        for (Field field : IntegratedServer.class.getDeclaredFields()) {
            if (field.getType() != WorldSettings.class) continue;
            field.setAccessible(true);
            worldSettingsField = field;
        }
        if (worldSettingsField == null) {
            throw new ReflectiveOperationException("Could not find WorldSettings field");
        }
        return worldSettingsField;
    }

    public static WorldType getLoadingWorldType() {
        WorldType worldType = null;
        if (LoadingWorldGetter.MC.field_71441_e != null) {
            worldType = LoadingWorldGetter.MC.field_71441_e.func_175624_G();
        } else if (MC.func_71401_C() != null) {
            try {
                WorldSettings serverSettings = LoadingWorldGetter.getServerSettings(MC.func_71401_C());
                if (serverSettings != null) {
                    worldType = serverSettings.func_77165_h();
                }
            }
            catch (Exception e) {
                Terrarium.LOGGER.warn("Failed to get IntegratedServer world settings", (Throwable)e);
            }
        }
        return worldType;
    }

    private static WorldSettings getServerSettings(IntegratedServer server) throws Exception {
        if (worldSettingsField == null) {
            return null;
        }
        return (WorldSettings)worldSettingsField.get(server);
    }
}

