/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wile.engineersdecor.blocks.BlockDecor;
import wile.engineersdecor.blocks.BlockDecorDoubleGate;
import wile.engineersdecor.blocks.BlockDecorFence;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecorWall
extends BlockDecor {
    public static final PropertyBool UP = BlockWall.field_176256_a;
    public static final PropertyBool NORTH = BlockWall.field_176254_b;
    public static final PropertyBool EAST = BlockWall.field_176257_M;
    public static final PropertyBool SOUTH = BlockWall.field_176258_N;
    public static final PropertyBool WEST = BlockWall.field_176259_O;
    public static final PropertyInteger TEXTURE_VARIANT = PropertyInteger.func_177719_a((String)"tvariant", (int)0, (int)7);
    protected static final AxisAlignedBB[] AABB_BY_INDEX = BlockDecorWall.mkAABBs(4.0, 3.84, 16.0);
    protected static final AxisAlignedBB[] CLIP_AABB_BY_INDEX = BlockDecorWall.mkAABBs(4.0, 3.84, 24.0);
    protected static final AxisAlignedBB[][] AABB_LIST_BY_INDEX = BlockDecorWall.mkCAABBs(4.0, 3.84, 16.0);
    protected static final AxisAlignedBB[][] CLIP_AABB_LIST_BY_INDEX = BlockDecorWall.mkCAABBs(4.0, 3.84, 24.0);
    protected static final AxisAlignedBB SELECTION_AABB = ModAuxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 0.01, 0.01, 0.01);

    protected static final AxisAlignedBB[] mkAABBs(double pole_thickness_px, double wall_thickness_px, double height_px) {
        double d_0 = 0.0;
        double d_1 = 16.0;
        double d_a = 8.0 - pole_thickness_px;
        double d_b = 16.0 - d_a;
        double d_k = 8.0 - wall_thickness_px;
        double d_l = 16.0 - d_k;
        return new AxisAlignedBB[]{ModAuxiliaries.getPixeledAABB(d_a, 0.0, d_a, d_b, height_px, d_b), ModAuxiliaries.getPixeledAABB(d_a, 0.0, d_a, d_b, height_px, 16.0), ModAuxiliaries.getPixeledAABB(0.0, 0.0, d_a, d_b, height_px, d_b), ModAuxiliaries.getPixeledAABB(0.0, 0.0, d_a, d_b, height_px, 16.0), ModAuxiliaries.getPixeledAABB(d_a, 0.0, 0.0, d_b, height_px, d_b), ModAuxiliaries.getPixeledAABB(d_k, 0.0, 0.0, d_l, height_px, 16.0), ModAuxiliaries.getPixeledAABB(0.0, 0.0, 0.0, d_b, height_px, d_b), ModAuxiliaries.getPixeledAABB(0.0, 0.0, 0.0, d_b, height_px, 16.0), ModAuxiliaries.getPixeledAABB(d_a, 0.0, d_a, 16.0, height_px, d_b), ModAuxiliaries.getPixeledAABB(d_a, 0.0, d_a, 16.0, height_px, 16.0), ModAuxiliaries.getPixeledAABB(0.0, 0.0, d_k, 16.0, height_px, d_l), ModAuxiliaries.getPixeledAABB(0.0, 0.0, d_a, 16.0, height_px, 16.0), ModAuxiliaries.getPixeledAABB(d_a, 0.0, 0.0, 16.0, height_px, d_b), ModAuxiliaries.getPixeledAABB(d_a, 0.0, 0.0, 16.0, height_px, 16.0), ModAuxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, height_px, d_b), ModAuxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, height_px, 16.0)};
    }

    protected static final AxisAlignedBB[][] mkCAABBs(double pole_thickness_px, double wall_thickness_px, double height_px) {
        double d_0 = 0.0;
        double d_1 = 16.0;
        double d_a = 8.0 - pole_thickness_px;
        double d_b = 16.0 - d_a;
        double d_k = 8.0 - wall_thickness_px;
        double d_l = 16.0 - d_k;
        AxisAlignedBB bb_p = ModAuxiliaries.getPixeledAABB(d_a, 0.0, d_a, d_b, height_px, d_b);
        AxisAlignedBB bb_s = ModAuxiliaries.getPixeledAABB(d_k, 0.0, d_k, d_l, height_px, 16.0);
        AxisAlignedBB bb_w = ModAuxiliaries.getPixeledAABB(0.0, 0.0, d_k, d_l, height_px, d_l);
        AxisAlignedBB bb_n = ModAuxiliaries.getPixeledAABB(d_k, 0.0, 0.0, d_l, height_px, d_l);
        AxisAlignedBB bb_e = ModAuxiliaries.getPixeledAABB(d_k, 0.0, d_k, 16.0, height_px, d_l);
        return new AxisAlignedBB[][]{{bb_p}, {bb_s}, {bb_w}, {bb_s, bb_w}, {bb_n}, {bb_n, bb_s}, {bb_n, bb_w}, {bb_n, bb_w, bb_s}, {bb_e}, {bb_e, bb_s}, {bb_e, bb_w}, {bb_e, bb_w, bb_s}, {bb_e, bb_n}, {bb_e, bb_n, bb_s}, {bb_e, bb_n, bb_w}, {bb_e, bb_n, bb_w, bb_s}};
    }

    public BlockDecorWall(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound) {
        super(registryName, config, material, hardness, resistance, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_BY_INDEX[BlockDecorWall.getAABBIndex(this.func_176221_a(state, source, pos))];
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        AxisAlignedBB[] bbs = CLIP_AABB_LIST_BY_INDEX[BlockDecorWall.getAABBIndex(isActualState ? state : this.func_176221_a(state, (IBlockAccess)world, pos))];
        for (int i = 0; i < bbs.length; ++i) {
            BlockDecorWall.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bbs[i]);
        }
    }

    @Override
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CLIP_AABB_BY_INDEX[BlockDecorWall.getAABBIndex(this.func_176221_a(state, world, pos))];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return SELECTION_AABB;
    }

    protected static int getAABBIndex(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)SOUTH) == false ? 0 : 1 << EnumFacing.SOUTH.func_176736_b()) | ((Boolean)state.func_177229_b((IProperty)WEST) == false ? 0 : 1 << EnumFacing.WEST.func_176736_b()) | ((Boolean)state.func_177229_b((IProperty)NORTH) == false ? 0 : 1 << EnumFacing.NORTH.func_176736_b()) | ((Boolean)state.func_177229_b((IProperty)EAST) == false ? 0 : 1 << EnumFacing.EAST.func_176736_b());
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public boolean func_181623_g() {
        return false;
    }

    protected boolean canConnectTo(IBlockAccess world, BlockPos pos, BlockPos other, EnumFacing facing) {
        IBlockState state = world.func_180495_p(other);
        Block block = state.func_177230_c();
        if (block instanceof BlockDecorWall || block instanceof BlockFenceGate || block instanceof BlockDecorFence || block instanceof BlockDecorDoubleGate) {
            return true;
        }
        if (world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this) {
            return false;
        }
        if (block instanceof BlockFence) {
            return true;
        }
        BlockFaceShape shp = state.func_193401_d(world, other, facing);
        return shp == BlockFaceShape.SOLID && !BlockDecorWall.isExcepBlockForAttachWithPiston(block);
    }

    protected static boolean isExcepBlockForAttachWithPiston(Block b) {
        return Block.func_193382_c((Block)b) || b == Blocks.field_180401_cv || b == Blocks.field_150440_ba || b == Blocks.field_150423_aK || b == Blocks.field_150428_aP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN || super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean n = this.canWallConnectTo(world, pos, EnumFacing.NORTH);
        boolean e = this.canWallConnectTo(world, pos, EnumFacing.EAST);
        boolean s = this.canWallConnectTo(world, pos, EnumFacing.SOUTH);
        boolean w = this.canWallConnectTo(world, pos, EnumFacing.WEST);
        boolean nopole = n && s && !e && !w || !n && !s && e && w;
        long prnd = pos.func_177986_g();
        prnd = prnd >> 29 ^ prnd >> 17 ^ prnd >> 9 ^ prnd >> 4 ^ (long)pos.func_177958_n() ^ (long)pos.func_177956_o() ^ (long)pos.func_177952_p();
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(!nopole)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(n)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(e)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(s)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(w)).func_177226_a((IProperty)TEXTURE_VARIANT, (Comparable)Integer.valueOf((int)prnd & 7));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, NORTH, EAST, WEST, SOUTH, TEXTURE_VARIANT});
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.CENTER : (face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THICK : BlockFaceShape.CENTER_BIG);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.canConnectTo(world, pos, pos.func_177972_a(facing), facing.func_176734_d());
    }

    protected boolean canWallConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.canConnectTo(world, pos, pos.func_177972_a(facing), facing.func_176734_d());
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.FENCE;
    }
}

