/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config.json;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import toughasnails.util.BlockStateUtils;

public class BlockStatePredicate
implements Predicate<IBlockState> {
    @SerializedName(value="block")
    private String blockRegistryName;
    private Map<String, String> properties;

    public BlockStatePredicate(ResourceLocation blockRegistryLoc, Map<IProperty<?>, Comparable<?>> properties) {
        this.blockRegistryName = blockRegistryLoc.toString();
        this.properties = Maps.newHashMap();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : properties.entrySet()) {
            this.properties.put(entry.getKey().func_177701_a(), entry.getValue().toString());
        }
    }

    public BlockStatePredicate(Block block) {
        this(block.getRegistryName(), Maps.newHashMap());
    }

    public BlockStatePredicate(IBlockState state, Set<IProperty<?>> usedProperties) {
        this(state.func_177230_c().getRegistryName(), BlockStatePredicate.generatePropertyMap(state, usedProperties));
    }

    public boolean apply(@Nullable IBlockState input) {
        IBlockState defaultState = input.func_177230_c().func_176223_P();
        for (IProperty property : defaultState.func_177227_a()) {
            String propName = property.func_177701_a();
            if (!this.properties.containsKey(propName)) continue;
            String reqValueStr = this.properties.get(propName);
            Comparable reqValue = BlockStateUtils.getPropertyValueByName(input, property, reqValueStr);
            if (reqValueStr.equals("*") || reqValue != null && input.func_177229_b(property) == reqValue) continue;
            return false;
        }
        return true;
    }

    public Block getBlock() {
        return Block.func_149684_b((String)this.blockRegistryName);
    }

    private static Map<IProperty<?>, Comparable<?>> generatePropertyMap(IBlockState state, Set<IProperty<?>> usedProperties) {
        HashMap propertyMap = Maps.newHashMap();
        for (IProperty<?> property : usedProperties) {
            propertyMap.put(property, state.func_177229_b(property));
        }
        return propertyMap;
    }
}

