/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.tileentity.TileEntityLoadedBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityOilDrillBase
extends TileEntityLoadedBase
implements ITickable,
IEnergyUser,
IFluidHandler,
ITankPacketAcceptor {
    public ItemStackHandler inventory;
    public long power;
    public int warning;
    public int warning2;
    public int age = 0;
    public int age2 = 0;
    public FluidTank[] tanks;
    public Fluid[] tankTypes;
    public boolean needsUpdate;
    private String customName;
    List<int[]> list = new ArrayList<int[]>();
    HashSet<BlockPos> processed = new HashSet();

    public TileEntityOilDrillBase() {
        this(6);
    }

    public TileEntityOilDrillBase(int slots) {
        this.inventory = new ItemStackHandler(slots){

            protected void onContentsChanged(int slot) {
                TileEntityOilDrillBase.this.func_70296_d();
                super.onContentsChanged(slot);
            }
        };
        this.tanks = new FluidTank[3];
        this.tankTypes = new Fluid[3];
        this.tanks[0] = new FluidTank(128000);
        this.tankTypes[0] = ModForgeFluids.oil;
        this.tanks[1] = new FluidTank(128000);
        this.tankTypes[1] = ModForgeFluids.gas;
        this.needsUpdate = false;
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    protected String getCustomName() {
        return this.customName;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 128.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("powerTime");
        this.age = compound.func_74762_e("age");
        this.tankTypes[0] = ModForgeFluids.oil;
        this.tankTypes[1] = ModForgeFluids.gas;
        if (compound.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(compound.func_150295_c("tanks", 10), this.tanks);
        }
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("powerTime", this.power);
        compound.func_74768_a("age", this.age);
        compound.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public long getPowerScaled(long i) {
        return this.power * i / this.getMaxPower();
    }

    public byte succ(int x, int y, int z) {
        this.list.clear();
        this.succ1(x, y, z);
        this.succ2(x, y, z);
        if (!this.list.isEmpty()) {
            int c;
            int b;
            int i = this.field_145850_b.field_73012_v.nextInt(this.list.size());
            int a = this.list.get(i)[0];
            BlockPos abc = new BlockPos(a, b = this.list.get(i)[1], c = this.list.get(i)[2]);
            if (this.field_145850_b.func_180495_p(abc).func_177230_c() == ModBlocks.ore_oil) {
                this.field_145850_b.func_175656_a(abc, ModBlocks.ore_oil_empty.func_176223_P());
                return 1;
            }
            if (this.field_145850_b.func_180495_p(abc).func_177230_c() == ModBlocks.ore_bedrock_oil) {
                return 2;
            }
        }
        this.processed.clear();
        return 0;
    }

    public void succInit1(int x, int y, int z) {
        this.succ1(x + 1, y, z);
        this.succ1(x - 1, y, z);
        this.succ1(x, y + 1, z);
        this.succ1(x, y - 1, z);
        this.succ1(x, y, z + 1);
        this.succ1(x, y, z - 1);
    }

    public void succInit2(int x, int y, int z) {
        this.succ2(x + 1, y, z);
        this.succ2(x - 1, y, z);
        this.succ2(x, y + 1, z);
        this.succ2(x, y - 1, z);
        this.succ2(x, y, z + 1);
        this.succ2(x, y, z - 1);
    }

    public void succ1(int x, int y, int z) {
        BlockPos newPos = new BlockPos(x, y, z);
        if (this.field_145850_b.func_180495_p(newPos).func_177230_c() == ModBlocks.ore_oil_empty && !this.processed.contains(newPos)) {
            this.processed.add(newPos);
            this.succInit1(x, y, z);
        }
    }

    public void succ2(int x, int y, int z) {
        BlockPos newPos = new BlockPos(x, y, z);
        if (this.field_145850_b.func_180495_p(newPos).func_177230_c() == ModBlocks.ore_oil_empty && this.processed.contains(newPos)) {
            this.processed.remove(newPos);
            this.succInit2(x, y, z);
        } else if (this.field_145850_b.func_180495_p(newPos).func_177230_c() == ModBlocks.ore_oil || this.field_145850_b.func_180495_p(newPos).func_177230_c() == ModBlocks.ore_bedrock_oil) {
            this.list.add(new int[]{x, y, z});
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 2) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

