/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.machine.MachineElectricFurnace;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineElectricFurnace
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public int dualCookTime;
    public long power;
    public static final long maxPower = 100000L;
    public static final int processingSpeed = 100;
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{2, 0};
    private static final int[] slots_side = new int[]{0};

    public TileEntityMachineElectricFurnace() {
        super(3);
    }

    @Override
    public String getName() {
        return "container.electricFurnace";
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("powerTime");
        this.dualCookTime = compound.func_74762_e("cookTime");
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("powerTime", this.power);
        compound.func_74768_a("cookTime", this.dualCookTime);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int i = e.ordinal();
        return i == 0 ? slots_bottom : (i == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (i == 0 && stack.func_77973_b() instanceof IBatteryItem) {
            return true;
        }
        return i == 1;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        if (slot == 0 && itemStack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == 0L) {
            return true;
        }
        return slot == 2;
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.dualCookTime * i / 100;
    }

    public long getPowerRemainingScaled(long i) {
        return this.power * i / 100000L;
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean isProcessing() {
        return this.dualCookTime > 0;
    }

    public boolean canProcess() {
        if (this.inventory.getStackInSlot(1).func_190926_b()) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(1));
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        if (this.inventory.getStackInSlot(2).func_190926_b()) {
            return true;
        }
        if (!this.inventory.getStackInSlot(2).func_77969_a(itemStack)) {
            return false;
        }
        if (this.inventory.getStackInSlot(2).func_190916_E() < this.inventory.getSlotLimit(2) && this.inventory.getStackInSlot(2).func_190916_E() < this.inventory.getStackInSlot(2).func_77976_d()) {
            return true;
        }
        return this.inventory.getStackInSlot(2).func_190916_E() < itemStack.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(1));
            if (this.inventory.getStackInSlot(2).func_190926_b()) {
                this.inventory.setStackInSlot(2, itemStack.func_77946_l());
            } else if (this.inventory.getStackInSlot(2).func_77969_a(itemStack)) {
                this.inventory.getStackInSlot(2).func_190917_f(itemStack.func_190916_E());
            }
            for (int i = 1; i < 2; ++i) {
                if (this.inventory.getStackInSlot(2).func_190926_b()) {
                    this.inventory.setStackInSlot(i, new ItemStack(this.inventory.getStackInSlot(i).func_77973_b()));
                } else {
                    this.inventory.getStackInSlot(i).func_190918_g(1);
                }
                if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            long prevPower = this.power;
            if (this.hasPower() && this.canProcess()) {
                ++this.dualCookTime;
                this.power -= 50L;
                if (this.dualCookTime == 100) {
                    this.dualCookTime = 0;
                    this.processItem();
                    flag1 = true;
                }
            } else {
                this.dualCookTime = 0;
            }
            boolean trigger = true;
            if (this.hasPower() && this.canProcess() && this.dualCookTime == 0) {
                trigger = false;
            }
            if (trigger) {
                flag1 = true;
                MachineElectricFurnace.updateBlockState(this.dualCookTime > 0, this.field_145850_b, this.field_174879_c);
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 100000L);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.dualCookTime, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            if (flag1 || prevPower != this.power) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }
}

