/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.MachineRecipes;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityChungus
extends TileEntityLoadedBase
implements ITickable,
IFluidHandler,
IEnergyGenerator,
INBTPacketReceiver {
    public long powerProduction = 0L;
    public long power;
    public static final long maxPower = 100000000000L;
    private int turnTimer;
    public float rotor;
    public float lastRotor;
    public FluidTank[] tanks;
    public Fluid[] types = new Fluid[]{ModForgeFluids.steam, ModForgeFluids.spentsteam};

    public TileEntityChungus() {
        this.tanks = new FluidTank[2];
        this.types = new Fluid[2];
        this.tanks[0] = new FluidTank(2000000000);
        this.tanks[1] = new FluidTank(2000000000);
        this.types[0] = ModForgeFluids.steam;
        this.types[1] = ModForgeFluids.spentsteam;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            Object[] outs = MachineRecipes.getTurbineOutput(this.types[0]);
            this.types[1] = (Fluid)outs[0];
            int processMax = (int)Math.ceil(this.tanks[0].getFluidAmount() / (Integer)outs[2]);
            int processSteam = this.tanks[0].getFluidAmount() / (Integer)outs[2];
            int processWater = (this.tanks[1].getCapacity() - this.tanks[1].getFluidAmount()) / (Integer)outs[1];
            int cycles = Math.min(processMax, Math.min(processSteam, processWater));
            this.tanks[0].drain((Integer)outs[2] * cycles, true);
            this.tanks[1].fill(new FluidStack(this.types[1], (Integer)outs[1] * cycles), true);
            this.powerProduction = (Integer)outs[3] * cycles;
            this.power += this.powerProduction;
            if (this.power > 100000000000L) {
                this.power = 100000000000L;
            }
            --this.turnTimer;
            if (cycles > 0) {
                this.turnTimer = 25;
            }
            this.networkPack();
            this.fillFluidInit(this.tanks[1]);
            ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
            this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(-dir.offsetX * 11, 0, -dir.offsetZ * 11), dir.getOpposite());
        } else {
            this.lastRotor = this.rotor;
            if (this.turnTimer > 0) {
                this.rotor += 25.0f;
                if (this.rotor >= 360.0f) {
                    this.rotor -= 360.0f;
                    this.lastRotor -= 360.0f;
                }
                ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
                ForgeDirection side = dir.getRotation(ForgeDirection.UP);
                for (int i = 0; i < 10; ++i) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.CLOUD, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * (this.field_145850_b.field_73012_v.nextDouble() + 1.25) + this.field_145850_b.field_73012_v.nextGaussian() * (double)side.offsetX * 0.65, (double)this.field_174879_c.func_177956_o() + 2.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.65, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * (this.field_145850_b.field_73012_v.nextDouble() + 1.25) + this.field_145850_b.field_73012_v.nextGaussian() * (double)side.offsetZ * 0.65, (double)(-dir.offsetX) * 0.2, 0.0, (double)(-dir.offsetZ) * 0.2, new int[0]);
                }
            }
        }
    }

    public void networkPack() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("powerP", this.powerProduction);
        data.func_74772_a("power", this.power);
        data.func_74778_a("type", this.types[0].getName());
        data.func_74768_a("operational", this.turnTimer);
        data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        data.func_74778_a("types0", this.types[0].getName());
        data.func_74778_a("types1", this.types[1].getName());
        INBTPacketReceiver.networkPack(this, data, 150);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        FFUtils.deserializeTankArray(data.func_150295_c("tanks", 10), this.tanks);
        this.powerProduction = data.func_74763_f("powerP");
        this.power = data.func_74763_f("power");
        this.turnTimer = data.func_74762_e("operational");
        if (data.func_74764_b("types0")) {
            this.types[0] = FluidRegistry.getFluid((String)data.func_74779_i("types0"));
        }
        if (data.func_74764_b("types1")) {
            this.types[1] = FluidRegistry.getFluid((String)data.func_74779_i("types1"));
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.types[0] = FluidRegistry.getFluid((String)nbt.func_74779_i("types0"));
        this.types[1] = FluidRegistry.getFluid((String)nbt.func_74779_i("types1"));
        this.power = nbt.func_74763_f("power");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74778_a("types0", this.types[0].getName());
        nbt.func_74778_a("types1", this.types[1].getName());
        nbt.func_74772_a("power", this.power);
        return nbt;
    }

    public void fillFluidInit(FluidTank tank) {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        dir = dir.getRotation(ForgeDirection.UP);
        this.fillFluid(this.field_174879_c.func_177958_n() + dir.offsetX * 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ * 3, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() + dir.offsetX * -3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ * -3, tank);
    }

    public void fillFluid(int x, int y, int z, FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(x, y, z), tank.getCapacity());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == this.types[0]) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == this.types[1]) {
            return this.tanks[1].drain(resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tanks[1].drain(maxDrain, doDrain);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 100000000000L;
    }
}

