/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.physics;

import com.hbm.physics.Contact;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.BobMathUtil;

public class ContactManifold {
    public static final float CONTACT_BREAK = 0.02f;
    public static final float CONTACT_BREAK_SQ = 4.0E-4f;
    public Contact[] contacts = new Contact[4];
    public int contactCount = 0;

    public void update() {
        Contact c;
        int i;
        for (i = 0; i < this.contactCount; ++i) {
            c = this.contacts[i];
            c.globalA = c.bodyA.localToGlobalPos(c.localA);
            c.globalB = c.bodyB.localToGlobalPos(c.localB);
            this.contacts[i].depth = (float)c.globalA.subtract(c.globalB).dotProduct(c.normal);
        }
        for (i = 0; i < this.contactCount; ++i) {
            c = this.contacts[i];
            if (c.depth > 0.02f) {
                this.removeContact(i);
                --i;
                continue;
            }
            Vec3 proj = c.globalA.subtract(c.normal.mult(c.depth));
            double orthoDistToB = proj.subtract(c.globalB).lengthSquared();
            if (!(orthoDistToB > (double)4.0E-4f)) continue;
            this.removeContact(i);
            --i;
        }
    }

    public void removeContact(int idx) {
        this.contacts[idx] = null;
        for (int i = idx; i < 3; ++i) {
            this.contacts[i] = this.contacts[i + 1];
            this.contacts[i + 1] = null;
        }
        --this.contactCount;
    }

    public boolean addContact(Contact c) {
        int idx = this.getContactIndex(c);
        boolean replace = true;
        if (idx < 0) {
            if (this.contactCount < 4) {
                idx = this.contactCount;
                replace = false;
            } else {
                idx = this.getLeastRemoteIndex(c);
            }
        }
        if (idx >= 0) {
            if (!replace) {
                ++this.contactCount;
            }
            this.contacts[idx] = c;
            return true;
        }
        return false;
    }

    public int getLeastRemoteIndex(Contact c) {
        Vec3 b;
        Vec3 a;
        float deepest = -3.4028235E38f;
        int deepIdx = -1;
        for (int i = 0; i < this.contactCount; ++i) {
            if (!(this.contacts[i].depth > deepest)) continue;
            deepest = this.contacts[i].depth;
            deepIdx = i;
        }
        double res0 = 0.0;
        double res1 = 0.0;
        double res2 = 0.0;
        double res3 = 0.0;
        if (deepIdx != 0) {
            a = c.localA.subtract(this.contacts[1].localA);
            b = this.contacts[3].localA.subtract(this.contacts[2].localA);
            res0 = a.crossProduct(b).lengthSquared();
        }
        if (deepIdx != 1) {
            a = c.localA.subtract(this.contacts[0].localA);
            b = this.contacts[3].localA.subtract(this.contacts[2].localA);
            res1 = a.crossProduct(b).lengthSquared();
        }
        if (deepIdx != 2) {
            a = c.localA.subtract(this.contacts[0].localA);
            b = this.contacts[3].localA.subtract(this.contacts[1].localA);
            res2 = a.crossProduct(b).lengthSquared();
        }
        if (deepIdx != 3) {
            a = c.localA.subtract(this.contacts[0].localA);
            b = this.contacts[2].localA.subtract(this.contacts[1].localA);
            res3 = a.crossProduct(b).lengthSquared();
        }
        return BobMathUtil.absMaxIdx(res0, res1, res2, res3);
    }

    public int getContactIndex(Contact c) {
        int idx = -1;
        double shortestDist = 4.0E-4f;
        for (int i = 0; i < this.contactCount; ++i) {
            double dist = this.contacts[i].localA.subtract(c.localA).lengthSquared();
            if (!(dist < shortestDist)) continue;
            shortestDist = dist;
            idx = i;
        }
        return idx;
    }
}

