/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.tileentity.bomb.TileEntityRailgun;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RailgunCallbackPacket
implements IMessage {
    int x;
    int y;
    int z;
    float pitch;
    float yaw;

    public RailgunCallbackPacket() {
    }

    public RailgunCallbackPacket(int x, int y, int z, float pitch, float yaw) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.pitch = buf.readFloat();
        this.yaw = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeFloat(this.pitch);
        buf.writeFloat(this.yaw);
    }

    public static class Handler
    implements IMessageHandler<RailgunCallbackPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(RailgunCallbackPacket m, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                try {
                    TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(m.x, m.y, m.z));
                    if (te != null && te instanceof TileEntityRailgun) {
                        TileEntityRailgun gun = (TileEntityRailgun)te;
                        gun.startTime = System.currentTimeMillis();
                        gun.lastPitch = gun.pitch;
                        gun.lastYaw = gun.yaw;
                        gun.pitch = m.pitch;
                        gun.yaw = m.yaw;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return null;
        }
    }
}

