/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.interfaces.IKeypadHandler;
import com.hbm.util.Keypad;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class KeypadServerPacket
implements IMessage {
    public int x;
    public int y;
    public int z;
    public int type;
    public int data;

    public KeypadServerPacket() {
    }

    public KeypadServerPacket(BlockPos pos, int type, int data) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.type = type;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.type = buf.readInt();
        this.data = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.type);
        buf.writeInt(this.data);
    }

    public static class Handler
    implements IMessageHandler<KeypadServerPacket, IMessage> {
        public IMessage onMessage(KeypadServerPacket m, MessageContext ctx) {
            TileEntity te;
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            BlockPos pos = new BlockPos(m.x, m.y, m.z);
            if (world.func_175667_e(pos) && (te = world.func_175625_s(pos)) instanceof IKeypadHandler) {
                Keypad pad = ((IKeypadHandler)te).getKeypad();
                if (m.type == 0) {
                    pad.buttonClicked(m.data);
                }
            }
            return null;
        }
    }
}

