/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.handler.crt.NTMCraftTweaker;
import com.hbm.inventory.RBMKOutgasserRecipes;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ntm.IrradiationChannel")
public class IrradiationChannel {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, int flux) {
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(input, output, flux));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveRecipe(input));
    }

    public static class ActionRemoveRecipe
    implements IAction {
        private ItemStack input;

        public ActionRemoveRecipe(IItemStack input) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR IrradiationChannel input item can not be an empty/air stack!");
                return;
            }
            RBMKOutgasserRecipes.removeRecipe(this.input);
        }

        public String describe() {
            return "Removing NTM irradiation channel recipe for input " + this.input;
        }
    }

    private static class ActionAddRecipe
    implements IAction {
        private ItemStack input;
        private ItemStack output;
        private int flux = 0;

        public ActionAddRecipe(IItemStack input, IItemStack output, int flux) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.flux = flux;
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR IrradiationChannel recipe input item can not be an empty/air stack!");
                return;
            }
            if (this.output == null || this.output.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR IrradiationChannel recipe output item can not be an empty/air stack!");
                return;
            }
            if (this.flux < 1) {
                CraftTweakerAPI.logError((String)("ERROR IrradiationChannel recipe flux must be >0 not " + this.flux + "!"));
                return;
            }
            RBMKOutgasserRecipes.addRecipe(this.flux, this.input, this.output);
        }

        public String describe() {
            return "Adding NTM irradiation channel recipe (" + this.input + " + " + this.flux + " flux -> " + this.output + ")";
        }
    }
}

