/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.ai;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.render.amlfrom1710.Vec3;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;

public class EntityAIMaskmanLasergun
extends EntityAIBase {
    private EntityCreature owner;
    private EntityLivingBase target;
    private EnumLaserAttack attack;
    private int timer;
    private int attackCount;

    public EntityAIMaskmanLasergun(EntityCreature owner, boolean checkSight, boolean nearbyOnly) {
        this.owner = owner;
        this.attack = EnumLaserAttack.values()[owner.func_70681_au().nextInt(3)];
    }

    public boolean func_75250_a() {
        EntityLivingBase entity = this.owner.func_70638_az();
        if (entity == null) {
            return false;
        }
        this.target = entity;
        double dist = Vec3.createVectorHelper(this.target.field_70165_t - this.owner.field_70165_t, this.target.field_70163_u - this.owner.field_70163_u, this.target.field_70161_v - this.owner.field_70161_v).lengthVector();
        return dist > 10.0;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.owner.func_70661_as().func_75500_f();
    }

    public void func_75246_d() {
        --this.timer;
        if (this.timer <= 0) {
            this.timer = this.attack.delay;
            switch (this.attack) {
                case ORB: {
                    EntityBulletBase orb = new EntityBulletBase(this.owner.field_70170_p, BulletConfigSyncingUtil.MASKMAN_ORB, (EntityLivingBase)this.owner, this.target, 2.0f, 0.0f);
                    orb.field_70181_x += 0.5;
                    this.owner.field_70170_p.func_72838_d((Entity)orb);
                    this.owner.func_184185_a(HBMSoundHandler.teslaShoot, 1.0f, 1.0f);
                    break;
                }
                case MISSILE: {
                    EntityBulletBase missile = new EntityBulletBase(this.owner.field_70170_p, BulletConfigSyncingUtil.MASKMAN_ROCKET, (EntityLivingBase)this.owner, this.target, 1.0f, 0.0f);
                    Vec3 vec = Vec3.createVectorHelper(this.target.field_70165_t - this.owner.field_70165_t, 0.0, this.target.field_70161_v - this.owner.field_70161_v);
                    missile.field_70159_w = vec.xCoord * 0.05;
                    missile.field_70181_x = 0.5 + this.owner.func_70681_au().nextDouble() * 0.5;
                    missile.field_70179_y = vec.zCoord * 0.05;
                    this.owner.field_70170_p.func_72838_d((Entity)missile);
                    this.owner.func_184185_a(HBMSoundHandler.hkShoot, 1.0f, 1.0f);
                    break;
                }
                case SPLASH: {
                    for (int i = 0; i < 5; ++i) {
                        EntityBulletBase tracer = new EntityBulletBase(this.owner.field_70170_p, BulletConfigSyncingUtil.MASKMAN_TRACER, (EntityLivingBase)this.owner, this.target, 1.0f, 0.05f);
                        this.owner.field_70170_p.func_72838_d((Entity)tracer);
                    }
                    break;
                }
            }
            ++this.attackCount;
            if (this.attackCount >= this.attack.amount) {
                this.attackCount = 0;
                int newAtk = this.attack.ordinal() + this.owner.func_70681_au().nextInt(EnumLaserAttack.values().length - 1);
                this.attack = EnumLaserAttack.values()[newAtk % EnumLaserAttack.values().length];
            }
        }
        this.owner.field_70177_z = this.owner.field_70759_as;
    }

    private static enum EnumLaserAttack {
        ORB(60, 5),
        MISSILE(10, 10),
        SPLASH(40, 3);

        public int delay;
        public int amount;

        private EnumLaserAttack(int delay, int amount) {
            this.delay = delay;
            this.amount = amount;
        }
    }
}

