/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import com.paneedah.weaponlib.EntityClassFactory;
import com.paneedah.weaponlib.EntityConfiguration;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.ItemVehicle;
import com.paneedah.weaponlib.vehicle.RenderVehicle2;
import com.paneedah.weaponlib.vehicle.StatefulRenderer;
import com.paneedah.weaponlib.vehicle.VehiclePart;
import com.paneedah.weaponlib.vehicle.VehicleRenderableState;
import com.paneedah.weaponlib.vehicle.VehicleSuspensionStrategy;
import com.paneedah.weaponlib.vehicle.jimphysics.PhysicsConfiguration;
import com.paneedah.weaponlib.vehicle.jimphysics.Transmission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntityVehicleConfiguration
implements EntityConfiguration {
    private static final int DEFAULT_TRACKING_RANGE = 160;
    private static final int DEFAULT_UPDATE_FREQUENCY = 3;
    private SoundEvent enterSound;
    private SoundEvent exitSound;
    private SoundEvent idleSound;
    private SoundEvent runSound;
    private SoundEvent constantRevSound;
    private SoundEvent backfireSound;
    private SoundEvent gearshiftSound;
    public boolean shiftRight;
    public boolean doShiftAnim;
    private SoundEvent rev1;
    private SoundEvent rev2;
    private SoundEvent rev3;
    private SoundEvent rev4;
    private SoundEvent rev5;
    private SoundEvent rev6;
    private double obbLength;
    private double obbWidth;
    private double obbHeight;
    private Builder builder;
    private PhysicsConfiguration physicsConfig;

    public EntityVehicleConfiguration(Builder builder) {
        this.builder = builder;
    }

    public PhysicsConfiguration getPhysicsConfig() {
        return this.physicsConfig;
    }

    public boolean performShiftAnimation() {
        return this.doShiftAnim;
    }

    public boolean shiftWithRight() {
        return this.shiftRight;
    }

    public SoundEvent getRevSound(int id) {
        switch (id) {
            case 1: {
                return this.rev1;
            }
            case 2: {
                return this.rev2;
            }
            case 3: {
                return this.rev3;
            }
            case 4: {
                return this.rev4;
            }
            case 5: {
                return this.rev5;
            }
            case 6: {
                return this.rev6;
            }
        }
        return this.rev1;
    }

    public AxisAlignedBB getAABBforOBB() {
        return new AxisAlignedBB(-this.obbWidth, -this.obbHeight, -this.obbLength, this.obbWidth, this.obbHeight, this.obbLength);
    }

    public SoundEvent getEnterSound() {
        return this.enterSound;
    }

    public SoundEvent getExitSound() {
        return this.exitSound;
    }

    public SoundEvent getIdleSound() {
        return this.idleSound;
    }

    public SoundEvent getRunSound() {
        return this.runSound;
    }

    public SoundEvent getConstantRev() {
        return this.constantRevSound;
    }

    public SoundEvent getBackfireSound() {
        return this.backfireSound;
    }

    public SoundEvent getShiftSound() {
        return this.gearshiftSound;
    }

    public VehicleSuspensionStrategy getSuspensionStrategy() {
        return this.builder.suspensionStrategy;
    }

    public List<Seat> getSeats() {
        return Collections.unmodifiableList(this.builder.seats);
    }

    public Seat getSeatAtIndex(int i) {
        return (Seat)this.builder.seats.get(i);
    }

    public List<VehiclePart> getParts() {
        return this.builder.installedParts;
    }

    public static class Builder {
        private Class<? extends Entity> baseClass = EntityVehicle.class;
        private String name;
        private Supplier<Integer> entityIdSupplier;
        private Transmission transmission;
        private StatefulRenderer<VehicleRenderableState> renderer;
        private double obbLength = 1.0;
        private double obbWidth = 1.0;
        private double obbHeight = 1.0;
        private String enterSound;
        private String exitSound;
        private String idleSound;
        private String runSound;
        private String constantRevSound;
        public boolean doShiftAnim;
        public boolean shiftWRight;
        private String backfireSound;
        private String gearshiftSound;
        private String rev1;
        private String rev2;
        private String rev3;
        private String rev4;
        private String rev5;
        private String rev6;
        private int trackingRange = 160;
        private int updateFrequency = 3;
        private boolean sendVelocityUpdates = true;
        private Function<Double, Double> speedThreshold = s -> 1.5 * s + 0.07;
        private List<Seat> seats = new ArrayList<Seat>();
        private List<VehiclePart> installedParts = new ArrayList<VehiclePart>();
        private VehicleSuspensionStrategy suspensionStrategy = new VehicleSuspensionStrategy.StepSuspensionStrategy(0.01f, 10.0f, 0.01f, 0.1f, 7.0f, 0.01f, 0.3f, 5.0f, 0.05f);
        public PhysicsConfiguration physicsConfig;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPhysicsConfig(PhysicsConfiguration conf) {
            this.physicsConfig = conf;
            return this;
        }

        public Builder withBaseClass(Class<? extends Entity> baseClass) {
            this.baseClass = baseClass;
            return this;
        }

        public Builder withEntityIdSupplier(Supplier<Integer> entityIdSupplier) {
            this.entityIdSupplier = entityIdSupplier;
            return this;
        }

        public Builder withBackfireSound(String backfireSound) {
            this.backfireSound = backfireSound.toLowerCase();
            return this;
        }

        public Builder withEnterSound(String enterSound) {
            this.enterSound = enterSound.toLowerCase();
            return this;
        }

        public Builder withGearshiftSound(String gearshiftSound) {
            this.gearshiftSound = gearshiftSound.toLowerCase();
            return this;
        }

        public Builder withOBBDimensions(double length, double width, double height) {
            this.obbLength = length;
            this.obbWidth = width;
            this.obbHeight = height;
            return this;
        }

        public Builder withExitSound(String exitSound) {
            this.exitSound = exitSound.toLowerCase();
            return this;
        }

        public Builder withConstantRevSound(String constantRev) {
            this.constantRevSound = constantRev.toLowerCase();
            return this;
        }

        public Builder withShiftSettings(boolean perform, boolean rightHand) {
            this.doShiftAnim = perform;
            this.shiftWRight = rightHand;
            return this;
        }

        public Builder withIdleSound(String idleSound) {
            this.idleSound = idleSound.toLowerCase();
            return this;
        }

        public Builder withRevSounds(String baseRevString) {
            this.rev1 = baseRevString.replace("$", "1");
            this.rev2 = baseRevString.replace("$", "2");
            this.rev3 = baseRevString.replace("$", "3");
            this.rev4 = baseRevString.replace("$", "4");
            this.rev5 = baseRevString.replace("$", "5");
            this.rev6 = baseRevString.replace("$", "6");
            return this;
        }

        public Builder withRunSound(String runSound) {
            this.runSound = runSound.toLowerCase();
            return this;
        }

        public Builder customBlock() {
            return this;
        }

        public Builder withSeat(Vec3d seatPos) {
            this.seats.add(new Seat(seatPos));
            return this;
        }

        public Builder withRenderer(StatefulRenderer<VehicleRenderableState> hierarchicalRenderer) {
            this.renderer = hierarchicalRenderer;
            return this;
        }

        public EntityVehicleConfiguration build(ModContext context) {
            int modEntityId = this.entityIdSupplier.get();
            String entityName = this.name != null ? this.name : this.baseClass.getSimpleName() + "Ext" + modEntityId;
            EntityVehicleConfiguration configuration = new EntityVehicleConfiguration(this);
            configuration.enterSound = context.registerSound(this.enterSound);
            configuration.exitSound = context.registerSound(this.exitSound);
            configuration.idleSound = context.registerSound(this.idleSound);
            configuration.runSound = context.registerSound(this.runSound);
            configuration.constantRevSound = context.registerSound(this.constantRevSound);
            configuration.backfireSound = context.registerSound(this.backfireSound);
            configuration.gearshiftSound = context.registerSound(this.gearshiftSound);
            configuration.shiftRight = this.shiftWRight;
            configuration.doShiftAnim = this.doShiftAnim;
            configuration.physicsConfig = this.physicsConfig;
            configuration.obbLength = this.obbLength;
            configuration.obbWidth = this.obbWidth;
            configuration.obbHeight = this.obbHeight;
            configuration.rev1 = context.registerSound(this.rev1);
            configuration.rev2 = context.registerSound(this.rev2);
            configuration.rev3 = context.registerSound(this.rev3);
            configuration.rev4 = context.registerSound(this.rev4);
            configuration.rev5 = context.registerSound(this.rev5);
            configuration.rev6 = context.registerSound(this.rev6);
            Class<? extends Entity> entityClass = EntityClassFactory.getInstance().generateEntitySubclass(this.baseClass, modEntityId, configuration);
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mwc", entityName), entityClass, (String)entityName, (int)modEntityId, (Object)context.getMod(), (int)this.trackingRange, (int)this.updateFrequency, (boolean)this.sendVelocityUpdates);
            ItemVehicle vehicleItem = new ItemVehicle(entityName, entityClass);
            vehicleItem.setRegistryName("mwc", entityName);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)vehicleItem);
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                RendererRegistration.registerRenderableEntity(context, entityClass, this.renderer);
            }
            return new EntityVehicleConfiguration(this);
        }

        public Builder customBlock(Object object) {
            return null;
        }

        private static class RendererRegistration {
            private RendererRegistration() {
            }

            private static void registerRenderableEntity(ModContext modContext, Class<? extends Entity> entityClass, StatefulRenderer<VehicleRenderableState> renderer) {
                modContext.registerRenderableEntity(entityClass, (Object)new RenderVehicle2(renderer));
            }
        }
    }

    public static class Seat {
        Vec3d seatPosition;

        public Seat(Vec3d position) {
            this.seatPosition = position;
        }

        public Vec3d getSeatPosition() {
            return this.seatPosition;
        }
    }
}

