/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.tile;

import com.paneedah.weaponlib.tile.CustomTileEntity;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CustomTileEntityBlock
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private Class<? extends TileEntity> tileEntityClass;
    private Function<IBlockState, AxisAlignedBB> customBoundingBox;

    protected CustomTileEntityBlock(Material material, Class<? extends TileEntity> tileEntityClass) {
        super(material);
        this.tileEntityClass = tileEntityClass;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void setBoundingBox(Function<IBlockState, AxisAlignedBB> customBoundingBox) {
        this.customBoundingBox = customBoundingBox;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.customBoundingBox != null ? this.customBoundingBox.apply(state) : super.func_185496_a(state, source, pos);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState iBlockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        try {
            return this.tileEntityClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot create tile entity from class " + this.tileEntityClass, e);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        CustomTileEntity entity = (CustomTileEntity)world.func_175625_s(pos);
        if (entity != null) {
            entity.onEntityBlockActivated(world, pos, player);
        }
        world.func_147458_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        CustomTileEntity entity = (CustomTileEntity)world.func_175625_s(pos);
        if (entity != null) {
            int side = MathHelper.func_76128_c((double)((double)(player.field_70177_z / 90.0f) + 0.5)) & 3;
            entity.setSide(side);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer.func_174811_aO();
        try {
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        catch (IllegalArgumentException var11) {
            if (!worldIn.field_72995_K && placer instanceof EntityPlayer) {
                placer.func_145747_a((ITextComponent)new TextComponentTranslation("Invalid damage property. Please pick in [0, 1, 2]", new Object[0]));
            }
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, 0, placer).func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
    }
}

