/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.render.WavefrontModel;
import com.paneedah.weaponlib.render.bgl.instancing.InstancedAttribute;
import com.paneedah.weaponlib.render.bgl.instancing.ModelInstancedObject;
import com.paneedah.weaponlib.render.shells.ShellManager;
import com.paneedah.weaponlib.render.shells.ShellParticleSimulator;
import com.paneedah.weaponlib.shader.jim.Uniform;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Quaternion;

public class InstancedShellObject
extends ModelInstancedObject<ShellManager> {
    private ShellParticleSimulator.Shell.Type type;

    public InstancedShellObject(ShellParticleSimulator.Shell.Type type, String shader, WavefrontModel model, int renderMode, int maxCopies, InstancedAttribute ... attribs) {
        super(shader, model, renderMode, maxCopies, attribs);
        this.type = type;
    }

    @Override
    protected void setupShader() {
        super.setupShader();
        this.getRenderShader().withUniforms(new Uniform(){

            @Override
            public void apply(int shader) {
                GL20.glUniform1i((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"lightmap"), (int)1);
            }
        });
    }

    @Override
    public void updateData(ArrayList<ShellParticleSimulator.Shell> shells) {
        this.arrayPointer = 0;
        float[] data = new float[this.getInstanceDataLength() * this.getMaxObjects()];
        for (ShellParticleSimulator.Shell sh : shells) {
            if (sh.getType() != this.type) continue;
            float iX = (float)MatrixHelper.solveLerp(sh.prevPos.x, sh.pos.x, (double)ClientProxy.MC.func_184121_ak());
            float iY = (float)MatrixHelper.solveLerp(sh.prevPos.y, sh.pos.y, (double)ClientProxy.MC.func_184121_ak());
            float iZ = (float)MatrixHelper.solveLerp(sh.prevPos.z, sh.pos.z, (double)ClientProxy.MC.func_184121_ak());
            data[this.arrayPointer++] = iX;
            data[this.arrayPointer++] = iY;
            data[this.arrayPointer++] = iZ;
            double rX = MatrixHelper.solveLerp(sh.prevRot.x, sh.rot.x, (double)ClientProxy.MC.func_184121_ak());
            double rY = MatrixHelper.solveLerp(sh.prevRot.y, sh.rot.y, (double)ClientProxy.MC.func_184121_ak());
            double rZ = MatrixHelper.solveLerp(sh.prevRot.z, sh.rot.z, (double)ClientProxy.MC.func_184121_ak());
            Quaternion quat = MatrixHelper.fromEulerAngles(Math.toRadians(rX), Math.toRadians(rY), Math.toRadians(rZ));
            data[this.arrayPointer++] = quat.w;
            data[this.arrayPointer++] = quat.x;
            data[this.arrayPointer++] = quat.y;
            data[this.arrayPointer++] = quat.z;
            int i = ClientProxy.MC.field_71441_e.func_175626_b(new BlockPos(sh.pos.x, sh.pos.y, sh.pos.z), 0);
            float f = i & 0xFFFF;
            float f1 = i >> 16;
            data[this.arrayPointer++] = (f + 8.0f) / 256.0f;
            data[this.arrayPointer++] = (f1 + 8.0f) / 256.0f;
        }
        this.uploadToBuffer(data);
    }
}

