/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.numerical;

import com.paneedah.weaponlib.numerical.ISimulator;
import com.paneedah.weaponlib.numerical.SpringValue;
import net.minecraft.util.math.Vec3d;

public class SpringVector
implements ISimulator {
    private SpringValue x;
    private SpringValue y;
    private SpringValue z;

    public SpringVector(double mass, double constant, double damper) {
        this.x = new SpringValue(constant, mass, damper);
        this.y = new SpringValue(constant, mass, damper);
        this.z = new SpringValue(constant, mass, damper);
    }

    public Vec3d getPosition() {
        return new Vec3d(this.x.getPosition(), this.y.getPosition(), this.z.getPosition());
    }

    public void addVelocity(double x, double y, double z) {
        this.x.velocity += x;
        this.y.velocity += y;
        this.z.velocity += z;
    }

    public void addPosition(double x, double y, double z) {
        this.x.position += x;
        this.y.position += y;
        this.z.position += z;
    }

    public void setXSpringParam(double mass, double constant, double damper) {
        this.x.setDamping(damper);
        this.x.setMass(mass);
        this.x.setSpringConstant(constant);
    }

    public void setYSpringParam(double mass, double constant, double damper) {
        this.y.setDamping(damper);
        this.y.setMass(mass);
        this.y.setSpringConstant(constant);
    }

    public void setZSpringParam(double mass, double constant, double damper) {
        this.z.setDamping(damper);
        this.z.setMass(mass);
        this.z.setSpringConstant(constant);
    }

    public void setDampening(double d) {
        this.x.setDamping(d);
        this.y.setDamping(d);
        this.z.setDamping(d);
    }

    public void setConstant(double k) {
        this.x.setSpringConstant(k);
        this.y.setSpringConstant(k);
        this.z.setSpringConstant(k);
    }

    public void setMass(double m) {
        this.x.setMass(m);
        this.y.setMass(m);
        this.z.setMass(m);
    }

    @Override
    public void update(double dt) {
        this.x.update(dt);
        this.y.update(dt);
        this.z.update(dt);
    }

    public void setPosition(double x, double y, double z) {
        this.x.setPosition(x);
        this.y.setPosition(y);
        this.z.setPosition(z);
    }

    public Vec3d getInterpolatedVec() {
        return new Vec3d(this.x.getLerpedPosition(), this.y.getLerpedPosition(), this.z.getLerpedPosition());
    }

    public Vec3d getInterpolatedVec(double mu) {
        return new Vec3d(this.x.getLerpedPosition(mu), this.y.getLerpedPosition(mu), this.z.getLerpedPosition(mu));
    }
}

