/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.melee;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.renderer.ModelSource;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.AttachmentContainer;
import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.CompatibleAttachment;
import com.paneedah.weaponlib.CustomRenderer;
import com.paneedah.weaponlib.DefaultPart;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ItemSkin;
import com.paneedah.weaponlib.ModelWithAttachments;
import com.paneedah.weaponlib.Part;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.Tuple;
import com.paneedah.weaponlib.WeaponRenderer;
import com.paneedah.weaponlib.animation.DebugPositioner;
import com.paneedah.weaponlib.animation.MultipartPositioning;
import com.paneedah.weaponlib.animation.MultipartRenderStateManager;
import com.paneedah.weaponlib.animation.MultipartTransition;
import com.paneedah.weaponlib.animation.MultipartTransitionProvider;
import com.paneedah.weaponlib.animation.Transition;
import com.paneedah.weaponlib.melee.AsyncMeleeState;
import com.paneedah.weaponlib.melee.ItemMelee;
import com.paneedah.weaponlib.melee.MeleeSkin;
import com.paneedah.weaponlib.melee.PlayerMeleeInstance;
import com.paneedah.weaponlib.melee.RenderableState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class MeleeRenderer
extends ModelSource
implements IBakedModel {
    private static final float DEFAULT_RANDOMIZING_RATE = 0.33f;
    private static final float DEFAULT_NORMAL_RANDOMIZING_AMPLITUDE = 0.06f;
    private static final int DEFAULT_ANIMATION_DURATION = 70;
    protected ItemStack itemStack;
    protected ModelResourceLocation resourceLocation;
    private ItemOverrideList itemOverrideList = new WeaponItemOverrideList(Collections.emptyList());
    ItemCameraTransforms.TransformType transformType;
    protected EntityPlayer player;
    protected TextureManager textureManager;
    private Pair<? extends IBakedModel, Matrix4f> pair;
    private Builder builder;
    private Map<EntityPlayer, MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>>> firstPersonStateManagers;
    private MultipartTransitionProvider<RenderableState, Part, RenderContext<RenderableState>> weaponTransitionProvider;
    protected ClientModContext clientModContext;

    private MeleeRenderer(Builder builder) {
        this.builder = builder;
        this.firstPersonStateManagers = new HashMap<EntityPlayer, MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>>>();
        this.weaponTransitionProvider = new WeaponPositionProvider();
        this.textureManager = ClientProxy.MC.func_110434_K();
        this.pair = Pair.of((Object)this, null);
    }

    protected long getTotalAttackDuration() {
        return this.builder.totalAttackingDuration;
    }

    protected long getTotalHeavyAttackDuration() {
        return this.builder.totalHeavyAttackingDuration;
    }

    protected ClientModContext getClientModContext() {
        return this.clientModContext;
    }

    public void setClientModContext(ClientModContext clientModContext) {
        this.clientModContext = clientModContext;
    }

    protected StateDescriptor getStateDescriptor(EntityPlayer player, ItemStack itemStack) {
        MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager;
        float amplitude = this.builder.normalRandomizingAmplitude;
        float rate = this.builder.normalRandomizingRate;
        RenderableState currentState = null;
        PlayerItemInstance<?> playerItemInstance = this.clientModContext.getPlayerItemInstanceRegistry().getItemInstance((EntityLivingBase)player, itemStack);
        PlayerMeleeInstance playerMeleeInstance = null;
        if (playerItemInstance == null || !(playerItemInstance instanceof PlayerMeleeInstance) || playerItemInstance.getItem() != itemStack.func_77973_b()) {
            ModReference.LOG.error("Invalid or mismatching item. Player item instance: {}. Item stack: {}", playerItemInstance, (Object)itemStack);
        } else {
            playerMeleeInstance = (PlayerMeleeInstance)playerItemInstance;
        }
        if (playerMeleeInstance != null) {
            AsyncMeleeState asyncWeaponState = this.getNextNonExpiredState(playerMeleeInstance);
            switch (asyncWeaponState.getState()) {
                case ATTACKING: 
                case ATTACKING_STABBING: {
                    currentState = RenderableState.ATTACKING;
                    break;
                }
                case HEAVY_ATTACKING: 
                case HEAVY_ATTACKING_STABBING: {
                    currentState = RenderableState.HEAVY_ATTACKING;
                    break;
                }
                case MODIFYING: 
                case MODIFYING_REQUESTED: 
                case NEXT_ATTACHMENT: 
                case NEXT_ATTACHMENT_REQUESTED: {
                    currentState = RenderableState.MODIFYING;
                    break;
                }
                default: {
                    if (!player.func_70051_ag() || this.builder.firstPersonPositioningRunning == null) break;
                    currentState = RenderableState.RUNNING;
                }
            }
            ModReference.LOG.trace("Rendering state {} created from {}", (Object)currentState, (Object)asyncWeaponState.getState());
        }
        if (currentState == null) {
            currentState = RenderableState.NORMAL;
        }
        if ((stateManager = this.firstPersonStateManagers.get(player)) == null) {
            stateManager = new MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>>(currentState, this.weaponTransitionProvider);
            this.firstPersonStateManagers.put(player, stateManager);
        } else {
            stateManager.setState(currentState, true, currentState == RenderableState.ATTACKING);
        }
        return new StateDescriptor(playerMeleeInstance, stateManager, rate, amplitude);
    }

    private AsyncMeleeState getNextNonExpiredState(PlayerMeleeInstance playerWeaponState) {
        AsyncMeleeState asyncWeaponState = null;
        while ((asyncWeaponState = playerWeaponState.nextHistoryState()) != null && System.currentTimeMillis() > asyncWeaponState.getTimestamp() + asyncWeaponState.getDuration()) {
        }
        return asyncWeaponState;
    }

    private Consumer<RenderContext<RenderableState>> createWeaponPartPositionFunction(Transition<RenderContext<RenderableState>> t) {
        if (t == null) {
            return context -> {};
        }
        Consumer<RenderContext<RenderableState>> weaponPositionFunction = t.getItemPositioning();
        if (weaponPositionFunction != null) {
            return context -> weaponPositionFunction.accept((RenderContext<RenderableState>)context);
        }
        return context -> {};
    }

    private Consumer<RenderContext<RenderableState>> createWeaponPartPositionFunction(Consumer<RenderContext<RenderableState>> weaponPositionFunction) {
        if (weaponPositionFunction != null) {
            return context -> weaponPositionFunction.accept((RenderContext<RenderableState>)context);
        }
        return context -> {};
    }

    private List<MultipartTransition<Part, RenderContext<RenderableState>>> getComplexTransition(List<Transition<RenderContext<RenderableState>>> wt, List<Transition<RenderContext<RenderableState>>> lht, List<Transition<RenderContext<RenderableState>>> rht, LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> custom) {
        ArrayList<MultipartTransition<Part, RenderContext<RenderableState>>> result = new ArrayList<MultipartTransition<Part, RenderContext<RenderableState>>>();
        for (int i = 0; i < wt.size(); ++i) {
            DebugPositioner.TransitionConfiguration transitionConfiguration;
            Transition<RenderContext<RenderableState>> p = wt.get(i);
            Transition<RenderContext<RenderableState>> l = lht.get(i);
            Transition<RenderContext<RenderableState>> r = rht.get(i);
            long pause = p.getPause();
            if (DebugPositioner.isDebugModeEnabled() && (transitionConfiguration = DebugPositioner.getTransitionConfiguration(i, false)) != null) {
                pause = transitionConfiguration.getPause();
            }
            MultipartTransition<Part, RenderContext<RenderableState>> t = new MultipartTransition<Part, RenderContext<RenderableState>>(p.getDuration(), pause).withPartPositionFunction(Part.MAIN_ITEM, this.createWeaponPartPositionFunction(p)).withPartPositionFunction(Part.LEFT_HAND, this.createWeaponPartPositionFunction(l)).withPartPositionFunction(Part.RIGHT_HAND, this.createWeaponPartPositionFunction(r));
            for (Map.Entry<Part, List<Transition<RenderContext<RenderableState>>>> e : custom.entrySet()) {
                List<Transition<RenderContext<RenderableState>>> partTransitions = e.getValue();
                Transition<RenderContext<RenderableState>> partTransition = null;
                if (partTransitions != null && partTransitions.size() > i) {
                    partTransition = partTransitions.get(i);
                } else {
                    ModReference.LOG.warn("Transition not defined for part {}", custom);
                }
                t.withPartPositionFunction(e.getKey(), this.createWeaponPartPositionFunction(partTransition));
            }
            result.add(t);
        }
        return result;
    }

    private List<MultipartTransition<Part, RenderContext<RenderableState>>> getSimpleTransition(Consumer<RenderContext<RenderableState>> w, Consumer<RenderContext<RenderableState>> lh, Consumer<RenderContext<RenderableState>> rh, LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> custom, int duration) {
        MultipartTransition<Part, RenderContext<RenderableState>> mt = new MultipartTransition<Part, RenderContext<RenderableState>>(duration, 0L).withPartPositionFunction(Part.MAIN_ITEM, this.createWeaponPartPositionFunction(w)).withPartPositionFunction(Part.LEFT_HAND, this.createWeaponPartPositionFunction(lh)).withPartPositionFunction(Part.RIGHT_HAND, this.createWeaponPartPositionFunction(rh));
        custom.forEach((part, position) -> mt.withPartPositionFunction((Part)part, this.createWeaponPartPositionFunction((Consumer<RenderContext<RenderableState>>)position)));
        return Collections.singletonList(mt);
    }

    public void renderItem(ItemStack weaponItemStack, RenderContext<RenderableState> renderContext, MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner) {
        List<CompatibleAttachment<? extends AttachmentContainer>> attachments = null;
        if (this.builder.getModel() instanceof ModelWithAttachments) {
            attachments = ((ItemMelee)weaponItemStack.func_77973_b()).getActiveAttachments(renderContext.getPlayer(), weaponItemStack);
        }
        if (this.builder.getTextureName() != null) {
            ClientProxy.MC.field_71446_o.func_110577_a(new ResourceLocation("mwc:textures/models/" + this.builder.getTextureName()));
        } else {
            int textureIndex;
            PlayerItemInstance<?> itemInstance;
            String textureName = null;
            CompatibleAttachment compatibleSkin = attachments.stream().filter(ca -> ca.getAttachment() instanceof MeleeSkin).findAny().orElse(null);
            if (compatibleSkin != null && (itemInstance = this.getClientModContext().getPlayerItemInstanceRegistry().getItemInstance(renderContext.getPlayer(), weaponItemStack)) instanceof PlayerMeleeInstance && (textureIndex = ((PlayerMeleeInstance)itemInstance).getActiveTextureIndex()) >= 0) {
                textureName = ((MeleeSkin)compatibleSkin.getAttachment()).getTextureVariant(textureIndex) + ".png";
            }
            if (textureName == null) {
                ItemMelee weapon = (ItemMelee)weaponItemStack.func_77973_b();
                textureName = weapon.getTextureName();
            }
            ClientProxy.MC.field_71446_o.func_110577_a(new ResourceLocation("mwc:textures/models/" + textureName));
        }
        this.builder.getModel().func_78088_a(null, renderContext.getLimbSwing(), renderContext.getFlimbSwingAmount(), renderContext.getAgeInTicks(), renderContext.getNetHeadYaw(), renderContext.getHeadPitch(), renderContext.getScale());
        if (attachments != null) {
            this.renderAttachments(positioner, renderContext, attachments);
        }
    }

    public void renderAttachments(MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner, RenderContext<RenderableState> renderContext, List<CompatibleAttachment<? extends AttachmentContainer>> attachments) {
        for (CompatibleAttachment<? extends AttachmentContainer> compatibleAttachment : attachments) {
            if (compatibleAttachment == null || compatibleAttachment.getAttachment() instanceof ItemSkin) continue;
            this.renderCompatibleAttachment(compatibleAttachment, positioner, renderContext);
        }
    }

    private void renderCompatibleAttachment(CompatibleAttachment<?> compatibleAttachment, MultipartPositioning.Positioner<Part, RenderContext<RenderableState>> positioner, RenderContext<RenderableState> renderContext) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8193);
        if (compatibleAttachment.getPositioning() instanceof BiConsumer) {
            ((BiConsumer)compatibleAttachment.getPositioning()).accept(renderContext.getPlayer(), renderContext.getWeapon());
        } else if (compatibleAttachment.getPositioning() instanceof Consumer) {
            ((Consumer)compatibleAttachment.getPositioning()).accept(renderContext);
        }
        ItemAttachment<?> itemAttachment = compatibleAttachment.getAttachment();
        if (positioner != null) {
            if (itemAttachment instanceof Part) {
                positioner.position((Part)((Object)itemAttachment), renderContext);
            } else if (itemAttachment.getRenderablePart() != null) {
                positioner.position(itemAttachment.getRenderablePart(), renderContext);
            }
        }
        for (Tuple<ModelBase, String> texturedModel : compatibleAttachment.getAttachment().getTexturedModels()) {
            ClientProxy.MC.field_71446_o.func_110577_a(new ResourceLocation("mwc:textures/models/" + texturedModel.getV()));
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8193);
            if (compatibleAttachment.getModelPositioning() != null) {
                compatibleAttachment.getModelPositioning().accept(texturedModel.getU());
            }
            texturedModel.getU().func_78088_a((Entity)renderContext.getPlayer(), renderContext.getLimbSwing(), renderContext.getFlimbSwingAmount(), renderContext.getAgeInTicks(), renderContext.getNetHeadYaw(), renderContext.getHeadPitch(), renderContext.getScale());
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        CustomRenderer<?> postRenderer = compatibleAttachment.getAttachment().getPostRenderer();
        if (postRenderer != null) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8193);
            postRenderer.render(renderContext);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        for (CompatibleAttachment<?> childAttachment : itemAttachment.getAttachments()) {
            this.renderCompatibleAttachment(childAttachment, positioner, renderContext);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public boolean hasRecoilPositioning() {
        return this.builder.hasRecoilPositioningDefined;
    }

    protected BiConsumer<Part, RenderContext<RenderableState>> getPartDebugPositioning() {
        return this.builder.partDebugPositioning;
    }

    public final boolean func_177555_b() {
        return true;
    }

    public final boolean func_177556_c() {
        return true;
    }

    public final boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return ClientProxy.MC.func_147117_R().func_174944_f();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return this.itemOverrideList;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        this.transformType = cameraTransformType;
        return this.pair;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (ForgeModContainer.allowEmissiveItems) {
            return Collections.emptyList();
        }
        if (this.itemStack == null) {
            return Collections.emptyList();
        }
        if (this.transformType == ItemCameraTransforms.TransformType.GROUND || this.transformType == ItemCameraTransforms.TransformType.GUI || this.transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || this.transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            tessellator.func_78381_a();
            GlStateManager.func_179094_E();
            if (this.player != null && this.transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND && this.player.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
            }
            if (this.onGround()) {
                GlStateManager.func_179152_a((float)-3.0f, (float)-3.0f, (float)-3.0f);
            }
            int currentTextureId = GlStateManager.func_187397_v((int)32873);
            this.renderItem();
            if (currentTextureId != 0) {
                GlStateManager.func_179144_i((int)currentTextureId);
            }
            GlStateManager.func_179121_F();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        }
        this.player = null;
        this.itemStack = null;
        this.transformType = null;
        return Collections.emptyList();
    }

    protected boolean onGround() {
        return this.transformType == null;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem() {
        GL11.glPushMatrix();
        RenderContext<RenderableState> renderContext = new RenderContext<RenderableState>((EntityLivingBase)this.player, this.itemStack);
        renderContext.setAgeInTicks(-0.4f);
        renderContext.setScale(0.08f);
        renderContext.setCompatibleTransformType(this.transformType);
        MultipartPositioning.Positioner positioner = null;
        switch (this.transformType) {
            case GROUND: {
                GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
                GL11.glScaled((double)0.35f, (double)0.35f, (double)0.35f);
                GL11.glTranslatef((float)-0.7f, (float)-1.0f, (float)-0.1f);
                GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.builder.getEntityPositioning().accept(this.itemStack);
                break;
            }
            case GUI: {
                GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
                GL11.glScaled((double)0.6f, (double)0.6f, (double)0.6f);
                GL11.glTranslatef((float)-0.7f, (float)-0.8f, (float)-0.1f);
                GL11.glRotatef((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)40.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.builder.getInventoryPositioning().accept(this.itemStack);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
                GL11.glScaled((double)0.4f, (double)0.4f, (double)0.4f);
                GL11.glTranslatef((float)-1.33f, (float)-2.0f, (float)0.7f);
                GL11.glRotatef((float)-70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.builder.getThirdPersonPositioning().accept(renderContext);
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: {
                WeaponRenderer.fixVersionSpecificFirstPersonPositioning(this.transformType);
                GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
                StateDescriptor stateDescriptor = this.getStateDescriptor(this.player, this.itemStack);
                renderContext.setPlayerItemInstance(stateDescriptor.instance);
                MultipartPositioning<Part, RenderContext<RenderableState>> multipartPositioning = stateDescriptor.stateManager.nextPositioning();
                renderContext.setTransitionProgress(multipartPositioning.getProgress());
                renderContext.setFromState(multipartPositioning.getFromState(RenderableState.class));
                renderContext.setToState(multipartPositioning.getToState(RenderableState.class));
                positioner = multipartPositioning.getPositioner();
                WeaponRenderer.renderLeftArm((EntityLivingBase)this.player, renderContext, positioner);
                WeaponRenderer.renderRightArm((EntityLivingBase)this.player, renderContext, positioner);
                positioner.position(Part.MAIN_ITEM, renderContext);
                if (!DebugPositioner.isDebugModeEnabled()) break;
                DebugPositioner.position(Part.MAIN_ITEM, renderContext);
                break;
            }
        }
        this.renderItem(this.itemStack, renderContext, positioner);
        GL11.glPopMatrix();
    }

    private class WeaponPositionProvider
    implements MultipartTransitionProvider<RenderableState, Part, RenderContext<RenderableState>> {
        private WeaponPositionProvider() {
        }

        @Override
        public List<MultipartTransition<Part, RenderContext<RenderableState>>> getTransitions(RenderableState state) {
            switch (state) {
                case MODIFYING: {
                    return MeleeRenderer.this.getSimpleTransition(MeleeRenderer.this.builder.firstPersonPositioningModifying, MeleeRenderer.this.builder.firstPersonLeftHandPositioningModifying, MeleeRenderer.this.builder.firstPersonRightHandPositioningModifying, MeleeRenderer.this.builder.firstPersonCustomPositioning, ((MeleeRenderer)MeleeRenderer.this).builder.animationDuration);
                }
                case RUNNING: {
                    return MeleeRenderer.this.getSimpleTransition(MeleeRenderer.this.builder.firstPersonPositioningRunning, MeleeRenderer.this.builder.firstPersonLeftHandPositioningRunning, MeleeRenderer.this.builder.firstPersonRightHandPositioningRunning, MeleeRenderer.this.builder.firstPersonCustomPositioning, ((MeleeRenderer)MeleeRenderer.this).builder.animationDuration);
                }
                case ATTACKING: {
                    return MeleeRenderer.this.getComplexTransition(MeleeRenderer.this.builder.firstPersonPositioningAttacking, MeleeRenderer.this.builder.firstPersonLeftHandPositioningAttacking, MeleeRenderer.this.builder.firstPersonRightHandPositioningAttacking, MeleeRenderer.this.builder.firstPersonCustomPositioningAttacking);
                }
                case HEAVY_ATTACKING: {
                    return MeleeRenderer.this.getComplexTransition(MeleeRenderer.this.builder.firstPersonPositioningHeavyAttacking, MeleeRenderer.this.builder.firstPersonLeftHandPositioningHeavyAttacking, MeleeRenderer.this.builder.firstPersonRightHandPositioningHeavyAttacking, MeleeRenderer.this.builder.firstPersonCustomPositioningHeavyAttacking);
                }
                case NORMAL: {
                    return MeleeRenderer.this.getSimpleTransition(MeleeRenderer.this.builder.firstPersonPositioning, MeleeRenderer.this.builder.firstPersonLeftHandPositioning, MeleeRenderer.this.builder.firstPersonRightHandPositioning, MeleeRenderer.this.builder.firstPersonCustomPositioning, ((MeleeRenderer)MeleeRenderer.this).builder.animationDuration);
                }
            }
            return null;
        }
    }

    public static class Builder {
        private ModelBase model;
        private String textureName;
        private BiConsumer<Part, RenderContext<RenderableState>> partDebugPositioning;
        private Consumer<ItemStack> entityPositioning;
        private Consumer<ItemStack> inventoryPositioning;
        private Consumer<RenderContext<RenderableState>> thirdPersonPositioning;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioning;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningRunning;
        private Consumer<RenderContext<RenderableState>> firstPersonPositioningModifying;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioning;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningRunning;
        private Consumer<RenderContext<RenderableState>> firstPersonLeftHandPositioningModifying;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioning;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningRunning;
        private Consumer<RenderContext<RenderableState>> firstPersonRightHandPositioningModifying;
        private List<Transition<RenderContext<RenderableState>>> firstPersonPositioningAttacking;
        private List<Transition<RenderContext<RenderableState>>> firstPersonLeftHandPositioningAttacking;
        private List<Transition<RenderContext<RenderableState>>> firstPersonRightHandPositioningAttacking;
        private List<Transition<RenderContext<RenderableState>>> firstPersonPositioningHeavyAttacking;
        private List<Transition<RenderContext<RenderableState>>> firstPersonLeftHandPositioningHeavyAttacking;
        private List<Transition<RenderContext<RenderableState>>> firstPersonRightHandPositioningHeavyAttacking;
        private long totalAttackingDuration;
        private long totalHeavyAttackingDuration;
        private float normalRandomizingRate = 0.33f;
        private float normalRandomizingAmplitude = 0.06f;
        private LinkedHashMap<Part, Consumer<RenderContext<RenderableState>>> firstPersonCustomPositioning = new LinkedHashMap();
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> firstPersonCustomPositioningAttacking = new LinkedHashMap();
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> firstPersonCustomPositioningHeavyAttacking = new LinkedHashMap();
        private LinkedHashMap<Part, List<Transition<RenderContext<RenderableState>>>> firstPersonCustomPositioningEjectSpentRound = new LinkedHashMap();
        private boolean hasRecoilPositioningDefined;
        public int animationDuration = 70;

        public Builder withModel(ModelBase model) {
            this.model = model;
            return this;
        }

        public Builder withAnimationDuration(int animationDuration) {
            this.animationDuration = animationDuration;
            return this;
        }

        public Builder withNormalRandomizingRate(float normalRandomizingRate) {
            this.normalRandomizingRate = normalRandomizingRate;
            return this;
        }

        public Builder withTextureName(String textureName) {
            this.textureName = textureName + ".png";
            return this;
        }

        public Builder withEntityPositioning(Consumer<ItemStack> entityPositioning) {
            this.entityPositioning = entityPositioning;
            return this;
        }

        public Builder withInventoryPositioning(Consumer<ItemStack> inventoryPositioning) {
            this.inventoryPositioning = inventoryPositioning;
            return this;
        }

        public Builder withPartDebugPositioning(BiConsumer<Part, RenderContext<RenderableState>> partDebugPositioning) {
            this.partDebugPositioning = partDebugPositioning;
            return this;
        }

        public Builder withThirdPersonPositioning(Consumer<RenderContext<RenderableState>> thirdPersonPositioning) {
            this.thirdPersonPositioning = thirdPersonPositioning;
            return this;
        }

        public Builder withFirstPersonPositioning(Consumer<RenderContext<RenderableState>> firstPersonPositioning) {
            this.firstPersonPositioning = firstPersonPositioning;
            return this;
        }

        public Builder withFirstPersonPositioningRunning(Consumer<RenderContext<RenderableState>> firstPersonPositioningRunning) {
            this.firstPersonPositioningRunning = firstPersonPositioningRunning;
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningAttacking(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonPositioningAttacking = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningHeavyAttacking(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonPositioningHeavyAttacking = Arrays.asList(transitions);
            return this;
        }

        public Builder withFirstPersonPositioningModifying(Consumer<RenderContext<RenderableState>> firstPersonPositioningModifying) {
            this.firstPersonPositioningModifying = firstPersonPositioningModifying;
            return this;
        }

        public Builder withFirstPersonHandPositioning(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            this.firstPersonLeftHandPositioning = leftHand;
            this.firstPersonRightHandPositioning = rightHand;
            return this;
        }

        public Builder withFirstPersonHandPositioningRunning(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            this.firstPersonLeftHandPositioningRunning = leftHand;
            this.firstPersonRightHandPositioningRunning = rightHand;
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningAttacking(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonLeftHandPositioningAttacking = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningHeavyAttacking(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonLeftHandPositioningHeavyAttacking = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningHeavyAttacking(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonRightHandPositioningHeavyAttacking = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningAttacking(Transition<RenderContext<RenderableState>> ... transitions) {
            this.firstPersonRightHandPositioningAttacking = Arrays.asList(transitions);
            return this;
        }

        public Builder withFirstPersonHandPositioningModifying(Consumer<RenderContext<RenderableState>> leftHand, Consumer<RenderContext<RenderableState>> rightHand) {
            this.firstPersonLeftHandPositioningModifying = leftHand;
            this.firstPersonRightHandPositioningModifying = rightHand;
            return this;
        }

        public Builder withFirstPersonCustomPositioning(Part part, Consumer<RenderContext<RenderableState>> positioning) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            if (this.firstPersonCustomPositioning.put(part, positioning) != null) {
                throw new IllegalArgumentException("Part " + part + " already added");
            }
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningAttacking(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningAttacking.put(part, Arrays.asList(transitions));
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningHeavyAttacking(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningHeavyAttacking.put(part, Arrays.asList(transitions));
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningEjectSpentRound(Part part, Transition<RenderContext<RenderableState>> ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningEjectSpentRound.put(part, Arrays.asList(transitions));
            return this;
        }

        public MeleeRenderer build() {
            if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
                return null;
            }
            if (this.inventoryPositioning == null) {
                this.inventoryPositioning = itemStack -> GL11.glTranslatef((float)0.0f, (float)0.12f, (float)0.0f);
            }
            if (this.entityPositioning == null) {
                this.entityPositioning = itemStack -> {};
            }
            MeleeRenderer renderer = new MeleeRenderer(this);
            if (this.firstPersonPositioning == null) {
                this.firstPersonPositioning = renderContext -> {};
            }
            if (this.firstPersonPositioningAttacking == null) {
                this.firstPersonPositioningAttacking = Collections.singletonList(new Transition<RenderContext<RenderableState>>(this.firstPersonPositioning, this.animationDuration));
            }
            if (this.firstPersonPositioningHeavyAttacking == null) {
                this.firstPersonPositioningHeavyAttacking = Collections.singletonList(new Transition<RenderContext<RenderableState>>(this.firstPersonPositioning, this.animationDuration));
            }
            for (Transition<RenderContext<RenderableState>> t2 : this.firstPersonPositioningAttacking) {
                this.totalAttackingDuration += t2.getDuration();
                this.totalAttackingDuration += t2.getPause();
            }
            for (Transition<RenderContext<RenderableState>> t2 : this.firstPersonPositioningHeavyAttacking) {
                this.totalHeavyAttackingDuration += t2.getDuration();
                this.totalHeavyAttackingDuration += t2.getPause();
            }
            if (this.firstPersonPositioningRunning == null) {
                this.firstPersonPositioningRunning = this.firstPersonPositioning;
            }
            if (this.firstPersonPositioningModifying == null) {
                this.firstPersonPositioningModifying = this.firstPersonPositioning;
            }
            if (this.thirdPersonPositioning == null) {
                this.thirdPersonPositioning = context -> {
                    GL11.glTranslatef((float)-0.4f, (float)0.2f, (float)0.4f);
                    GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                };
            }
            if (this.firstPersonLeftHandPositioning == null) {
                this.firstPersonLeftHandPositioning = context -> {};
            }
            if (this.firstPersonLeftHandPositioningAttacking == null) {
                this.firstPersonLeftHandPositioningAttacking = this.firstPersonPositioningAttacking.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonLeftHandPositioningHeavyAttacking == null) {
                this.firstPersonLeftHandPositioningHeavyAttacking = this.firstPersonPositioningHeavyAttacking.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonRightHandPositioningHeavyAttacking == null) {
                this.firstPersonRightHandPositioningHeavyAttacking = this.firstPersonPositioningHeavyAttacking.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonLeftHandPositioningRunning == null) {
                this.firstPersonLeftHandPositioningRunning = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningModifying == null) {
                this.firstPersonLeftHandPositioningModifying = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonRightHandPositioning == null) {
                this.firstPersonRightHandPositioning = context -> {};
            }
            if (this.firstPersonRightHandPositioningAttacking == null) {
                this.firstPersonRightHandPositioningAttacking = this.firstPersonPositioningAttacking.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonRightHandPositioningHeavyAttacking == null) {
                this.firstPersonRightHandPositioningHeavyAttacking = this.firstPersonPositioningHeavyAttacking.stream().map(t -> new Transition<RenderContext>(c -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonRightHandPositioningRunning == null) {
                this.firstPersonRightHandPositioningRunning = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningModifying == null) {
                this.firstPersonRightHandPositioningModifying = this.firstPersonRightHandPositioning;
            }
            this.firstPersonCustomPositioningAttacking.forEach((p, t) -> {
                if (t.size() != this.firstPersonPositioningAttacking.size()) {
                    throw new IllegalStateException("Custom reloading transition number mismatch. Expected " + this.firstPersonPositioningAttacking.size() + ", actual: " + t.size());
                }
            });
            this.firstPersonCustomPositioningHeavyAttacking.forEach((p, t) -> {
                if (t.size() != this.firstPersonPositioningHeavyAttacking.size()) {
                    throw new IllegalStateException("Custom reloading transition number mismatch. Expected " + this.firstPersonPositioningAttacking.size() + ", actual: " + t.size());
                }
            });
            return renderer;
        }

        public Consumer<ItemStack> getEntityPositioning() {
            return this.entityPositioning;
        }

        public Consumer<ItemStack> getInventoryPositioning() {
            return this.inventoryPositioning;
        }

        public Consumer<RenderContext<RenderableState>> getThirdPersonPositioning() {
            return this.thirdPersonPositioning;
        }

        public String getTextureName() {
            return this.textureName;
        }

        public ModelBase getModel() {
            return this.model;
        }
    }

    private class WeaponItemOverrideList
    extends ItemOverrideList {
        public WeaponItemOverrideList(List<ItemOverride> overridesIn) {
            super(overridesIn);
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            MeleeRenderer.this.itemStack = stack;
            MeleeRenderer.this.player = (EntityPlayer)entity;
            return super.handleItemState(originalModel, stack, world, entity);
        }
    }

    protected static class StateDescriptor {
        protected MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager;
        protected float rate;
        protected float amplitude = 0.04f;
        private PlayerMeleeInstance instance;

        public StateDescriptor(PlayerMeleeInstance instance, MultipartRenderStateManager<RenderableState, Part, RenderContext<RenderableState>> stateManager, float rate, float amplitude) {
            this.instance = instance;
            this.stateManager = stateManager;
            this.rate = rate;
            this.amplitude = amplitude;
        }
    }
}

