/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.grenade;

import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.Explosion;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.grenade.AbstractEntityGrenade;
import com.paneedah.weaponlib.grenade.ItemGrenade;
import io.netty.buffer.ByteBuf;
import io.redstudioragnarok.redcore.vectors.Vector3D;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityGrenade
extends AbstractEntityGrenade {
    private long explosionTimeout;
    private float explosionStrength;
    private boolean destroyBlocks;
    private long activationTimestamp;

    private EntityGrenade(ModContext modContext, ItemGrenade itemGrenade, EntityLivingBase thrower, float velocity, float gravityVelocity, float rotationSlowdownFactor) {
        super(modContext, itemGrenade, thrower, velocity, gravityVelocity, rotationSlowdownFactor);
    }

    public EntityGrenade(World world) {
        super(world);
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeLong(this.activationTimestamp);
        buffer.writeLong(this.explosionTimeout);
        buffer.writeFloat(this.explosionStrength);
        buffer.writeBoolean(this.destroyBlocks);
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        super.readSpawnData(buffer);
        this.activationTimestamp = buffer.readLong();
        this.explosionTimeout = buffer.readLong();
        this.explosionStrength = buffer.readFloat();
        this.destroyBlocks = buffer.readBoolean();
    }

    @Override
    public void onGrenadeUpdate() {
        if (!this.field_70170_p.field_72995_K && this.explosionTimeout > 0L && System.currentTimeMillis() > this.activationTimestamp + this.explosionTimeout) {
            this.explode();
            return;
        }
    }

    @Override
    public void onBounce(RayTraceResult movingobjectposition) {
        if (this.explosionTimeout == -1L && !this.field_70170_p.field_72995_K) {
            this.explode();
        } else {
            super.onBounce(movingobjectposition);
        }
    }

    private void explode() {
        ModReference.LOG.debug("Exploding {}", (Object)this);
        Explosion.createServerSideExplosion(this.field_70170_p, this.getThrower(), this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionStrength, false, true, this.destroyBlocks, 1.0f, 1.0f, 1.5f, 1.0f, null, null, this.modContext.getExplosionSound());
        List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(5.0, 5.0, 5.0));
        float damageCoefficient = (float)ModernConfigManager.explosionDamage;
        float effectiveRadius = this.itemGrenade.getEffectiveRadius() * damageCoefficient;
        float fragmentDamage = this.itemGrenade.getFragmentDamage();
        float configuredFragmentCount = (float)this.itemGrenade.getFragmentCount() * damageCoefficient;
        int i = 0;
        while ((float)i < configuredFragmentCount) {
            double z;
            double y;
            double x = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
            double d2 = x * x + (y = (this.field_70146_Z.nextDouble() - 0.5) * 2.0) * y + (z = (this.field_70146_Z.nextDouble() - 0.5) * 2.0) * z;
            if (d2 == 0.0) {
                ModReference.LOG.debug("Ignoring zero distance index {}", (Object)i);
            } else {
                double k = Math.sqrt((double)(effectiveRadius * effectiveRadius) / d2);
                double k2 = 0.1;
                Vector3D cvec1 = new Vector3D(this.field_70165_t + x * k2, this.field_70163_u + y * k2, this.field_70161_v + z * k2);
                Vector3D cvec10 = new Vector3D(this.field_70165_t + x * k2, this.field_70163_u + y * k2, this.field_70161_v + z * k2);
                Vector3D cvec2 = new Vector3D(this.field_70165_t + x * k, this.field_70163_u + y * k, this.field_70161_v + z * k);
                BiPredicate<Block, IBlockState> isCollidable = (block, blockMetadata) -> block.func_176209_a(blockMetadata, false);
                RayTraceResult rayTraceResult = MWCUtil.rayTraceBlocks(this.field_70170_p, cvec1, cvec2, isCollidable);
                if (rayTraceResult != null) {
                    cvec2 = new Vector3D(rayTraceResult.field_72307_f);
                }
                for (Object nearbyEntityObject : nearbyEntities) {
                    Entity nearbyEntity = (Entity)nearbyEntityObject;
                    if (!nearbyEntity.func_70067_L()) continue;
                    float f = 0.5f;
                    AxisAlignedBB axisalignedbb = nearbyEntity.func_174813_aQ().func_72321_a((double)f, (double)f, (double)f);
                    RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(cvec10.toVec3d(), cvec2.toVec3d());
                    if (movingobjectposition1 == null) continue;
                    double distanceToEntity = cvec10.distanceTo(new Vector3D(movingobjectposition1.field_72307_f));
                    float damageDistanceReductionFactor = (float)Math.abs(1.0 - distanceToEntity / (double)effectiveRadius);
                    ModReference.LOG.trace("Hit entity {} at distance {}, damage reduction {}", (Object)nearbyEntity, (Object)distanceToEntity, (Object)Float.valueOf(damageDistanceReductionFactor));
                    nearbyEntity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.getThrower()), Math.max(0.1f, this.field_70146_Z.nextFloat()) * fragmentDamage * damageDistanceReductionFactor);
                }
            }
            ++i;
        }
        this.func_70106_y();
    }

    @Override
    public ItemGrenade getItemGrenade() {
        return this.itemGrenade;
    }

    public static class Builder {
        private long explosionTimeout;
        private float explosionStrength;
        private boolean isDestroyingBlocks = true;
        private long activationTimestamp;
        private EntityLivingBase thrower;
        private ItemGrenade itemGrenade;
        private float velocity = 1.5f;
        private float gravityVelocity = 0.06f;
        private float rotationSlowdownFactor = 0.99f;

        public Builder withActivationTimestamp(long activationTimestamp) {
            this.activationTimestamp = activationTimestamp;
            return this;
        }

        public Builder withExplosionTimeout(long explosionTimeout) {
            this.explosionTimeout = explosionTimeout;
            return this;
        }

        public Builder withThrower(EntityLivingBase thrower) {
            this.thrower = thrower;
            return this;
        }

        public Builder withExplosionStrength(float explosionStrength) {
            this.explosionStrength = explosionStrength;
            return this;
        }

        public Builder withGrenade(ItemGrenade itemGrenade) {
            this.itemGrenade = itemGrenade;
            return this;
        }

        public Builder withVelocity(float velocity) {
            this.velocity = velocity;
            return this;
        }

        public Builder withGravityVelocity(float gravityVelocity) {
            this.gravityVelocity = gravityVelocity;
            return this;
        }

        public Builder withRotationSlowdownFactor(float rotationSlowdownFactor) {
            this.rotationSlowdownFactor = rotationSlowdownFactor;
            return this;
        }

        public Builder withDestroyingBlocks(boolean isDestroyingBlocks) {
            this.isDestroyingBlocks = isDestroyingBlocks;
            return this;
        }

        public EntityGrenade build(ModContext modContext) {
            EntityGrenade entityGrenade = new EntityGrenade(modContext, this.itemGrenade, this.thrower, this.velocity, this.gravityVelocity, this.rotationSlowdownFactor);
            entityGrenade.activationTimestamp = this.activationTimestamp;
            entityGrenade.explosionTimeout = this.explosionTimeout;
            entityGrenade.explosionStrength = this.explosionStrength;
            entityGrenade.itemGrenade = this.itemGrenade;
            entityGrenade.destroyBlocks = this.isDestroyingBlocks;
            return entityGrenade;
        }
    }
}

