/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.grenade;

import com.paneedah.weaponlib.EntityBounceable;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.grenade.ItemGrenade;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public abstract class AbstractEntityGrenade
extends EntityBounceable {
    private static final String TAG_ENTITY_ITEM = "entity_item";
    protected ItemGrenade itemGrenade;

    protected AbstractEntityGrenade(ModContext modContext, ItemGrenade itemGrenade, EntityLivingBase thrower, float velocity, float gravityVelocity, float rotationSlowdownFactor) {
        super(modContext, thrower.field_70170_p, thrower, velocity, gravityVelocity, rotationSlowdownFactor);
        this.itemGrenade = itemGrenade;
    }

    public AbstractEntityGrenade(World world) {
        super(world);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        Item item = Item.func_150899_d((int)tagCompound.func_74762_e(TAG_ENTITY_ITEM));
        if (item instanceof ItemGrenade) {
            this.itemGrenade = (ItemGrenade)item;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a(TAG_ENTITY_ITEM, Item.func_150891_b((Item)this.itemGrenade));
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(Item.func_150891_b((Item)this.itemGrenade));
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        super.readSpawnData(buffer);
        Item item = Item.func_150899_d((int)buffer.readInt());
        if (item instanceof ItemGrenade) {
            this.itemGrenade = (ItemGrenade)item;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.onGrenadeUpdate();
    }

    protected abstract void onGrenadeUpdate();

    @Override
    public void onBounce(RayTraceResult movingobjectposition) {
        if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK && this.itemGrenade != null) {
            IBlockState iBlockState;
            Material material;
            SoundEvent bounceSoftSound;
            IBlockState iBlockState2;
            Material material2;
            SoundEvent bounceHardSound = this.itemGrenade.getBounceHardSound();
            if (bounceHardSound != null && ((material2 = (iBlockState2 = this.field_70170_p.func_180495_p(new BlockPos(movingobjectposition.func_178782_a().func_177958_n(), movingobjectposition.func_178782_a().func_177956_o(), movingobjectposition.func_178782_a().func_177952_p()))).func_185904_a()) == Material.field_151576_e || material2 == Material.field_151573_f || material2 == Material.field_151588_w || material2 == Material.field_151575_d)) {
                this.func_184185_a(bounceHardSound, 2.0f / ((float)this.bounceCount + 1.0f), 1.0f);
            }
            if ((bounceSoftSound = this.itemGrenade.getBounceSoftSound()) != null && ((material = (iBlockState = this.field_70170_p.func_180495_p(new BlockPos(movingobjectposition.func_178782_a().func_177958_n(), movingobjectposition.func_178782_a().func_177956_o(), movingobjectposition.func_178782_a().func_177952_p()))).func_185904_a()) == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151588_w || material == Material.field_151575_d)) {
                this.func_184185_a(bounceHardSound, 1.0f / ((float)this.bounceCount + 1.0f), 1.0f);
            }
        }
    }

    public ItemGrenade getItemGrenade() {
        return this.itemGrenade;
    }
}

