/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.electronics;

import com.paneedah.weaponlib.AttachmentBuilder;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PlayerItemInstanceFactory;
import com.paneedah.weaponlib.Updatable;
import com.paneedah.weaponlib.electronics.HandheldState;
import com.paneedah.weaponlib.electronics.PlayerHandheldInstance;
import com.paneedah.weaponlib.perspective.Perspective;
import com.paneedah.weaponlib.perspective.PerspectiveRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemHandheld<T>
extends ItemAttachment<T>
implements PlayerItemInstanceFactory<PlayerHandheldInstance, HandheldState>,
Updatable {
    private final int DEFAULT_MAX_STACK_SIZE = 1;
    private ModContext modContext;
    private Builder<T> builder;

    private ItemHandheld(Builder<T> builder) {
        super(AttachmentCategory.SCOPE, builder.getModel(), builder.getTextureName(), null, null, null);
        this.builder = builder;
        this.func_77625_d(1);
    }

    @Override
    public void update(EntityPlayer player) {
    }

    @Override
    public PlayerHandheldInstance createItemInstance(EntityLivingBase player, ItemStack stack, int slot) {
        PlayerHandheldInstance instance = new PlayerHandheldInstance(slot, player, stack);
        instance.setState(HandheldState.READY);
        return instance;
    }

    public Class<? extends Perspective<?>> getRequiredPespectiveType() {
        return ((Builder)this.builder).perspectiveClass;
    }

    public static final class Builder<T>
    extends AttachmentBuilder<T> {
        private Runnable screenPositioning;
        private Class<? extends Perspective<?>> perspectiveClass;

        public Builder<T> withScreenPositioning(Runnable screenPositioning) {
            this.screenPositioning = screenPositioning;
            return this;
        }

        public Builder<T> withScreenPerspectiveType(Class<? extends Perspective<?>> perspectiveClass) {
            this.perspectiveClass = perspectiveClass;
            return this;
        }

        @Override
        protected ItemAttachment<T> createAttachment(ModContext modContext) {
            this.withPostRender(new PerspectiveRenderer(this.screenPositioning));
            ItemHandheld itemHandheld = new ItemHandheld(this);
            itemHandheld.modContext = modContext;
            return itemHandheld;
        }

        @Override
        public ItemAttachment<T> build(ModContext modContext) {
            return super.build(modContext);
        }
    }
}

