/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.crafting.workbench;

import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.CraftingRegistry;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import com.paneedah.weaponlib.crafting.base.TileEntityStation;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class TileEntityWorkbench
extends TileEntityStation {
    public IModernCraftingRecipe craftingTarget;
    public String craftingTargetName;
    public int ticker;

    public void onLoad() {
        super.onLoad();
    }

    @Override
    public int getDismantlingTime(IModernCraftingRecipe crafting) {
        return 200;
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return super.func_189517_E_();
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return super.func_189518_D_();
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    @Override
    public void writeBytesForClientSync(ByteBuf buf) {
        super.writeBytesForClientSync(buf);
        if (this.craftingTarget != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.craftingTarget.getItemStack().func_77977_a());
            return;
        }
        buf.writeBoolean(false);
    }

    @Override
    public void readBytesFromClientSync(ByteBuf buf) {
        super.readBytesFromClientSync(buf);
        if (buf.readBoolean()) {
            this.craftingTargetName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.craftingTimer != -1 && this.craftingTarget != null) {
            compound.func_74768_a("craftingTargetID", this.craftingTarget.getCraftingGroup().getID());
            compound.func_74778_a("craftingTargetName", this.craftingTarget.getItemStack().func_77977_a());
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("craftingTimer") && compound.func_74764_b("craftingDuration")) {
            this.craftingTarget = CraftingRegistry.getModernCrafting(CraftingGroup.getValue(compound.func_74762_e("craftingTargetID")), compound.func_74779_i("craftingTargetName"));
        }
    }

    public void setTimer(int time, int duration) {
        this.craftingTimer = time;
        this.craftingDuration = duration;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.craftingTimer != -1) {
            ++this.craftingTimer;
        }
        if (this.getProgress() >= 1.0) {
            this.craftingTimer = -1;
            this.craftingDuration = -1;
            if (!this.field_145850_b.field_72995_K && this.craftingTarget != null) {
                this.addStackToInventoryRange(this.craftingTarget.getItemStack(), 0, 9);
                this.sendUpdate();
            }
        }
    }
}

