/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.crafting.base;

import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import com.paneedah.weaponlib.crafting.base.BlockStation;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityStation
extends TileEntity
implements ITickable,
ISidedInventory {
    public ItemStackHandler mainInventory = new ItemStackHandler(50);
    public int[] previousDismantleStatus = new int[]{-1, -1, -1, -1};
    public int[] dismantleStatus = new int[]{-1, -1, -1, -1};
    public int[] dismantleDuration = new int[]{-1, -1, -1, -1};
    public int prevCraftingTimer = -1;
    public int craftingTimer = -1;
    public int craftingDuration = -1;
    public boolean pushInventoryRefresh = false;
    private boolean shouldUpdate = false;
    private EnumFacing facing = null;

    public void sendUpdate() {
        this.shouldUpdate = true;
    }

    public double getProgress() {
        if (this.craftingTimer == -1 || this.craftingDuration == -1) {
            return 0.0;
        }
        return (double)this.craftingTimer / (double)this.craftingDuration;
    }

    public void syncChanges() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
    }

    public EnumFacing getFacing() {
        if (this.facing == null) {
            this.facing = (EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockStation.FACING);
        }
        return this.facing;
    }

    public int getDismantlingTime(IModernCraftingRecipe crafting) {
        return 0;
    }

    public void setDismantling(int[] instant, int[] lengths) {
        this.previousDismantleStatus = (int[])instant.clone();
        this.dismantleStatus = instant;
        this.dismantleDuration = lengths;
    }

    public void func_73660_a() {
        this.prevCraftingTimer = this.craftingTimer;
        for (int i = 0; i < this.dismantleStatus.length; ++i) {
            ItemStack stackToDismantle;
            if (this.dismantleStatus[i] == -1 || this.dismantleDuration[i] == -1) continue;
            this.previousDismantleStatus[i] = this.dismantleStatus[i];
            int n = i;
            this.dismantleStatus[n] = this.dismantleStatus[n] + 1;
            if (this.mainInventory.getStackInSlot(i + 9).func_190926_b()) {
                this.previousDismantleStatus[i] = -1;
                this.dismantleStatus[i] = -1;
                this.dismantleDuration[i] = -1;
            }
            if (this.dismantleStatus[i] <= this.dismantleDuration[i] || !((stackToDismantle = this.mainInventory.getStackInSlot(i + 9)).func_77973_b() instanceof IModernCraftingRecipe)) continue;
            CraftingEntry[] modernRecipe = ((IModernCraftingRecipe)stackToDismantle.func_77973_b()).getModernRecipe();
            if (!this.field_145850_b.field_72995_K) {
                stackToDismantle.func_190918_g(1);
            }
            if (!this.field_145850_b.field_72995_K && stackToDismantle.func_190916_E() != 0 || this.field_145850_b.field_72995_K && stackToDismantle.func_190916_E() >= 1) {
                this.previousDismantleStatus[i] = 0;
                this.dismantleStatus[i] = 0;
            } else {
                this.previousDismantleStatus[i] = -1;
                this.dismantleStatus[i] = -1;
                this.dismantleDuration[i] = -1;
            }
            if (this.field_145850_b.field_72995_K) continue;
            for (CraftingEntry stack : modernRecipe) {
                ItemStack itemStack = new ItemStack(stack.getItem());
                itemStack.func_190920_e((int)Math.round((double)stack.getCount() * stack.getYield()));
                this.addStackToInventoryRange(itemStack, 13, 22);
            }
            this.sendUpdate();
        }
        if (this.shouldUpdate) {
            this.syncChanges();
            this.shouldUpdate = false;
        }
    }

    public boolean inventoryContainsEnoughItems(Item item, int quantity, int start, int end) {
        int count = 0;
        for (int i = start; i <= end; ++i) {
            ItemStack slotStack = this.mainInventory.getStackInSlot(i);
            if (slotStack.func_77973_b() != item || (count += slotStack.func_190916_E()) < quantity) continue;
            return true;
        }
        return count >= quantity;
    }

    public boolean consumeFromInventory(Item item, int quantity, int start, int end) {
        LinkedList<ItemStack> stackQueue = new LinkedList<ItemStack>();
        int consumedSimulated = 0;
        for (int i = start; i <= end; ++i) {
            ItemStack slotStack = this.mainInventory.getStackInSlot(i);
            if (slotStack.func_77973_b() != item) continue;
            stackQueue.add(slotStack);
            if ((consumedSimulated += slotStack.func_190916_E()) >= quantity) break;
        }
        if (consumedSimulated >= quantity) {
            for (ItemStack s : stackQueue) {
                int toConsume = Math.min(quantity, s.func_190916_E());
                s.func_190918_g(toConsume);
                if ((quantity -= toConsume) != 0) continue;
                return true;
            }
        } else {
            return false;
        }
        return this.field_145846_f;
    }

    public void addStackToInventoryRange(ItemStack stack, int start, int end) {
        int i;
        for (i = start; i <= end; ++i) {
            if (!ItemStack.func_179545_c((ItemStack)this.mainInventory.getStackInSlot(i), (ItemStack)stack)) continue;
            ItemStack inInventory = this.mainInventory.getStackInSlot(i);
            if (inInventory.func_190916_E() + stack.func_190916_E() <= inInventory.func_77976_d()) {
                inInventory.func_190917_f(stack.func_190916_E());
                stack.func_190918_g(stack.func_190916_E());
                continue;
            }
            if (inInventory.func_190916_E() > inInventory.func_77976_d() || inInventory.func_190916_E() * 2 < inInventory.func_77976_d()) continue;
            int difference = inInventory.func_77976_d() - inInventory.func_190916_E();
            inInventory.func_190917_f(difference);
            stack.func_190918_g(difference);
        }
        if (stack.func_190916_E() > 0) {
            for (i = start; i <= end; ++i) {
                if (!this.mainInventory.getStackInSlot(i).func_190926_b()) continue;
                this.mainInventory.setStackInSlot(i, stack);
                break;
            }
        }
    }

    public void readBytesFromClientSync(ByteBuf buf) {
        int i;
        this.craftingTimer = buf.readInt();
        this.craftingDuration = buf.readInt();
        for (i = 0; i < this.dismantleStatus.length; ++i) {
            int time;
            this.previousDismantleStatus[i] = time = buf.readInt();
            this.dismantleStatus[i] = time;
        }
        for (i = 0; i < this.dismantleDuration.length; ++i) {
            this.dismantleDuration[i] = buf.readInt();
        }
    }

    public void writeBytesForClientSync(ByteBuf buf) {
        int i;
        buf.writeInt(this.craftingTimer);
        buf.writeInt(this.craftingDuration);
        for (i = 0; i < this.dismantleStatus.length; ++i) {
            buf.writeInt(this.dismantleStatus[i]);
        }
        for (i = 0; i < this.dismantleDuration.length; ++i) {
            buf.writeInt(this.dismantleDuration[i]);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("mainInventory", (NBTBase)this.mainInventory.serializeNBT());
        compound.func_74768_a("craftingTimer", this.craftingTimer);
        compound.func_74768_a("craftingDuration", this.craftingDuration);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("mainInventory")) {
            this.mainInventory.deserializeNBT((NBTTagCompound)compound.func_74781_a("mainInventory"));
        }
        if (compound.func_74764_b("craftingTimer") && compound.func_74764_b("craftingDuration")) {
            this.craftingTimer = compound.func_74762_e("craftingTimer");
            this.craftingDuration = compound.func_74762_e("craftingDuration");
        }
    }

    public int func_70302_i_() {
        return this.mainInventory.getSlots();
    }

    public boolean func_191420_l() {
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.mainInventory.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack s = this.mainInventory.getStackInSlot(index);
        s.func_190918_g(count);
        return s;
    }

    public ItemStack func_70304_b(int index) {
        return this.mainInventory.extractItem(index, this.mainInventory.getStackInSlot(index).func_190916_E(), false);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.mainInventory.setStackInSlot(index, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        }
        return new int[]{23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }
}

