/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.Weapon;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.DimensionManager;

public class BalancePackManager {
    private static final Gson GSON_MANAGER = new GsonBuilder().setPrettyPrinting().create();
    private static File DIRECTORY;
    private static File INDEX_FILE;
    private static final String PACK_MANAGER_VERSION = "1.3";
    private static final String DAMAGE_MULTIPLIER_KEY = "damageMultiplier";
    private static final String RECOIL_MULTIPLIER_KEY = "recoilMultiplier";
    private static final String HIP_FIRE_SPREAD_KEY = "hipFireSpread";
    private static final String HIP_FIRE_SPREAD_MULTIPLIER_KEY = "hipFireSpreadMultiplier";
    private static final String GLOBAL_PARAMETERS_KEY = "globalParameters";
    private static final String PACK_VERSION_KEY = "version";
    private static final String PACK_NAME_KEY = "packName";
    private static final String PACK_MANAGER_KEY = "packManagerVersion";
    private static final String GUN_CONFIG_LIST = "gunConfigurations";
    private static final String CATEGORY_CONFIG_LIST = "categoryConfigurations";
    private static final String FIRE_RATE_MODIFIER = "firerate";
    private static final String INACCURACY_MODIFIER = "inaccuracy";
    private static final String FIRE_MODE_AUTO = "firemodeAuto";
    private static final String FIRE_MODE_BURST = "firemodeBurst";
    private static final String FIRE_MODE_SINGLE = "firemodeSingle";
    private static BalancePack balancePackCurrentlyLoaded;
    private static boolean isLoaded;

    public static String getPackManagerVersion() {
        return PACK_MANAGER_VERSION;
    }

    public static boolean hasActiveBalancePack() {
        return balancePackCurrentlyLoaded != null;
    }

    public static BalancePack getActiveBalancePack() {
        return balancePackCurrentlyLoaded;
    }

    public static void setCurrentBalancePack(BalancePack pack) {
        balancePackCurrentlyLoaded = pack;
    }

    public static File getDirectory() {
        BalancePackManager.loadDirectory();
        return DIRECTORY;
    }

    public static void remakeIndexFile() {
        INDEX_FILE = new File(DimensionManager.getCurrentSaveRootDirectory() + "/balancepacksindex.json");
        try {
            if (INDEX_FILE.exists()) {
                INDEX_FILE.delete();
            }
            INDEX_FILE.createNewFile();
            BalancePackManager.updateIndexFile();
        }
        catch (IOException e) {
            ModReference.LOG.catching((Throwable)e);
            ModReference.LOG.error("Failed to create a new index.json");
        }
    }

    public static void createNewIndexFile() {
        INDEX_FILE = new File(DimensionManager.getCurrentSaveRootDirectory() + "/balancepacksindex.json");
        try {
            if (!INDEX_FILE.exists()) {
                ModReference.LOG.debug("No index file found! Creating a new index.json.");
                INDEX_FILE.createNewFile();
                BalancePackManager.updateIndexFile();
            }
        }
        catch (IOException e) {
            ModReference.LOG.catching((Throwable)e);
            ModReference.LOG.error("Failed to create a new index.json");
        }
    }

    public static JsonObject readJSONFile(File file) throws JsonSyntaxException {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            ModReference.LOG.catching((Throwable)e);
        }
        if (reader == null) {
            ModReference.LOG.error("Failed to read file {} from the disk!", (Object)file.getName());
            return null;
        }
        JsonObject object = null;
        object = (JsonObject)GSON_MANAGER.fromJson((Reader)reader, JsonObject.class);
        try {
            reader.close();
        }
        catch (IOException e) {
            ModReference.LOG.catching((Throwable)e);
            ModReference.LOG.error("Failed to close file reader for file {}!", (Object)file.getName());
        }
        return object;
    }

    public static boolean writeJSONToFile(JsonObject object, File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e1) {
                ModReference.LOG.catching((Throwable)e1);
                ModReference.LOG.error("Tried to create new file {} in order to write JSON to it, but failed!", (Object)file.getName());
                return false;
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
        }
        catch (IOException e) {
            ModReference.LOG.catching((Throwable)e);
        }
        if (writer == null) {
            ModReference.LOG.error("Failed to write file {} to the disk!", (Object)file.getName());
            return false;
        }
        GSON_MANAGER.toJson((JsonElement)object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            ModReference.LOG.catching((Throwable)e);
            ModReference.LOG.error("Failed to close file writer for file {}!", (Object)file.getName());
        }
        ModReference.LOG.debug("Succesfully wrote file {} to disk!", (Object)file.getName());
        return true;
    }

    public static File getIndexFile() {
        if (INDEX_FILE != null) {
            return INDEX_FILE;
        }
        BalancePackManager.createNewIndexFile();
        return INDEX_FILE;
    }

    public static void loadDirectory() {
        if (isLoaded) {
            return;
        }
        File f = new File("balancepacks/");
        if (!f.exists()) {
            f.mkdir();
            BalancePackManager.updateIndexFile();
        } else {
            JsonObject index = null;
            try {
                index = BalancePackManager.readJSONFile(BalancePackManager.getIndexFile());
            }
            catch (JsonSyntaxException e) {
                ModReference.LOG.error("Index.json is not a proper JSON file. Recreating index.json.");
                BalancePackManager.remakeIndexFile();
                index = BalancePackManager.readJSONFile(BalancePackManager.getIndexFile());
            }
            if (!index.has("loadedPack")) {
                ModReference.LOG.error("Error! Index file for balance packs does not contain loadedPacks key. File may have been tampered with.");
            } else {
                String result = index.get("loadedPack").getAsString();
                if (result.equals("null")) {
                    ModReference.LOG.debug("No loaded pack.");
                } else {
                    ModReference.LOG.debug("Balance pack manager found actively loaded pack {}", (Object)result);
                    BalancePackManager.loadBalancePack(null, result);
                }
            }
        }
        DIRECTORY = f;
        isLoaded = true;
    }

    public static void loadBalancePackFromString(ICommandSender sender, String alledgedJson) {
        String header = TextFormatting.GOLD + "(Balance Pack Manager " + BalancePackManager.getPackManagerVersion() + ")" + TextFormatting.WHITE;
        JsonObject object = null;
        try {
            object = (JsonObject)GSON_MANAGER.fromJson(alledgedJson, JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            ModReference.LOG.error("Attempt to load balance pack from String failed. Was not JSON.");
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(header + " Attempt to load balance pack from String failed. Was not JSON."));
            }
            return;
        }
        if (object == null) {
            return;
        }
        if (!object.has(PACK_NAME_KEY)) {
            ModReference.LOG.debug("Balance pack missing pack name key! Will not load.");
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(header + " Balance pack downloading failed. Did not have pack name key."));
            }
            return;
        }
        String modifiedName = object.get(PACK_NAME_KEY).getAsString().toLowerCase().replace(" ", "_") + ".json";
        if (BalancePackManager.writeJSONToFile(object, new File("balancepacks/" + modifiedName))) {
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(header + " Succesfully downloaded balance pack to disk as " + TextFormatting.RED + modifiedName + TextFormatting.WHITE + "."));
            }
            BalancePackManager.loadBalancePack(sender, modifiedName);
            if (BalancePackManager.hasActiveBalancePack() && BalancePackManager.getActiveBalancePack().fileName.equals(modifiedName) && sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(header + " Succesfully loaded balance pack " + TextFormatting.RED + modifiedName + TextFormatting.WHITE + "."));
            }
        } else if (sender != null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(header + " Failed to download balance pack to disk."));
        }
    }

    public static void loadBalancePack(ICommandSender sender, String fileName) {
        String header = TextFormatting.GOLD + "(Balance Pack Manager " + BalancePackManager.getPackManagerVersion() + ")" + TextFormatting.WHITE;
        File balancePack = new File("balancepacks/" + fileName);
        if (!balancePack.exists()) {
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(header + " Balance pack loading failed. File does not exist."));
            }
            ModReference.LOG.error("Balance pack {} does not exist! Game refusing to load it. Recreating index.json.", (Object)fileName);
            BalancePackManager.remakeIndexFile();
            return;
        }
        JsonObject object = null;
        try {
            object = BalancePackManager.readJSONFile(balancePack);
        }
        catch (JsonSyntaxException e) {
            ModReference.LOG.error("Json file {} is not proper JSON! Please check the formatting.", (Object)fileName);
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(header + " Json file " + TextFormatting.RED + fileName + TextFormatting.WHITE + " is not proper JSON! Please check the formatting."));
            }
            return;
        }
        BalancePack pack = BalancePack.fromJSONObject(object);
        if (pack == null) {
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(header + " Json file " + TextFormatting.RED + fileName + TextFormatting.WHITE + " failed to load! Please check the console for more information."));
            }
            return;
        }
        pack.fileName = fileName;
        BalancePackManager.setCurrentBalancePack(pack);
        BalancePackManager.updateIndexFile();
    }

    public static void createDefaultBalancePack() {
        BalancePack defaultPack = new BalancePack("default", "1.0", 1.0, 1.0, 7.5);
        defaultPack.addWeaponConfig(new GunBalanceConfiguration("exampleWeapon", true, 8.0, 1.0, 0.5f, 0.0f));
        for (GunConfigurationGroup i : GunConfigurationGroup.values()) {
            defaultPack.addBalancingCategory(new GunCategoryBalanceConfiguration(i, 1.0, 1.0, 1.0));
        }
        BalancePackManager.writeJSONToFile(defaultPack.toJSONObject(), new File("balancepacks/default_pack.json"));
    }

    public static void updateIndexFile() {
        JsonObject obj = new JsonObject();
        obj.addProperty("loadedPack", BalancePackManager.hasActiveBalancePack() ? BalancePackManager.getActiveBalancePack().fileName : "null");
        BalancePackManager.writeJSONToFile(obj, BalancePackManager.getIndexFile());
    }

    public static void unloadBalancePack() {
        balancePackCurrentlyLoaded = null;
        BalancePackManager.updateIndexFile();
    }

    public static boolean balancePackAddressesWeapon(Weapon weapon) {
        if (!BalancePackManager.hasActiveBalancePack()) {
            return false;
        }
        return BalancePackManager.getActiveBalancePack().containsWeapon(weapon.getName());
    }

    public static float getFirerate(Weapon weapon) {
        if (!BalancePackManager.hasActiveBalancePack() || !BalancePackManager.balancePackAddressesWeapon(weapon) || BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName()).getFirerate() < 0.0) {
            return weapon.builder.getFirerate();
        }
        return (float)BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName()).getFirerate();
    }

    public static float getInaccuracy(Weapon weapon) {
        if (!BalancePackManager.hasActiveBalancePack() || !BalancePackManager.balancePackAddressesWeapon(weapon) || BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName()).getInaccuracy() < 0.0) {
            return weapon.builder.getInaccuracy();
        }
        return (float)BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName()).getInaccuracy();
    }

    public static boolean balancePackAddressesGroup(GunConfigurationGroup group) {
        if (!BalancePackManager.hasActiveBalancePack()) {
            return false;
        }
        return BalancePackManager.getActiveBalancePack().containsCategory(group);
    }

    public static double getNewWeaponDamage(Weapon weapon) {
        if (!BalancePackManager.hasActiveBalancePack() || !BalancePackManager.balancePackAddressesWeapon(weapon)) {
            return weapon.getSpawnEntityDamage();
        }
        return BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName()).getDamage();
    }

    public static boolean isWeaponDisabled(Weapon weapon) {
        if (!BalancePackManager.hasActiveBalancePack() || !BalancePackManager.balancePackAddressesWeapon(weapon)) {
            return false;
        }
        return !BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName()).isEnabled();
    }

    public static boolean shouldChangeWeaponDamage(Weapon weapon) {
        return BalancePackManager.hasActiveBalancePack() && BalancePackManager.balancePackAddressesWeapon(weapon) && !(BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName()).getDamage() < 0.0);
    }

    public static boolean firemodePropertiesAltered(Weapon weapon) {
        if (!BalancePackManager.hasActiveBalancePack() || !BalancePackManager.balancePackAddressesWeapon(weapon)) {
            return false;
        }
        return BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName()).wereFiremodePropertiesAltered();
    }

    public static List<Integer> getFiremodeListForWeapon(Weapon weapon) {
        if (!(BalancePackManager.hasActiveBalancePack() && BalancePackManager.balancePackAddressesWeapon(weapon) && BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName()).wereFiremodePropertiesAltered())) {
            return weapon.builder.getMaxShots();
        }
        GunBalanceConfiguration gbc = BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName());
        ArrayList<Integer> shotsList = new ArrayList<Integer>();
        if (gbc.autoFireEnabled) {
            shotsList.add(Integer.MAX_VALUE);
        }
        if (gbc.singleFireEnabled) {
            shotsList.add(1);
        }
        if (gbc.burstShots != 0) {
            shotsList.add(gbc.burstShots);
        }
        return shotsList;
    }

    public static boolean shouldChangeWeaponRecoil(Weapon weapon) {
        return BalancePackManager.hasActiveBalancePack() && BalancePackManager.balancePackAddressesWeapon(weapon) && !(BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName()).getRecoil() < 0.0);
    }

    public static double getNewWeaponRecoil(Weapon weapon) {
        if (!BalancePackManager.hasActiveBalancePack() || !BalancePackManager.balancePackAddressesWeapon(weapon)) {
            return weapon.getRecoil();
        }
        return BalancePackManager.getActiveBalancePack().getWeaponBalancing(weapon.getName()).getRecoil();
    }

    public static double getGroupDamageMultiplier(GunConfigurationGroup group) {
        if (!BalancePackManager.hasActiveBalancePack() || !BalancePackManager.balancePackAddressesGroup(group)) {
            return 1.0;
        }
        return BalancePackManager.getActiveBalancePack().getCategoryBalancing(group).getDamageMultiplier();
    }

    public static double getGroupRecoilMultiplier(GunConfigurationGroup group) {
        if (!BalancePackManager.hasActiveBalancePack() || !BalancePackManager.balancePackAddressesGroup(group)) {
            return 1.0;
        }
        return BalancePackManager.getActiveBalancePack().getCategoryBalancing(group).getRecoilMultiplier();
    }

    public static double getGroupHipFireSpread(GunConfigurationGroup group) {
        if (!BalancePackManager.hasActiveBalancePack() || !BalancePackManager.balancePackAddressesGroup(group)) {
            return 1.0;
        }
        return BalancePackManager.getActiveBalancePack().getCategoryBalancing(group).getHipFireSpread();
    }

    public static double getGlobalDamageMultiplier() {
        if (!BalancePackManager.hasActiveBalancePack()) {
            return 1.0;
        }
        return BalancePackManager.getActiveBalancePack().getGlobalDamageMultiplier();
    }

    public static double getGlobalRecoilMultiplier() {
        if (!BalancePackManager.hasActiveBalancePack()) {
            return 1.0;
        }
        return BalancePackManager.getActiveBalancePack().getGlobalRecoilMultiplier();
    }

    public static double getGlobalHipFireSpread() {
        if (!BalancePackManager.hasActiveBalancePack()) {
            return 7.5;
        }
        return BalancePackManager.getActiveBalancePack().getGlobalHipFireSpread();
    }

    public static double getNetGunDamage(Weapon weapon) {
        double dmg = weapon.getSpawnEntityDamage();
        if (BalancePackManager.shouldChangeWeaponDamage(weapon)) {
            dmg = BalancePackManager.getNewWeaponDamage(weapon);
        }
        return dmg *= BalancePackManager.getGlobalDamageMultiplier();
    }

    static {
        isLoaded = false;
    }

    public static class BalancePack {
        private String name;
        private String version;
        private double globalRecoilMultiplier = 1.0;
        private double globalDamageMultiplier = 1.0;
        private double globalHipFireSpread = 7.5;
        private String fileName;
        private HashMap<String, GunBalanceConfiguration> gunConfigurations = new HashMap();
        private HashMap<GunConfigurationGroup, GunCategoryBalanceConfiguration> gunCategoryConfigurations = new HashMap();

        public BalancePack(String name, String version, double globalRecoilMultiplier, double globalDamageMultiplier, double globalHipFireSpread) {
            this.name = name;
            this.version = version;
            this.globalDamageMultiplier = globalDamageMultiplier;
            this.globalRecoilMultiplier = globalRecoilMultiplier;
            this.globalHipFireSpread = globalHipFireSpread;
        }

        public void addFileName(String fileName) {
            this.fileName = fileName;
        }

        public void addWeaponConfig(GunBalanceConfiguration gbc) {
            this.gunConfigurations.put(gbc.getWeaponName(), gbc);
        }

        public void addBalancingCategory(GunCategoryBalanceConfiguration gscbc) {
            this.gunCategoryConfigurations.put(gscbc.getGroup(), gscbc);
        }

        public static BalancePack fromJSONObject(JsonObject jsonObject) {
            int i;
            double globalHipFireSpread;
            double globalRecoil;
            double globalDamage;
            if (!jsonObject.has(BalancePackManager.PACK_NAME_KEY) || !jsonObject.has(BalancePackManager.PACK_VERSION_KEY)) {
                ModReference.LOG.error("Missing pack name or version key! Cannot load balance pack from JSON data.");
                return null;
            }
            String packName = jsonObject.get(BalancePackManager.PACK_NAME_KEY).getAsString();
            String packVersion = jsonObject.get(BalancePackManager.PACK_VERSION_KEY).getAsString();
            double headshotMultiplier = 2.5;
            if (jsonObject.has(BalancePackManager.GLOBAL_PARAMETERS_KEY)) {
                JsonObject globalParameters = jsonObject.get(BalancePackManager.GLOBAL_PARAMETERS_KEY).getAsJsonObject();
                globalDamage = globalParameters.get(BalancePackManager.DAMAGE_MULTIPLIER_KEY).getAsDouble();
                globalRecoil = globalParameters.get(BalancePackManager.RECOIL_MULTIPLIER_KEY).getAsDouble();
                globalHipFireSpread = globalParameters.get(BalancePackManager.HIP_FIRE_SPREAD_KEY).getAsDouble();
            } else {
                globalRecoil = 1.0;
                globalDamage = 1.0;
                globalHipFireSpread = 7.5;
            }
            BalancePack bp = new BalancePack(packName, packVersion, globalRecoil, globalDamage, globalHipFireSpread);
            if (jsonObject.has(BalancePackManager.GUN_CONFIG_LIST)) {
                JsonArray array = jsonObject.get(BalancePackManager.GUN_CONFIG_LIST).getAsJsonArray();
                ModReference.LOG.debug("Found weapon config list with {} entries.", (Object)array.size());
                for (i = 0; i < array.size(); ++i) {
                    GunBalanceConfiguration balanceConfig = GunBalanceConfiguration.fromJSONObject(array.get(i).getAsJsonObject());
                    bp.addWeaponConfig(balanceConfig);
                }
            } else {
                ModReference.LOG.debug("Weapon config list was empty.");
            }
            if (jsonObject.has(BalancePackManager.CATEGORY_CONFIG_LIST)) {
                JsonArray categoricalArray = jsonObject.get(BalancePackManager.CATEGORY_CONFIG_LIST).getAsJsonArray();
                ModReference.LOG.debug("Found category config list with {} entries.", (Object)categoricalArray.size());
                for (i = 0; i < categoricalArray.size(); ++i) {
                    GunCategoryBalanceConfiguration categoryBalancing = GunCategoryBalanceConfiguration.fromJSONObject(categoricalArray.get(i).getAsJsonObject());
                    bp.addBalancingCategory(categoryBalancing);
                }
            } else {
                ModReference.LOG.debug("Weapon category config list was empty.");
            }
            return bp;
        }

        public JsonObject toJSONObject() {
            JsonObject obj = new JsonObject();
            obj.addProperty(BalancePackManager.PACK_NAME_KEY, this.name);
            obj.addProperty(BalancePackManager.PACK_VERSION_KEY, this.version);
            obj.addProperty(BalancePackManager.PACK_MANAGER_KEY, BalancePackManager.PACK_MANAGER_VERSION);
            JsonObject globalParameters = new JsonObject();
            globalParameters.addProperty(BalancePackManager.DAMAGE_MULTIPLIER_KEY, (Number)this.globalDamageMultiplier);
            globalParameters.addProperty(BalancePackManager.RECOIL_MULTIPLIER_KEY, (Number)this.globalRecoilMultiplier);
            globalParameters.addProperty(BalancePackManager.HIP_FIRE_SPREAD_KEY, (Number)this.globalHipFireSpread);
            obj.add(BalancePackManager.GLOBAL_PARAMETERS_KEY, (JsonElement)globalParameters);
            JsonArray gunObj = new JsonArray();
            for (Map.Entry<String, GunBalanceConfiguration> gbc : this.gunConfigurations.entrySet()) {
                gunObj.add((JsonElement)gbc.getValue().toJSONObject());
            }
            obj.add(BalancePackManager.GUN_CONFIG_LIST, (JsonElement)gunObj);
            JsonArray categoryObj = new JsonArray();
            for (Map.Entry<GunConfigurationGroup, GunCategoryBalanceConfiguration> gcbc : this.gunCategoryConfigurations.entrySet()) {
                categoryObj.add((JsonElement)gcbc.getValue().toJSONObject());
            }
            obj.add(BalancePackManager.CATEGORY_CONFIG_LIST, (JsonElement)categoryObj);
            return obj;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public double getGlobalRecoilMultiplier() {
            return this.globalRecoilMultiplier;
        }

        public void setGlobalRecoilMultiplier(double globalRecoilMultiplier) {
            this.globalRecoilMultiplier = globalRecoilMultiplier;
        }

        public double getGlobalDamageMultiplier() {
            return this.globalDamageMultiplier;
        }

        public void setGlobalDamageMultiplier(double globalDamageMultiplier) {
            this.globalDamageMultiplier = globalDamageMultiplier;
        }

        public double getGlobalHipFireSpread() {
            return this.globalHipFireSpread;
        }

        public void setGlobalHipFireSpread(double globalHipFireSpread) {
            this.globalHipFireSpread = globalHipFireSpread;
        }

        public HashMap<String, GunBalanceConfiguration> getGunConfigurations() {
            return this.gunConfigurations;
        }

        public void setGunConfigurations(HashMap<String, GunBalanceConfiguration> gunConfigurations) {
            this.gunConfigurations = gunConfigurations;
        }

        public HashMap<GunConfigurationGroup, GunCategoryBalanceConfiguration> getGunCategoryConfigurations() {
            return this.gunCategoryConfigurations;
        }

        public void setGunCategoryConfigurations(HashMap<GunConfigurationGroup, GunCategoryBalanceConfiguration> gunCategoryConfigurations) {
            this.gunCategoryConfigurations = gunCategoryConfigurations;
        }

        public boolean containsWeapon(String name) {
            return this.gunConfigurations.containsKey(name);
        }

        public GunBalanceConfiguration getWeaponBalancing(String name) {
            return this.gunConfigurations.get(name);
        }

        public boolean containsCategory(GunConfigurationGroup group) {
            return this.gunCategoryConfigurations.containsKey((Object)group);
        }

        public GunCategoryBalanceConfiguration getCategoryBalancing(GunConfigurationGroup group) {
            return this.gunCategoryConfigurations.get((Object)group);
        }
    }

    public static class GunBalanceConfiguration {
        private String weaponName;
        private boolean enabled = true;
        private double damage = -1.0;
        private double recoil = -1.0;
        private float fireRate = -1.0f;
        private float inaccuracy = -1.0f;
        private boolean fireModePropertiesChanged = false;
        private boolean fireModeBurstChanged = false;
        private int burstShots = 3;
        private boolean fireModeSingleChanged = false;
        private boolean singleFireEnabled = false;
        private boolean fireModeAutoChanged = false;
        private boolean autoFireEnabled = false;

        public GunBalanceConfiguration(String weaponName, boolean enabled, double damage, double recoil, float firerate, float inaccuracy) {
            this.weaponName = weaponName;
            this.enabled = enabled;
            this.damage = damage;
            this.recoil = recoil;
            this.fireRate = firerate;
            this.inaccuracy = inaccuracy;
        }

        public String getWeaponName() {
            return this.weaponName;
        }

        public void setBurstShots(int shots) {
            if (shots != 0) {
                this.fireModeBurstChanged = true;
            }
            this.fireModePropertiesChanged = true;
            this.burstShots = shots;
        }

        public void setFiremodeAuto(boolean fma) {
            this.fireModeAutoChanged = true;
            this.fireModePropertiesChanged = true;
            this.autoFireEnabled = fma;
        }

        public void setFiremodeSingle(boolean fms) {
            this.fireModeSingleChanged = true;
            this.fireModePropertiesChanged = true;
            this.singleFireEnabled = fms;
        }

        public boolean altersFiremodeAuto() {
            return this.fireModeAutoChanged;
        }

        public boolean altersFiremodeSingle() {
            return this.fireModeSingleChanged;
        }

        public boolean altersFiremodeBurst() {
            return this.fireModeBurstChanged;
        }

        public int getBurstShots() {
            return this.burstShots;
        }

        public boolean getFiremodeAuto() {
            return this.autoFireEnabled;
        }

        public boolean getFiremodeSingle() {
            return this.singleFireEnabled;
        }

        public boolean wereFiremodePropertiesAltered() {
            return this.fireModePropertiesChanged;
        }

        public void setWeaponName(String weaponName) {
            this.weaponName = weaponName;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public double getDamage() {
            return this.damage;
        }

        public void setDamage(double damage) {
            this.damage = damage;
        }

        public double getRecoil() {
            return this.recoil;
        }

        public void setRecoil(double recoil) {
            this.recoil = recoil;
        }

        public void setFirerate(float firerate) {
            this.fireRate = firerate;
        }

        public double getFirerate() {
            return this.fireRate;
        }

        public void setInaccuracy(float inaccuracy) {
            this.inaccuracy = inaccuracy;
        }

        public double getInaccuracy() {
            return this.inaccuracy;
        }

        public JsonObject toJSONObject() {
            JsonObject weapon = new JsonObject();
            weapon.addProperty("name", this.getWeaponName());
            weapon.addProperty("enabled", Boolean.valueOf(this.isEnabled()));
            weapon.addProperty("damage", (Number)this.getDamage());
            weapon.addProperty("recoil", (Number)this.getRecoil());
            if (this.getFirerate() != -1.0) {
                weapon.addProperty(BalancePackManager.FIRE_RATE_MODIFIER, (Number)this.getFirerate());
            }
            if (this.getInaccuracy() != -1.0) {
                weapon.addProperty(BalancePackManager.INACCURACY_MODIFIER, (Number)this.getInaccuracy());
            }
            if (this.wereFiremodePropertiesAltered()) {
                weapon.addProperty(BalancePackManager.FIRE_MODE_AUTO, Boolean.valueOf(this.getFiremodeAuto()));
                weapon.addProperty(BalancePackManager.FIRE_MODE_BURST, (Number)this.getBurstShots());
                weapon.addProperty(BalancePackManager.FIRE_MODE_SINGLE, Boolean.valueOf(this.getFiremodeSingle()));
            }
            return weapon;
        }

        public static GunBalanceConfiguration fromJSONObject(JsonObject obj) {
            String name = obj.get("name").getAsString();
            boolean enabled = obj.has("enabled") ? obj.get("enabled").getAsBoolean() : true;
            double damage = obj.has("damage") ? obj.get("damage").getAsDouble() : -1.0;
            double recoil = obj.has("recoil") ? obj.get("recoil").getAsDouble() : -1.0;
            float fireRate = obj.has(BalancePackManager.FIRE_RATE_MODIFIER) ? obj.get(BalancePackManager.FIRE_RATE_MODIFIER).getAsFloat() : -1.0f;
            float inaccuracy = obj.has(BalancePackManager.INACCURACY_MODIFIER) ? obj.get(BalancePackManager.INACCURACY_MODIFIER).getAsFloat() : -1.0f;
            GunBalanceConfiguration gbc = new GunBalanceConfiguration(name, enabled, damage, recoil, fireRate, inaccuracy);
            if (obj.has(BalancePackManager.FIRE_RATE_MODIFIER)) {
                gbc.setFirerate(obj.get(BalancePackManager.FIRE_RATE_MODIFIER).getAsFloat());
            }
            if (obj.has(BalancePackManager.INACCURACY_MODIFIER)) {
                gbc.setInaccuracy(obj.get(BalancePackManager.INACCURACY_MODIFIER).getAsFloat());
            }
            if (obj.has(BalancePackManager.FIRE_MODE_AUTO) && obj.has(BalancePackManager.FIRE_MODE_BURST) && obj.has(BalancePackManager.FIRE_MODE_SINGLE)) {
                gbc.setFiremodeAuto(obj.get(BalancePackManager.FIRE_MODE_AUTO).getAsBoolean());
                gbc.setBurstShots(obj.get(BalancePackManager.FIRE_MODE_BURST).getAsInt());
                gbc.setFiremodeSingle(obj.get(BalancePackManager.FIRE_MODE_SINGLE).getAsBoolean());
            }
            return gbc;
        }
    }

    public static class GunCategoryBalanceConfiguration {
        private GunConfigurationGroup group;
        private double damageMultiplier = 1.0;
        private double recoilMultiplier = 1.0;
        private double hipFireSpreadMultiplier = 1.0;

        public GunCategoryBalanceConfiguration(GunConfigurationGroup group, double damageMultiplier, double recoilMultiplier, double hipFireSpread) {
            this.group = group;
            this.damageMultiplier = damageMultiplier;
            this.recoilMultiplier = recoilMultiplier;
            this.hipFireSpreadMultiplier = hipFireSpread;
        }

        public GunConfigurationGroup getGroup() {
            return this.group;
        }

        public void setGroup(GunConfigurationGroup group) {
            this.group = group;
        }

        public double getDamageMultiplier() {
            return this.damageMultiplier;
        }

        public void setDamageMultiplier(double damageMultiplier) {
            this.damageMultiplier = damageMultiplier;
        }

        public double getRecoilMultiplier() {
            return this.recoilMultiplier;
        }

        public void setRecoilMultiplier(double recoilMultiplier) {
            this.recoilMultiplier = recoilMultiplier;
        }

        public double getHipFireSpread() {
            return this.hipFireSpreadMultiplier;
        }

        public void setHipFireSpread(double hipFireSpread) {
            this.hipFireSpreadMultiplier = hipFireSpread;
        }

        public JsonObject toJSONObject() {
            JsonObject category = new JsonObject();
            category.addProperty("group", this.getGroup().toString());
            category.addProperty(BalancePackManager.DAMAGE_MULTIPLIER_KEY, (Number)this.getDamageMultiplier());
            category.addProperty(BalancePackManager.RECOIL_MULTIPLIER_KEY, (Number)this.getRecoilMultiplier());
            category.addProperty(BalancePackManager.HIP_FIRE_SPREAD_MULTIPLIER_KEY, (Number)this.getHipFireSpread());
            return category;
        }

        public static GunCategoryBalanceConfiguration fromJSONObject(JsonObject obj) {
            GunConfigurationGroup configurationGroup = GunConfigurationGroup.valueOf(obj.get("group").getAsString().toUpperCase());
            double damage = obj.has(BalancePackManager.DAMAGE_MULTIPLIER_KEY) ? obj.get(BalancePackManager.DAMAGE_MULTIPLIER_KEY).getAsDouble() : 1.0;
            double recoil = obj.has(BalancePackManager.RECOIL_MULTIPLIER_KEY) ? obj.get(BalancePackManager.RECOIL_MULTIPLIER_KEY).getAsDouble() : 1.0;
            double hipFireSpread = obj.has(BalancePackManager.HIP_FIRE_SPREAD_MULTIPLIER_KEY) ? obj.get(BalancePackManager.HIP_FIRE_SPREAD_MULTIPLIER_KEY).getAsDouble() : 1.0;
            return new GunCategoryBalanceConfiguration(configurationGroup, damage, recoil, hipFireSpread);
        }
    }

    public static enum GunConfigurationGroup {
        NONE,
        HANDGUN,
        LONG_GUN,
        RIFLE,
        SHOTGUN,
        CARBINE,
        ASSAULT_RIFLE,
        BATTLE_RIFLE,
        SNIPER_RIFLE,
        MACHINE_GUN,
        SUBMACHINE_GUN,
        SIDEARM,
        REVOLVER,
        SMG,
        DMR,
        RIFLES,
        LONG_RANGE_RIFLES,
        HEAVY;

    }
}

