/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.command;

import com.paneedah.weaponlib.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public abstract class TidyCompatibleCommand
extends CommandBase {
    private String name;
    private String usage;
    private String displayName;
    private String[] help;
    private static final TextFormatting ERROR_COLOR = TextFormatting.RED;
    protected static final String HELP_KEY = "help";
    private TextFormatting primaryColor = TextFormatting.GOLD;
    private TextFormatting secondaryColor = TextFormatting.GRAY;
    private TextFormatting displayColor = TextFormatting.YELLOW;
    private HashMap<String, Pair<CommandInfo, ArrayList<Pair<String, CommandInfo>>>> tree = new HashMap();

    public TidyCompatibleCommand(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
        this.addMainOption(HELP_KEY, "provides help", new String[0]);
    }

    public TextFormatting getPrimaryColor() {
        return this.primaryColor;
    }

    public TextFormatting getSecondaryColor() {
        return this.secondaryColor;
    }

    public TextFormatting getErrorColor() {
        return ERROR_COLOR;
    }

    public TextFormatting getDisplayColor() {
        return this.displayColor;
    }

    protected void initCommand() {
        this.usage = ERROR_COLOR + "/" + this.name + " ";
        if (this.tree.size() != 0) {
            this.usage = this.usage + "<";
            Iterator<String> itr = this.tree.keySet().iterator();
            while (itr.hasNext()) {
                this.usage = this.usage + itr.next();
                if (!itr.hasNext()) continue;
                this.usage = this.usage + ", ";
            }
            this.usage = this.usage + ">";
        }
        int index = 0;
        this.help = new String[this.tree.size() + 1];
        this.help[index++] = this.getHeader() + " Options:";
        for (Map.Entry<String, Pair<CommandInfo, ArrayList<Pair<String, CommandInfo>>>> e : this.tree.entrySet()) {
            this.help[index] = this.primaryColor + e.getKey();
            for (String arg : e.getValue().getFirst().arguments) {
                int n = index;
                this.help[n] = this.help[n] + this.primaryColor + " [" + arg + this.primaryColor + "]";
            }
            int n = index++;
            this.help[n] = this.help[n] + " - " + this.secondaryColor + e.getValue().getFirst().description;
        }
    }

    public void addMainOption(String main, String descriptor, String ... args) {
        if (main == null) {
            return;
        }
        if (descriptor == null) {
            descriptor = "";
        }
        CommandInfo comInfo = new CommandInfo(main, descriptor, args);
        if (!this.tree.containsKey(main)) {
            this.tree.put(main, new Pair(comInfo, new ArrayList()));
        }
    }

    public void addSubOption(String mainOption, String subOption, String description, String ... args) {
        if (!this.tree.containsKey(mainOption)) {
            return;
        }
        CommandInfo comInfo = new CommandInfo(subOption, description, args);
        this.tree.get(mainOption).getSecond().add(new Pair<String, CommandInfo>(subOption, comInfo));
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            return;
        }
        if (args.length > 0) {
            if (args.length == 1 && !this.tree.containsKey(args[0])) {
                sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
                return;
            }
            if (args[0].equals(HELP_KEY)) {
                this.sendHelp(sender);
                return;
            }
            String[] truncatedArray = null;
            if (args.length <= 2) {
                truncatedArray = new String[]{};
            } else {
                truncatedArray = new String[args.length - 2];
                System.arraycopy(args, 1, truncatedArray, 0, truncatedArray.length);
            }
            this.executeTidyCommand(sender, args[0], args.length > 1 ? args[1] : "", truncatedArray);
        }
    }

    protected abstract void executeTidyCommand(ICommandSender var1, String var2, String var3, String[] var4);

    public boolean checkForSecondaryArgument(String arg0, String arg1) {
        if (!this.tree.containsKey(arg0)) {
            return false;
        }
        for (Pair<String, CommandInfo> str : this.tree.get(arg0).getSecond()) {
            if (!str.getFirst().equals(arg1)) continue;
            return true;
        }
        return false;
    }

    public String getHeader() {
        return this.primaryColor + "(" + this.displayName + ")" + this.secondaryColor;
    }

    public void sendHelp(ICommandSender sender) {
        for (String line : this.help) {
            sender.func_145747_a((ITextComponent)new TextComponentString(line));
        }
    }

    public void sendFormattedMessage(ICommandSender sender, String contents) {
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getHeader() + " " + contents));
    }

    public void sendNormalMessage(ICommandSender sender, String contents) {
        sender.func_145747_a((ITextComponent)new TextComponentString(contents));
    }

    public void sendOptionHelp(ICommandSender sender, String option) {
        ArrayList<Pair<String, CommandInfo>> result = this.tree.get(option).getSecond();
        this.sendFormattedMessage(sender, "For command " + option);
        for (Pair<String, CommandInfo> pair : result) {
            String string = this.primaryColor + pair.getFirst();
            for (String arg : pair.getSecond().arguments) {
                string = string + this.primaryColor + " [" + arg + "]";
            }
            string = string + " - " + this.secondaryColor + pair.getSecond().description;
            sender.func_145747_a((ITextComponent)new TextComponentString(string));
        }
    }

    public String func_71517_b() {
        return this.name;
    }

    public String func_71518_a(ICommandSender sender) {
        return this.usage;
    }

    private static class CommandInfo {
        public String name;
        public String[] arguments;
        public String description;

        public CommandInfo(String name, String desc, String ... arguments) {
            this.name = name;
            this.description = desc;
            this.arguments = arguments;
        }
    }
}

