/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation.jim;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.animation.jim.AnimationData;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class KeyedAnimation {
    public TreeMap<Float, AnimationData.BlockbenchTransition> bbMap = new TreeMap();
    public float prevTimer = 0.0f;
    public float timer = 0.0f;
    public float max = 2.0f;

    public KeyedAnimation(float max) {
        this.max = max;
    }

    public KeyedAnimation(AnimationData data) {
        for (Map.Entry<Float, AnimationData.BlockbenchTransition> entry : data.bbTransition.entrySet()) {
            this.bbMap.put(entry.getKey(), entry.getValue());
        }
        this.max = data.getAppointedDuration();
    }

    public void doPositioning(float speed) {
        this.doPositioning(1.0f, Vec3d.field_186680_a);
    }

    public void update(float speed) {
        this.prevTimer = this.timer;
        this.timer += speed;
        if (this.timer > this.max) {
            this.prevTimer = this.timer = 0.0f;
        }
    }

    public void doPositioning(float magnitude, Vec3d rotationPoint) {
        float leDelta;
        if ((double)magnitude == 0.0) {
            return;
        }
        float time = this.prevTimer + (this.timer - this.prevTimer) * ClientProxy.MC.func_184121_ak();
        float bottomKey = this.bbMap.floorEntry(Float.valueOf(time)).getKey().floatValue();
        float topKey = 0.0f;
        try {
            topKey = this.bbMap.ceilingKey(Float.valueOf(time)).floatValue();
        }
        catch (Exception e) {
            topKey = this.bbMap.floorKey(Float.valueOf(time)).floatValue();
        }
        Vec3d prevTrans = this.bbMap.floorEntry(Float.valueOf(time)).getValue().getTranslation();
        Vec3d nextTrans = this.bbMap.ceilingEntry(Float.valueOf(time)).getValue().getTranslation();
        if (nextTrans == null) {
            nextTrans = prevTrans;
        }
        Vec3d prevRot = this.bbMap.floorEntry(Float.valueOf(time)).getValue().getRotation();
        Vec3d nextRot = this.bbMap.ceilingEntry(Float.valueOf(time)).getValue().getRotation();
        if (nextRot == null) {
            nextRot = prevRot;
        }
        if (Double.isNaN(leDelta = (time - bottomKey) / (topKey - bottomKey))) {
            leDelta = 0.0f;
        }
        Vec3d translation = MatrixHelper.lerpVectors(prevTrans, nextTrans, leDelta);
        Vec3d rotation = MatrixHelper.lerpVectors(prevRot, nextRot, leDelta);
        translation = translation.func_186678_a((double)magnitude);
        rotation = rotation.func_186678_a((double)magnitude);
        double mul = 0.058823529411764705;
        GL11.glTranslated((double)(translation.field_72450_a * mul), (double)(-translation.field_72448_b * mul), (double)(translation.field_72449_c * mul));
        GlStateManager.func_179137_b((double)rotationPoint.field_72450_a, (double)rotationPoint.field_72448_b, (double)rotationPoint.field_72449_c);
        GL11.glRotated((double)rotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)rotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.func_179137_b((double)(-rotationPoint.field_72450_a), (double)(-rotationPoint.field_72448_b), (double)(-rotationPoint.field_72449_c));
    }
}

