/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation;

import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.animation.MultipartPositioning;
import com.paneedah.weaponlib.animation.MultipartTransition;
import com.paneedah.weaponlib.animation.MultipartTransitionProvider;
import com.paneedah.weaponlib.animation.PartPositionProvider;
import com.paneedah.weaponlib.animation.Randomizer;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.lwjgl.util.vector.Matrix4f;

class StaticPositioning<State, Part, Context extends PartPositionProvider>
implements MultipartPositioning<Part, Context> {
    private State state;
    private Randomizer randomizer;
    private MultipartTransitionProvider<State, Part, Context> transitionProvider;
    private Map<Part, Matrix4f> lastApplied;

    public StaticPositioning(MultipartTransitionProvider<State, Part, Context> transitionProvider, Randomizer randomizer, State state, Map<Part, Matrix4f> lastApplied) {
        this.transitionProvider = transitionProvider;
        this.randomizer = randomizer;
        this.state = state;
        this.lastApplied = lastApplied;
    }

    @Override
    public float getProgress() {
        return 1.0f;
    }

    @Override
    public boolean isExpired(Queue<MultipartPositioning<Part, Context>> positioningQueue) {
        return !positioningQueue.isEmpty();
    }

    @Override
    public MultipartPositioning.Positioner<Part, Context> getPositioner() {
        final List<MultipartTransition<Part, Context>> transitions = this.transitionProvider.getTransitions(this.state);
        return new MultipartPositioning.Positioner<Part, Context>(){

            @Override
            public void position(Part part, Context context) {
                try {
                    MultipartTransition multipartTransition = (MultipartTransition)transitions.get(transitions.size() - 1);
                    Object attachedTo = multipartTransition.getAttachedTo(part);
                    if (attachedTo != null) {
                        MatrixHelper.loadMatrix(context.getPartPosition(attachedTo));
                    }
                    if (multipartTransition.getPositioning(part) == MultipartTransition.anchoredPosition()) {
                        Matrix4f m = (Matrix4f)StaticPositioning.this.lastApplied.get(part);
                        MatrixHelper.applyMatrix(m);
                    } else {
                        multipartTransition.position(part, context);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to find static position for " + part + " in " + StaticPositioning.this.state);
                    throw e;
                }
            }

            @Override
            public void randomize(float rate, float amplitude) {
                StaticPositioning.this.randomizer.update(rate, amplitude);
            }
        };
    }

    @Override
    public <T> T getFromState(Class<T> stateClass) {
        return stateClass.cast(this.state);
    }

    @Override
    public <T> T getToState(Class<T> stateClass) {
        return stateClass.cast(this.state);
    }
}

