/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation;

import com.paneedah.weaponlib.animation.Interpolation;
import java.nio.FloatBuffer;
import javax.vecmath.Vector3d;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;

public class MatrixHelper {
    public static final double SINGULARITY_NORTH_POLE = 0.49999;
    public static final double SINGULARITY_SOUTH_POLE = -0.49999;

    public static Matrix4f yawPitchRollToMatrix(double yaw, double pitch, double roll) {
        double su = Math.sin(roll);
        double cu = Math.cos(roll);
        double sv = Math.sin(pitch);
        double cv = Math.cos(pitch);
        double sw = Math.sin(yaw);
        double cw = Math.cos(yaw);
        Matrix4f A = new Matrix4f();
        A.m00 = (float)(cv * cw);
        A.m10 = (float)(su * sv * cw - cu * sw);
        A.m20 = (float)(su * sw + cu * sv * cw);
        A.m01 = (float)(cv * sw);
        A.m11 = (float)(cu * cw + su * sv * sw);
        A.m21 = (float)(cu * sv * sw - su * cw);
        A.m02 = (float)(-sv);
        A.m12 = (float)(su * cv);
        A.m22 = (float)(cu * cv);
        return A;
    }

    public static double[] MatrixToYawPitchRoll(Matrix4f mat) {
        double[] angle = new double[3];
        angle[1] = -Math.asin(mat.m02);
        if (mat.m02 == 1.0f) {
            angle[0] = 0.0;
            angle[2] = Math.atan2(-mat.m10, -mat.m20);
            System.out.println("Gimbal lock: pitch = -90");
        } else if (mat.m02 == -1.0f) {
            angle[0] = 0.0;
            angle[2] = Math.atan2(mat.m10, mat.m20);
            System.out.println("Gimbal lock: pitch = 90");
        } else {
            angle[0] = Math.atan2(mat.m01, mat.m00);
            angle[2] = Math.atan2(mat.m12, mat.m22);
            System.out.println("No gimbal lock");
        }
        return angle;
    }

    public static void scaleFloatBuffer(FloatBuffer matrix, Vec3d scale) {
        matrix.put(0, (float)((double)matrix.get(0) * scale.field_72450_a));
        matrix.put(4, (float)((double)matrix.get(4) * scale.field_72450_a));
        matrix.put(8, (float)((double)matrix.get(8) * scale.field_72450_a));
        matrix.put(12, (float)((double)matrix.get(12) * scale.field_72450_a));
        matrix.put(1, (float)((double)matrix.get(1) * scale.field_72448_b));
        matrix.put(5, (float)((double)matrix.get(5) * scale.field_72448_b));
        matrix.put(9, (float)((double)matrix.get(9) * scale.field_72448_b));
        matrix.put(13, (float)((double)matrix.get(13) * scale.field_72448_b));
        matrix.put(2, (float)((double)matrix.get(2) * scale.field_72449_c));
        matrix.put(6, (float)((double)matrix.get(6) * scale.field_72449_c));
        matrix.put(10, (float)((double)matrix.get(10) * scale.field_72449_c));
        matrix.put(14, (float)((double)matrix.get(14) * scale.field_72449_c));
    }

    public static Vec3d extractScale(Matrix4f mat) {
        Vec3d a = new Vec3d((double)mat.m00, (double)mat.m01, (double)mat.m02);
        Vec3d b = new Vec3d((double)mat.m10, (double)mat.m11, (double)mat.m12);
        Vec3d c = new Vec3d((double)mat.m20, (double)mat.m21, (double)mat.m22);
        Vec3d scale = new Vec3d(a.func_72433_c(), b.func_72433_c(), c.func_72433_c());
        mat.m00 /= (float)scale.field_72450_a;
        mat.m01 /= (float)scale.field_72450_a;
        mat.m02 /= (float)scale.field_72450_a;
        mat.m10 /= (float)scale.field_72448_b;
        mat.m11 /= (float)scale.field_72448_b;
        mat.m12 /= (float)scale.field_72448_b;
        mat.m20 /= (float)scale.field_72449_c;
        mat.m21 /= (float)scale.field_72449_c;
        mat.m22 /= (float)scale.field_72449_c;
        return scale;
    }

    public static Vec3d extractScaleOld(Matrix4f mat) {
        Vec3d a = new Vec3d((double)mat.m00, (double)mat.m10, (double)mat.m20);
        Vec3d b = new Vec3d((double)mat.m01, (double)mat.m11, (double)mat.m21);
        Vec3d c = new Vec3d((double)mat.m02, (double)mat.m12, (double)mat.m22);
        Vec3d scale = new Vec3d(a.func_72433_c(), b.func_72433_c(), c.func_72433_c());
        mat.m00 /= (float)scale.field_72450_a;
        mat.m10 /= (float)scale.field_72450_a;
        mat.m20 /= (float)scale.field_72450_a;
        mat.m01 /= (float)scale.field_72448_b;
        mat.m11 /= (float)scale.field_72448_b;
        mat.m21 /= (float)scale.field_72448_b;
        mat.m02 /= (float)scale.field_72449_c;
        mat.m12 /= (float)scale.field_72449_c;
        mat.m22 /= (float)scale.field_72449_c;
        return scale;
    }

    public static Vec3d restoreScale(Matrix4f mat, Vec3d scale) {
        mat.m00 *= (float)scale.field_72450_a;
        mat.m10 *= (float)scale.field_72450_a;
        mat.m20 *= (float)scale.field_72450_a;
        mat.m01 *= (float)scale.field_72448_b;
        mat.m11 *= (float)scale.field_72448_b;
        mat.m21 *= (float)scale.field_72448_b;
        mat.m02 *= (float)scale.field_72449_c;
        mat.m12 *= (float)scale.field_72449_c;
        mat.m22 *= (float)scale.field_72449_c;
        return scale;
    }

    public static Vec3d lerpVectors(Vector3d a, Vector3d b, float t) {
        return MatrixHelper.lerpVectors(new Vec3d(a.x, a.y, a.z), new Vec3d(b.x, b.y, b.z), t);
    }

    public static Vec3d lerpVectors(Vec3d a, Vec3d b, float t) {
        return new Vec3d((double)MatrixHelper.solveLerp((float)a.field_72450_a, (float)b.field_72450_a, t), (double)MatrixHelper.solveLerp((float)a.field_72448_b, (float)b.field_72448_b, t), (double)MatrixHelper.solveLerp((float)a.field_72449_c, (float)b.field_72449_c, t));
    }

    public static Matrix4f buildTranslation(float x, float y, float z) {
        return MatrixHelper.build(1.0f, 0.0f, 0.0f, x, 0.0f, 1.0f, 0.0f, y, 0.0f, 0.0f, 1.0f, z, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static Matrix4f build(float m00, float m10, float m20, float m30, float m01, float m11, float m21, float m31, float m02, float m12, float m22, float m32, float m03, float m13, float m23, float m33) {
        Matrix4f m = new Matrix4f();
        m.m00 = m00;
        m.m01 = m01;
        m.m02 = m02;
        m.m03 = m03;
        m.m10 = m10;
        m.m11 = m11;
        m.m12 = m12;
        m.m13 = m13;
        m.m20 = m20;
        m.m21 = m21;
        m.m22 = m22;
        m.m23 = m23;
        m.m30 = m30;
        m.m31 = m31;
        m.m32 = m32;
        m.m33 = m33;
        return m;
    }

    public static Quaternion slerp(Quaternion v0, Quaternion v1, float t) {
        double dot = Quaternion.dot((Quaternion)v0, (Quaternion)v1);
        if (dot < 0.0) {
            v1 = new Quaternion(-v1.x, -v1.y, -v1.z, -v1.w);
            dot = -dot;
        }
        double DOT_THRESHOLD = 0.9999999;
        if (dot > 0.9999999) {
            Quaternion result = new Quaternion(v0.x + t * v1.x, v0.y + t * v1.y, v0.z + t * v1.z, v0.w + t * v1.w);
            result.normalise();
            return result;
        }
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * (double)t;
        double sin_theta = Math.sin(theta);
        double sin_theta_0 = Math.sin(theta_0);
        float s0 = (float)(Math.cos(theta) - dot * sin_theta / sin_theta_0);
        float s1 = (float)(sin_theta / sin_theta_0);
        return new Quaternion(s0 * v0.x + s1 * v1.x, s0 * v0.y + s1 * v1.y, s0 * v0.z + s1 * v1.z, s0 * v0.w + s1 * v1.w);
    }

    public static float solveBeizer(float a, float b, float c, float t) {
        return (float)(Math.pow(1.0f - t, 2.0) * (double)a + (double)(2.0f * t * (1.0f - t) * b) + (double)(t * t * c));
    }

    public static Vec3d solveBeizer(Vec3d before, Vec3d after, Vec3d beizer, double t) {
        double x = MatrixHelper.solveBeizer((float)before.field_72450_a, (float)beizer.field_72450_a, (float)after.field_72450_a, (float)t);
        double y = MatrixHelper.solveBeizer((float)before.field_72448_b, (float)beizer.field_72448_b, (float)after.field_72448_b, (float)t);
        double z = MatrixHelper.solveBeizer((float)before.field_72449_c, (float)beizer.field_72449_c, (float)after.field_72449_c, (float)t);
        return new Vec3d(x, y, z);
    }

    public static float solveLerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public static double solveLerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    public static Matrix4f beizerInterpolation(Matrix4f a, Matrix4f b, Matrix4f c, float t, boolean doRotation) {
        Matrix4f newMatrix = new Matrix4f();
        if (doRotation) {
            newMatrix.m00 = MatrixHelper.solveBeizer(a.m00, b.m00, c.m00, t);
            newMatrix.m01 = MatrixHelper.solveBeizer(a.m01, b.m01, c.m01, t);
            newMatrix.m02 = MatrixHelper.solveBeizer(a.m02, b.m02, c.m02, t);
            newMatrix.m03 = MatrixHelper.solveBeizer(a.m03, b.m03, c.m03, t);
            newMatrix.m10 = MatrixHelper.solveBeizer(a.m10, b.m10, c.m10, t);
            newMatrix.m11 = MatrixHelper.solveBeizer(a.m11, b.m11, c.m11, t);
            newMatrix.m12 = MatrixHelper.solveBeizer(a.m12, b.m12, c.m12, t);
            newMatrix.m13 = MatrixHelper.solveBeizer(a.m13, b.m13, c.m13, t);
            newMatrix.m20 = MatrixHelper.solveBeizer(a.m20, b.m20, c.m20, t);
            newMatrix.m21 = MatrixHelper.solveBeizer(a.m21, b.m21, c.m21, t);
            newMatrix.m22 = MatrixHelper.solveBeizer(a.m22, b.m22, c.m22, t);
            newMatrix.m23 = MatrixHelper.solveBeizer(a.m23, b.m23, c.m23, t);
        } else {
            float factor = t * t * (3.0f - 2.0f * t);
            newMatrix.m00 = MatrixHelper.solveLerp(a.m00, b.m00, factor);
            newMatrix.m01 = MatrixHelper.solveLerp(a.m01, b.m01, factor);
            newMatrix.m02 = MatrixHelper.solveLerp(a.m02, b.m02, factor);
            newMatrix.m03 = MatrixHelper.solveLerp(a.m03, b.m03, factor);
            newMatrix.m10 = MatrixHelper.solveLerp(a.m10, b.m10, factor);
            newMatrix.m11 = MatrixHelper.solveLerp(a.m11, b.m11, factor);
            newMatrix.m12 = MatrixHelper.solveLerp(a.m12, b.m12, factor);
            newMatrix.m13 = MatrixHelper.solveLerp(a.m13, b.m13, factor);
            newMatrix.m20 = MatrixHelper.solveLerp(a.m20, b.m20, factor);
            newMatrix.m21 = MatrixHelper.solveLerp(a.m21, b.m21, factor);
            newMatrix.m22 = MatrixHelper.solveLerp(a.m22, b.m22, factor);
            newMatrix.m23 = MatrixHelper.solveLerp(a.m23, b.m23, factor);
        }
        newMatrix.m30 = MatrixHelper.solveBeizer(a.m30, b.m30, c.m30, t);
        newMatrix.m31 = MatrixHelper.solveBeizer(a.m31, b.m31, c.m31, t);
        newMatrix.m32 = MatrixHelper.solveBeizer(a.m32, b.m32, c.m32, t);
        newMatrix.m33 = MatrixHelper.solveBeizer(a.m33, b.m33, c.m33, t);
        return newMatrix;
    }

    public static void applyMatrix(Matrix4f m) {
        if (m == null) {
            return;
        }
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        m.store(buf);
        buf.rewind();
        GL11.glMatrixMode((int)5888);
        GL11.glMultMatrix((FloatBuffer)buf);
    }

    public static void loadMatrix(Matrix4f m) {
        if (m == null) {
            return;
        }
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        m.store(buf);
        buf.rewind();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadMatrix((FloatBuffer)buf);
    }

    public static Matrix4f captureMatrix() {
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)buf);
        buf.rewind();
        Matrix4f matrix = new Matrix4f();
        GL11.glMatrixMode((int)5888);
        matrix.load(buf);
        return matrix;
    }

    public static FloatBuffer getModelViewMatrixBuffer() {
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)buf);
        buf.rewind();
        return buf;
    }

    public Matrix4f interpTwo(Matrix4f one, Matrix4f two, float f) {
        Matrix4f result = new Matrix4f();
        result.m00 = MatrixHelper.solveLerp(one.m00, two.m00, f);
        result.m01 = MatrixHelper.solveLerp(one.m01, two.m01, f);
        result.m02 = MatrixHelper.solveLerp(one.m02, two.m02, f);
        result.m03 = MatrixHelper.solveLerp(one.m03, two.m03, f);
        result.m10 = MatrixHelper.solveLerp(one.m10, two.m10, f);
        result.m11 = MatrixHelper.solveLerp(one.m11, two.m11, f);
        result.m12 = MatrixHelper.solveLerp(one.m12, two.m12, f);
        result.m13 = MatrixHelper.solveLerp(one.m13, two.m13, f);
        result.m20 = MatrixHelper.solveLerp(one.m20, two.m20, f);
        result.m21 = MatrixHelper.solveLerp(one.m21, two.m21, f);
        result.m22 = MatrixHelper.solveLerp(one.m22, two.m22, f);
        result.m23 = MatrixHelper.solveLerp(one.m23, two.m23, f);
        result.m30 = MatrixHelper.solveLerp(one.m30, two.m30, f);
        result.m31 = MatrixHelper.solveLerp(one.m31, two.m31, f);
        result.m32 = MatrixHelper.solveLerp(one.m32, two.m32, f);
        result.m33 = MatrixHelper.solveLerp(one.m33, two.m33, f);
        return result;
    }

    public static Matrix4f interpolateMatrix(Matrix4f m, float factor, Interpolation interp) {
        factor = (float)interp.interpolate(factor);
        Matrix4f result = new Matrix4f();
        result.m00 = m.m00 * factor;
        result.m01 = m.m01 * factor;
        result.m02 = m.m02 * factor;
        result.m03 = m.m03 * factor;
        result.m10 = m.m10 * factor;
        result.m11 = m.m11 * factor;
        result.m12 = m.m12 * factor;
        result.m13 = m.m13 * factor;
        result.m20 = m.m20 * factor;
        result.m21 = m.m21 * factor;
        result.m22 = m.m22 * factor;
        result.m23 = m.m23 * factor;
        result.m30 = m.m30 * factor;
        result.m31 = m.m31 * factor;
        result.m32 = m.m32 * factor;
        result.m33 = m.m33 * factor;
        return result;
    }

    public static Quaternion fromEulerAngles(double roll, double pitch, double yaw) {
        double[] q = new double[4];
        double c1 = Math.cos(yaw / 2.0);
        double s1 = Math.sin(yaw / 2.0);
        double c2 = Math.cos(pitch / 2.0);
        double s2 = Math.sin(pitch / 2.0);
        double c3 = Math.cos(roll / 2.0);
        double s3 = Math.sin(roll / 2.0);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        q[0] = c1c2 * c3 - s1s2 * s3;
        q[1] = c1c2 * s3 + s1s2 * c3;
        q[2] = s1 * c2 * c3 + c1 * s2 * s3;
        q[3] = c1 * s2 * c3 - s1 * c2 * s3;
        return new Quaternion((float)q[0], (float)q[1], (float)q[2], (float)q[3]);
    }

    public static double toRoll(Quaternion q) {
        double test = q.x * q.y + q.z * q.w;
        if (test > 0.49999) {
            return 0.0;
        }
        if (test < -0.49999) {
            return 0.0;
        }
        return Math.atan2(2.0f * q.x * q.w - 2.0f * q.y * q.z, 1.0f - 2.0f * q.x * q.x - 2.0f * q.z * q.z);
    }

    public static double toPitch(Quaternion q) {
        double test = q.x * q.y + q.z * q.w;
        if (test > 0.49999) {
            return 1.5707963267948966;
        }
        if (test < -0.49999) {
            return -1.5707963267948966;
        }
        return Math.asin(2.0 * test);
    }

    public static double toYaw(Quaternion q) {
        double test = q.x * q.y + q.z * q.w;
        if (test > 0.49999) {
            return 2.0 * Math.atan2(q.x, q.w);
        }
        if (test < -0.49999) {
            return -2.0 * Math.atan2(q.x, q.w);
        }
        return Math.atan2(2.0f * q.y * q.w - 2.0f * q.x * q.z, 1.0f - 2.0f * q.y * q.y - 2.0f * q.z * q.z);
    }

    public static double[] toEulerAngles(Quaternion q) {
        return new double[]{MatrixHelper.toRoll(q), MatrixHelper.toPitch(q), MatrixHelper.toYaw(q)};
    }
}

