/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.NetworkPermitManager;
import com.paneedah.mwc.network.messages.MuzzleFlashMessage;
import com.paneedah.mwc.network.messages.ShellMessageClient;
import com.paneedah.mwc.network.messages.TryFireMessage;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.ClientEventHandler;
import com.paneedah.weaponlib.CommonModContext;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.Tags;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.WeaponSpawnEntity;
import com.paneedah.weaponlib.WeaponState;
import com.paneedah.weaponlib.animation.ClientValueRepo;
import com.paneedah.weaponlib.config.BalancePackManager;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.render.shells.ShellParticleSimulator;
import com.paneedah.weaponlib.state.Aspect;
import com.paneedah.weaponlib.state.StateManager;
import io.redstudioragnarok.redcore.vectors.Vector3D;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WeaponFireAspect
implements Aspect<WeaponState, PlayerWeaponInstance> {
    private static final float FLASH_X_OFFSET_ZOOMED = -0.03f;
    private static final long ALERT_TIMEOUT = 500L;
    private static Predicate<PlayerWeaponInstance> readyToShootAccordingToFireRate = instance -> (float)(System.currentTimeMillis() - instance.getLastFireTimestamp()) >= 50.0f / BalancePackManager.getFirerate(instance.getWeapon());
    private static Predicate<PlayerWeaponInstance> postBurstTimeoutExpired = instance -> System.currentTimeMillis() - instance.getLastBurstEndTimestamp() >= instance.getWeapon().builder.burstTimeoutMilliseconds;
    private static Predicate<PlayerWeaponInstance> readyToShootAccordingToFireMode = instance -> instance.getSeriesShotCount() < instance.getMaxShots();
    private static Predicate<PlayerWeaponInstance> oneClickBurstEnabled = PlayerWeaponInstance::isOneClickBurstAllowed;
    private static Predicate<PlayerWeaponInstance> seriesResetAllowed = PlayerWeaponInstance::isSeriesResetAllowed;
    private static Predicate<PlayerWeaponInstance> hasAmmo = instance -> instance.getAmmo() > 0 && Tags.getAmmo(instance.getItemStack()) > 0;
    private static Predicate<PlayerWeaponInstance> ejectSpentRoundRequired = instance -> instance.getWeapon().ejectSpentRoundRequired();
    private static Predicate<PlayerWeaponInstance> ejectSpentRoundTimeoutExpired = instance -> {
        boolean time = System.currentTimeMillis() >= instance.getWeapon().builder.pumpTimeoutMilliseconds + instance.getStateUpdateTimestamp();
        return time;
    };
    private static Predicate<PlayerWeaponInstance> alertTimeoutExpired = instance -> System.currentTimeMillis() >= 500L + instance.getStateUpdateTimestamp();
    private static Predicate<PlayerWeaponInstance> sprinting = instance -> instance.getPlayer().func_70051_ag();
    private static final Set<WeaponState> allowedFireOrEjectFromStates = new HashSet<WeaponState>(Arrays.asList(WeaponState.READY, WeaponState.PAUSED, WeaponState.EJECT_REQUIRED));
    private static final Set<WeaponState> allowedUpdateFromStates = new HashSet<WeaponState>(Arrays.asList(WeaponState.EJECTING, WeaponState.PAUSED, WeaponState.FIRING, WeaponState.RECOILED, WeaponState.PAUSED, WeaponState.ALERT));
    private ModContext modContext;
    private StateManager<WeaponState, ? super PlayerWeaponInstance> stateManager;

    public WeaponFireAspect(CommonModContext modContext) {
        this.modContext = modContext;
    }

    @Override
    public void setPermitManager(NetworkPermitManager permitManager) {
    }

    @Override
    public void setStateManager(StateManager<WeaponState, ? super PlayerWeaponInstance> stateManager) {
        this.stateManager = stateManager;
        stateManager.in(this).change(WeaponState.READY).to(WeaponState.ALERT).when(hasAmmo.negate()).withAction(this::cannotFire).manual().in(this).change(WeaponState.ALERT).to(WeaponState.READY).when(alertTimeoutExpired).automatic().in(this).change(WeaponState.READY).to(WeaponState.FIRING).when(hasAmmo.and(sprinting.negate()).and(readyToShootAccordingToFireRate)).withAction(this::fire).manual().in(this).change(WeaponState.FIRING).to(WeaponState.RECOILED).automatic().in(this).change(WeaponState.RECOILED).to(WeaponState.PAUSED).automatic().in(this).change(WeaponState.PAUSED).to(WeaponState.EJECT_REQUIRED).when(ejectSpentRoundRequired).manual().in(this).change(WeaponState.EJECT_REQUIRED).to(WeaponState.EJECTING).withAction(this::ejectSpentRound).manual().in(this).change(WeaponState.EJECTING).to(WeaponState.READY).when(ejectSpentRoundTimeoutExpired).automatic().in(this).change(WeaponState.PAUSED).to(WeaponState.FIRING).when(hasAmmo.and(sprinting.negate()).and(readyToShootAccordingToFireMode).and(readyToShootAccordingToFireRate)).withAction(this::fire).manual().in(this).change(WeaponState.PAUSED).to(WeaponState.FIRING).when(hasAmmo.and(sprinting.negate()).and(oneClickBurstEnabled).and(readyToShootAccordingToFireMode).and(readyToShootAccordingToFireRate)).withAction(this::fire).automatic().in(this).change(WeaponState.PAUSED).to(WeaponState.READY).when(ejectSpentRoundRequired.negate().and(oneClickBurstEnabled).and(readyToShootAccordingToFireMode.negate().or(hasAmmo.negate())).and(seriesResetAllowed).and(postBurstTimeoutExpired)).withAction(PlayerWeaponInstance::resetCurrentSeries).automatic().in(this).change(WeaponState.PAUSED).to(WeaponState.READY).when(ejectSpentRoundRequired.negate().and(oneClickBurstEnabled.negate())).withAction(PlayerWeaponInstance::resetCurrentSeries).manual();
    }

    void onFireButtonDown(EntityPlayer player) {
        PlayerWeaponInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (weaponInstance != null) {
            this.stateManager.changeStateFromAnyOf(this, weaponInstance, allowedFireOrEjectFromStates, new WeaponState[]{WeaponState.FIRING, WeaponState.EJECTING, WeaponState.ALERT});
        }
    }

    void onFireButtonRelease(EntityPlayer player) {
        PlayerWeaponInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (weaponInstance != null) {
            weaponInstance.setSeriesResetAllowed(true);
            this.stateManager.changeState(this, weaponInstance, new WeaponState[]{WeaponState.EJECT_REQUIRED, WeaponState.READY});
        }
    }

    void onUpdate(EntityPlayer player) {
        PlayerWeaponInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (weaponInstance != null) {
            this.stateManager.changeStateFromAnyOf(this, weaponInstance, allowedUpdateFromStates, new WeaponState[0]);
        }
    }

    private void cannotFire(PlayerWeaponInstance weaponInstance) {
        if (weaponInstance.getAmmo() == 0 || Tags.getAmmo(weaponInstance.getItemStack()) == 0) {
            String message = weaponInstance.getWeapon().getAmmoCapacity() == 0 && this.modContext.getAttachmentAspect().getActiveAttachment(weaponInstance, AttachmentCategory.MAGAZINE) == null ? I18n.func_135052_a((String)"gui.noMagazine", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.noAmmo", (Object[])new Object[0]);
            if (weaponInstance.getPlayer() instanceof EntityPlayer) {
                ((EntityPlayer)weaponInstance.getPlayer()).func_146105_b((ITextComponent)new TextComponentString(message), true);
            }
            if (weaponInstance.getPlayer() instanceof EntityPlayer) {
                weaponInstance.getPlayer().func_184185_a(this.modContext.getNoAmmoSound(), 1.0f, 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playShootSound(PositionedSoundRecord psr) {
        ClientProxy.MC.func_147118_V().func_147682_a((ISound)psr);
    }

    private void fire(PlayerWeaponInstance weaponInstance) {
        int seriesShotCount;
        int currentAmmo;
        EntityLivingBase player = weaponInstance.getPlayer();
        Weapon weapon = (Weapon)weaponInstance.getItem();
        Random random = player.func_70681_au();
        MWC.CHANNEL.sendToServer((IMessage)new TryFireMessage(oneClickBurstEnabled.test(weaponInstance) && weaponInstance.getSeriesShotCount() == 0, weaponInstance.isAimed()));
        boolean silencerOn = this.modContext.getAttachmentAspect().isSilencerOn(weaponInstance);
        SoundEvent shootSound = null;
        if (oneClickBurstEnabled.test(weaponInstance)) {
            SoundEvent burstShootSound = null;
            if (silencerOn) {
                burstShootSound = weapon.getSilencedBurstShootSound();
            }
            if (burstShootSound == null) {
                burstShootSound = weapon.getBurstShootSound();
            }
            if (burstShootSound != null) {
                if (weaponInstance.getSeriesShotCount() == 0) {
                    shootSound = burstShootSound;
                }
            } else {
                shootSound = silencerOn ? weapon.getSilencedShootSound() : weapon.getShootSound();
            }
        } else {
            SoundEvent soundEvent = shootSound = silencerOn ? weapon.getSilencedShootSound() : weapon.getShootSound();
        }
        if (shootSound != null && !FMLCommonHandler.instance().getSide().isServer()) {
            PositionedSoundRecord psr = new PositionedSoundRecord(shootSound, SoundCategory.PLAYERS, silencerOn ? weapon.getSilencedShootSoundVolume() * 0.4f : weapon.getShootSoundVolume() * 0.4f, 1.0f, ClientProxy.MC.field_71439_g.func_180425_c().func_177981_b(5));
            this.playShootSound(psr);
        }
        if ((currentAmmo = weaponInstance.getAmmo()) == 1 && weapon.getEndOfShootSound() != null && !FMLCommonHandler.instance().getSide().isServer()) {
            PositionedSoundRecord psr = new PositionedSoundRecord(weapon.getEndOfShootSound(), SoundCategory.PLAYERS, 1.0f, 1.0f, ClientProxy.MC.field_71439_g.func_180425_c().func_177981_b(5));
            this.playShootSound(psr);
        }
        if (currentAmmo == 1) {
            weaponInstance.setSlideLock(true);
        }
        float recoilAmount = weaponInstance.getRecoil();
        recoilAmount = (float)((double)recoilAmount * BalancePackManager.getGlobalRecoilMultiplier());
        recoilAmount = (float)((double)recoilAmount * BalancePackManager.getGroupRecoilMultiplier(weapon.getConfigurationGroup()));
        player.field_70125_A -= recoilAmount * 0.7f;
        float rotationYawFactor = -1.0f + random.nextFloat() * 2.0f;
        player.field_70177_z += recoilAmount * rotationYawFactor * 0.4f;
        ClientValueRepo.recoilWoundY += (double)(recoilAmount * 0.7f);
        if (ModernConfigManager.enableMuzzleEffects && weapon.builder.flashIntensity > 0.0f) {
            this.modContext.getEffectManager().spawnFlashParticle(player, weapon.builder.flashIntensity, weapon.builder.flashScale.get().floatValue(), weaponInstance.isAimed() ? -0.03f : -0.1f + weapon.builder.flashOffsetX.get().floatValue(), weaponInstance.isAimed() ? -1.55f : -1.7f + weapon.builder.flashOffsetY.get().floatValue(), weapon.builder.flashTexture);
        }
        ClientValueRepo.fireWeapon(weaponInstance);
        if (weapon.isSmokeEnabled()) {
            this.modContext.getEffectManager().spawnSmokeParticle(player, -0.1f + weapon.builder.smokeOffsetX.get().floatValue(), -1.7f + weapon.builder.smokeOffsetY.get().floatValue() + 0.3f);
        }
        if (weapon.isShellCasingEjectEnabled()) {
            float fovMult = ClientProxy.MC.field_71474_y.field_74334_X < 70.0f ? ClientProxy.MC.field_71474_y.field_74334_X / 50.0f : -(ClientProxy.MC.field_71474_y.field_74334_X / 200.0f);
            Vec3d pos = player.func_174824_e(1.0f);
            Vec3d weaponDir = new Vec3d(0.0, -0.1, 1.0 + (double)fovMult).func_178789_a((float)Math.toRadians(-player.field_70125_A)).func_178785_b((float)Math.toRadians(-player.field_70177_z));
            Vec3d velocity = new Vec3d(-0.3, 0.1, 0.0);
            velocity = velocity.func_178785_b((float)Math.toRadians(-player.field_70177_z));
            ShellParticleSimulator.Shell shell = new ShellParticleSimulator.Shell(weapon.getShellType(), pos.func_178787_e(weaponDir), new Vec3d(-90.0, 0.0, (double)(180.0f + player.field_70177_z)), velocity);
            ClientEventHandler.SHELL_MANAGER.enqueueShell(shell);
        }
        if ((seriesShotCount = weaponInstance.getSeriesShotCount()) == 0) {
            weaponInstance.setSeriesResetAllowed(false);
        }
        weaponInstance.setSeriesShotCount(seriesShotCount + 1);
        if (currentAmmo == 1 || weaponInstance.getSeriesShotCount() == weaponInstance.getMaxShots()) {
            weaponInstance.setLastBurstEndTimestamp(System.currentTimeMillis());
        }
        weaponInstance.setLastFireTimestamp(System.currentTimeMillis());
        weaponInstance.setAmmo(currentAmmo - 1);
    }

    private void ejectSpentRound(PlayerWeaponInstance weaponInstance) {
        EntityLivingBase player = weaponInstance.getPlayer();
        player.func_184185_a(weaponInstance.getWeapon().getEjectSpentRoundSound(), 1.0f, 1.0f);
    }

    public void serverFire(EntityLivingBase player, boolean isBurst, boolean isAimed) {
        this.serverFire(player, player.func_184614_ca(), null, isBurst, isAimed, 1.0f);
    }

    public void serverFire(EntityLivingBase player, ItemStack itemStack, BiFunction<Weapon, EntityLivingBase, ? extends WeaponSpawnEntity> spawnEntityWith, boolean isBurst, boolean isAimed, float damageMultiplier) {
        boolean silencerOn;
        if (!(itemStack.func_77973_b() instanceof Weapon)) {
            return;
        }
        NetworkRegistry.TargetPoint tp = new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 100.0);
        MWC.CHANNEL.sendToAllAround((IMessage)new MuzzleFlashMessage(player.func_145782_y()), tp);
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        int currentServerAmmo = Tags.getAmmo(itemStack);
        if (currentServerAmmo <= 0) {
            ModReference.LOG.error("No server ammo");
            return;
        }
        Tags.setAmmo(itemStack, --currentServerAmmo);
        if (spawnEntityWith == null) {
            spawnEntityWith = weapon.builder.spawnEntityWith;
        }
        for (int i = 0; i < weapon.builder.pellets; ++i) {
            double damage = weapon.getSpawnEntityDamage();
            double hipFireSpread = 2.6;
            if (BalancePackManager.hasActiveBalancePack()) {
                if (BalancePackManager.shouldChangeWeaponDamage(weapon)) {
                    damage = BalancePackManager.getNewWeaponDamage(weapon);
                }
                damage *= BalancePackManager.getGroupDamageMultiplier(weapon.getConfigurationGroup());
                damage *= BalancePackManager.getGlobalDamageMultiplier();
                hipFireSpread = BalancePackManager.getGlobalHipFireSpread();
                hipFireSpread *= BalancePackManager.getGroupHipFireSpread(weapon.getConfigurationGroup());
            }
            WeaponSpawnEntity bullet = new WeaponSpawnEntity(weapon, player.field_70170_p, player, weapon.getSpawnEntityVelocity(), weapon.getSpawnEntityGravityVelocity(), BalancePackManager.getInaccuracy(weapon) + (isAimed ? 0.0f : (float)hipFireSpread), (float)(damage *= (double)damageMultiplier), weapon.getSpawnEntityExplosionRadius(), weapon.isDestroyingBlocks(), weapon.hasRocketParticles(), weapon.getParticleAgeCoefficient(), weapon.getSmokeParticleAgeCoefficient(), weapon.getExplosionScaleCoefficient(), weapon.getSmokeParticleScaleCoefficient(), 0, 0);
            bullet.setPositionAndDirection(isAimed);
            player.field_70170_p.func_72838_d((Entity)bullet);
        }
        PlayerWeaponInstance playerWeaponInstance = Tags.getInstance(itemStack, PlayerWeaponInstance.class);
        if (playerWeaponInstance != null) {
            Vec3d pos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            Vec3d weaponDir = new Vec3d(0.0, -0.1, 1.0).func_178789_a((float)Math.toRadians(-player.field_70125_A)).func_178785_b((float)Math.toRadians(-player.field_70177_z));
            Vec3d velocity = new Vec3d(-0.3, 0.1, 0.0);
            velocity = velocity.func_178785_b((float)Math.toRadians(-player.field_70177_z));
            MWC.CHANNEL.sendToAllAround((IMessage)new ShellMessageClient(player.func_145782_y(), playerWeaponInstance.getWeapon().getShellType(), new Vector3D(pos.func_178787_e(weaponDir)), new Vector3D(velocity)), tp);
        }
        SoundEvent shootSound = null;
        boolean bl = silencerOn = playerWeaponInstance != null && this.modContext.getAttachmentAspect().isSilencerOn(playerWeaponInstance);
        if (isBurst && weapon.builder.isOneClickBurstAllowed) {
            SoundEvent burstShootSound = null;
            if (silencerOn) {
                burstShootSound = weapon.getSilencedBurstShootSound();
            }
            if (burstShootSound == null) {
                burstShootSound = weapon.getBurstShootSound();
            }
            shootSound = burstShootSound != null ? burstShootSound : (silencerOn ? weapon.getSilencedShootSound() : weapon.getShootSound());
        } else {
            shootSound = silencerOn ? weapon.getSilencedShootSound() : weapon.getShootSound();
        }
        player.field_70170_p.func_184148_a(player instanceof EntityPlayer ? (EntityPlayer)player : null, player.field_70165_t, player.field_70163_u, player.field_70161_v, shootSound, player.func_184176_by(), silencerOn ? weapon.getSilencedShootSoundVolume() : weapon.getShootSoundVolume(), 1.0f);
    }
}

