/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.network.TypeRegistry;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.AsyncWeaponState;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.CompatibleAttachment;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ItemScope;
import com.paneedah.weaponlib.MiscUtils;
import com.paneedah.weaponlib.Pair;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.Tags;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.WeaponState;
import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.animation.gui.AnimationGUI;
import com.paneedah.weaponlib.command.DebugCommand;
import com.paneedah.weaponlib.compatibility.RecoilParam;
import com.paneedah.weaponlib.config.BalancePackManager;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.perspective.OpticalScopePerspective;
import com.paneedah.weaponlib.perspective.Perspective;
import com.paneedah.weaponlib.shader.DynamicShaderGroupSource;
import com.paneedah.weaponlib.shader.DynamicShaderGroupSourceProvider;
import com.paneedah.weaponlib.shader.DynamicShaderPhase;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Deque;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerWeaponInstance
extends PlayerItemInstance<WeaponState>
implements DynamicShaderGroupSourceProvider {
    private static final int SERIAL_VERSION = 9;
    private static final UUID NIGHT_VISION_SOURCE_UUID;
    private static final UUID VIGNETTE_SOURCE_UUID;
    private static final UUID BLUR_SOURCE_UUID;
    public final DynamicShaderGroupSource BLUR_SOURCE = new DynamicShaderGroupSource(BLUR_SOURCE_UUID, new ResourceLocation("weaponlib:/com/paneedah/weaponlib/resources/blur.json")).withUniform("Radius", context -> Float.valueOf(this.hasOpticScope() ? 10.0f : 5.0f)).withUniform("Progress", context -> Float.valueOf(this.getAimChangeProgress()));
    public final DynamicShaderGroupSource NIGHT_VISION_SOURCE = new DynamicShaderGroupSource(NIGHT_VISION_SOURCE_UUID, new ResourceLocation("weaponlib:/com/paneedah/weaponlib/resources/night-vision.json")).withUniform("IntensityAdjust", context -> Float.valueOf(40.0f - ClientProxy.MC.field_71474_y.field_74333_Y * 38.0f)).withUniform("NoiseAmplification", context -> Float.valueOf(2.0f + 3.0f * ClientProxy.MC.field_71474_y.field_74333_Y));
    public final DynamicShaderGroupSource VIGNETTE_SOURCE = new DynamicShaderGroupSource(VIGNETTE_SOURCE_UUID, new ResourceLocation("weaponlib:/com/paneedah/weaponlib/resources/vignette.json")).withUniform("Radius", context -> Float.valueOf(this.getOpticScopeVignetteRadius(context.getPartialTicks()))).withUniform("Reticle", context -> {
        GlStateManager.func_179138_g((int)33988);
        ClientProxy.MC.func_110434_K().func_110577_a(new ResourceLocation("mwc:textures/hud/reticle1.png"));
        GlStateManager.func_179138_g((int)33984);
        return 4;
    });
    private static final long AIM_CHANGE_DURATION = 1200L;
    private int ammo;
    private float recoil;
    private int seriesShotCount;
    private long lastFireTimestamp;
    private boolean aimed;
    private int maxShots;
    private float zoom = 1.0f;
    private byte activeTextureIndex;
    private boolean laserOn;
    private long aimChangeTimestamp;
    private boolean nightVisionOn;
    private boolean seriesResetAllowed;
    private long lastBurstEndTimestamp;
    private boolean altModificationModeEnabled;
    private int loadIterationCount;
    private boolean loadAfterUnloadEnabled;
    private boolean isDelayCompoundEnd = true;
    private long stateReloadUpdateTimestamp;
    private boolean isAwaitingCompoundInstructions = false;
    public boolean isSlideInLock = false;
    private Deque<AsyncWeaponState> filteredStateQueue = new LinkedBlockingDeque<AsyncWeaponState>();
    private int[] activeAttachmentIds = new int[0];
    private byte[] selectedAttachmentIndexes = new byte[0];

    public PlayerWeaponInstance() {
    }

    public PlayerWeaponInstance(int itemInventoryIndex, EntityLivingBase player, ItemStack itemStack) {
        super(itemInventoryIndex, player, itemStack);
    }

    public PlayerWeaponInstance(int itemInventoryIndex, EntityLivingBase player) {
        super(itemInventoryIndex, player);
    }

    @Override
    protected int getSerialVersion() {
        return 9;
    }

    public RecoilParam getRecoilParameters() {
        if (AnimationModeProcessor.getInstance().getFPSMode()) {
            return AnimationGUI.getInstance().getRecoilParams();
        }
        return this.getWeapon().builder.recoilParam;
    }

    public Pair<Double, Double> getScreenShakeParameters() {
        if (DebugCommand.isWorkingOnScreenShake()) {
            return DebugCommand.screenShakeParam;
        }
        return this.getWeapon().getModernScreenShakeParameters();
    }

    private void addStateToHistory(WeaponState state) {
        long expirationTimeout;
        AsyncWeaponState t;
        while ((t = this.filteredStateQueue.peekFirst()) != null && t.getState().getPriority() < state.getPriority()) {
            this.filteredStateQueue.pollFirst();
        }
        if (state == WeaponState.FIRING || state == WeaponState.RECOILED || state == WeaponState.PAUSED) {
            expirationTimeout = this.isAutomaticModeEnabled() && !this.getWeapon().hasRecoilPositioning() ? (long)(50.0f / this.getFireRate()) : 500L;
            expirationTimeout = 500L;
        } else {
            expirationTimeout = Integer.MAX_VALUE;
        }
        this.filteredStateQueue.addFirst(new AsyncWeaponState(state, this.stateUpdateTimestamp, expirationTimeout));
    }

    public long getAnimationDuration() {
        if (!this.getWeapon().builder.isUsingNewSystem()) {
            ModReference.LOG.debug("Weapon is using the old system, returning standard value");
            return this.getWeapon().getTotalReloadingDuration();
        }
        return this.getAnimationDuration((WeaponState)this.getState());
    }

    public long getAnimationDuration(WeaponState state) {
        switch (state) {
            case LOAD: {
                return this.getWeapon().getTotalReloadingDuration();
            }
            case UNLOAD: {
                return this.getWeapon().getTotalUnloadingDuration();
            }
            case DRAWING: {
                return this.getWeapon().getTotalDrawingDuration();
            }
            case COMPOUND_RELOAD: {
                return this.getWeapon().getRenderer().getWeaponRendererBuilder().getCompoundReloadDuration() / 2L;
            }
            case COMPOUND_RELOAD_EMPTY: {
                return this.getWeapon().getRenderer().getWeaponRendererBuilder().getCompoundReloadEmptyDuration();
            }
            case TACTICAL_RELOAD: {
                return this.getWeapon().getRenderer().getWeaponRendererBuilder().getTacticalReloadDuration();
            }
            case COMPOUND_RELOAD_FINISHED: {
                return this.getWeapon().getRenderer().getWeaponRendererBuilder().getCompoundReloadDuration();
            }
        }
        return 100L;
    }

    @Override
    public boolean setState(WeaponState state) {
        boolean result = super.setState(state);
        this.addStateToHistory(state);
        return result;
    }

    public AsyncWeaponState nextHistoryState() {
        AsyncWeaponState result = this.filteredStateQueue.pollLast();
        if (result == null) {
            result = new AsyncWeaponState((WeaponState)this.getState(), this.stateUpdateTimestamp);
        }
        return result;
    }

    public int getAmmo() {
        return this.ammo;
    }

    public boolean isSlideLocked() {
        return this.isSlideInLock;
    }

    public void setSlideLock(boolean state) {
        this.isSlideInLock = state;
    }

    public void setAmmo(int ammo) {
        if (ammo != this.ammo) {
            this.ammo = ammo;
            this.markDirty();
        }
    }

    @Override
    public void read(ByteBuf byteBuf) {
        super.read(byteBuf);
        this.activeAttachmentIds = PlayerWeaponInstance.initIntArray(byteBuf);
        this.selectedAttachmentIndexes = PlayerWeaponInstance.initByteArray(byteBuf);
        this.ammo = byteBuf.readInt();
        this.aimed = byteBuf.readBoolean();
        this.recoil = byteBuf.readFloat();
        this.maxShots = byteBuf.readInt();
        this.zoom = byteBuf.readFloat();
        this.activeTextureIndex = byteBuf.readByte();
        this.laserOn = byteBuf.readBoolean();
        this.nightVisionOn = byteBuf.readBoolean();
        this.loadIterationCount = byteBuf.readInt();
        this.loadAfterUnloadEnabled = byteBuf.readBoolean();
        this.altModificationModeEnabled = byteBuf.readBoolean();
    }

    @Override
    public void write(ByteBuf byteBuf) {
        super.write(byteBuf);
        PlayerWeaponInstance.serializeIntArray(byteBuf, this.activeAttachmentIds);
        PlayerWeaponInstance.serializeByteArray(byteBuf, this.selectedAttachmentIndexes);
        byteBuf.writeInt(this.ammo);
        byteBuf.writeBoolean(this.aimed);
        byteBuf.writeFloat(this.recoil);
        byteBuf.writeInt(this.maxShots);
        byteBuf.writeFloat(this.zoom);
        byteBuf.writeByte((int)this.activeTextureIndex);
        byteBuf.writeBoolean(this.laserOn);
        byteBuf.writeBoolean(this.nightVisionOn);
        byteBuf.writeInt(this.loadIterationCount);
        byteBuf.writeBoolean(this.loadAfterUnloadEnabled);
        byteBuf.writeBoolean(this.altModificationModeEnabled);
    }

    private static void serializeIntArray(ByteBuf buf, int[] a) {
        buf.writeByte(a.length);
        for (int j : a) {
            buf.writeInt(j);
        }
    }

    private static void serializeByteArray(ByteBuf buf, byte[] a) {
        buf.writeByte(a.length);
        for (int i = 0; i < a.length; ++i) {
            buf.writeByte((int)a[i]);
        }
    }

    private static int[] initIntArray(ByteBuf buf) {
        int length = buf.readByte();
        int[] a = new int[length];
        for (int i = 0; i < length; ++i) {
            a[i] = buf.readInt();
        }
        return a;
    }

    private static byte[] initByteArray(ByteBuf buf) {
        int length = buf.readByte();
        byte[] a = new byte[length];
        for (int i = 0; i < length; ++i) {
            a[i] = buf.readByte();
        }
        return a;
    }

    @Override
    protected void updateWith(PlayerItemInstance<WeaponState> otherItemInstance, boolean updateManagedState) {
        super.updateWith(otherItemInstance, updateManagedState);
        PlayerWeaponInstance otherWeaponInstance = (PlayerWeaponInstance)otherItemInstance;
        this.setAmmo(otherWeaponInstance.ammo);
        this.setZoom(otherWeaponInstance.zoom);
        this.setRecoil(otherWeaponInstance.recoil);
        this.setSelectedAttachmentIndexes(otherWeaponInstance.selectedAttachmentIndexes);
        this.setActiveAttachmentIds(otherWeaponInstance.activeAttachmentIds);
        this.setActiveTextureIndex(otherWeaponInstance.activeTextureIndex);
        this.setLaserOn(otherWeaponInstance.laserOn);
        this.setMaxShots(otherWeaponInstance.maxShots);
        this.setLoadIterationCount(otherWeaponInstance.loadIterationCount);
        this.setLoadAfterUnloadEnabled(otherWeaponInstance.loadAfterUnloadEnabled);
    }

    public Weapon getWeapon() {
        return (Weapon)this.item;
    }

    public float getRecoil() {
        return this.recoil;
    }

    public void setRecoil(float recoil) {
        if (recoil != this.recoil) {
            this.recoil = recoil;
            this.markDirty();
        }
    }

    public boolean isDelayCompoundEnd() {
        return this.isDelayCompoundEnd;
    }

    public void setDelayCompoundEnd(boolean bool) {
        if (!bool) {
            this.stateReloadUpdateTimestamp = System.currentTimeMillis();
        }
        this.isDelayCompoundEnd = bool;
    }

    public boolean isLoadAfterUnloadEnabled() {
        return this.loadAfterUnloadEnabled;
    }

    public void setLoadAfterUnloadEnabled(boolean loadAfterUnloadEnabled) {
        this.loadAfterUnloadEnabled = loadAfterUnloadEnabled;
    }

    public int getMaxShots() {
        return this.maxShots;
    }

    void setMaxShots(int maxShots) {
        if (this.maxShots != maxShots) {
            this.maxShots = maxShots;
            this.markDirty();
        }
    }

    public int getSeriesShotCount() {
        return this.seriesShotCount;
    }

    public void setSeriesShotCount(int seriesShotCount) {
        this.seriesShotCount = seriesShotCount;
    }

    public long getLastFireTimestamp() {
        return this.lastFireTimestamp;
    }

    public void setLastFireTimestamp(long lastFireTimestamp) {
        this.lastFireTimestamp = lastFireTimestamp;
    }

    public void resetCurrentSeries() {
        this.seriesShotCount = 0;
        this.seriesResetAllowed = false;
    }

    public void setLastBurstEndTimestamp(long lastBurstEndTimestamp) {
        this.lastBurstEndTimestamp = lastBurstEndTimestamp;
    }

    public long getLastBurstEndTimestamp() {
        return this.lastBurstEndTimestamp;
    }

    public void setSeriesResetAllowed(boolean seriesResetAllowed) {
        this.seriesResetAllowed = seriesResetAllowed;
    }

    public boolean isSeriesResetAllowed() {
        return this.seriesResetAllowed;
    }

    public float getFireRate() {
        return BalancePackManager.getFirerate(this.getWeapon());
    }

    public float getInaccuracy() {
        return BalancePackManager.getInaccuracy(this.getWeapon());
    }

    public boolean isOneClickBurstAllowed() {
        return this.getWeapon().builder.isOneClickBurstAllowed;
    }

    public boolean isAutomaticModeEnabled() {
        return this.maxShots > 1;
    }

    public boolean isAimed() {
        return this.aimed;
    }

    public void setAimed(boolean aimed) {
        if (aimed != this.aimed) {
            this.aimed = aimed;
            this.markDirty();
            this.aimChangeTimestamp = System.currentTimeMillis();
        }
    }

    public int[] getActiveAttachmentIds() {
        if (this.activeAttachmentIds == null || this.activeAttachmentIds.length != AttachmentCategory.values.length) {
            this.activeAttachmentIds = new int[AttachmentCategory.values.length];
            for (CompatibleAttachment<Weapon> attachment : this.getWeapon().getCompatibleAttachments().values()) {
                if (!attachment.isDefault()) continue;
                this.activeAttachmentIds[attachment.getAttachment().getCategory().ordinal()] = Item.func_150891_b(attachment.getAttachment());
            }
        }
        return this.activeAttachmentIds;
    }

    void setActiveAttachmentIds(int[] activeAttachmentIds) {
        if (!Arrays.equals(this.activeAttachmentIds, activeAttachmentIds)) {
            this.activeAttachmentIds = activeAttachmentIds;
            this.markDirty();
        }
    }

    public byte[] getSelectedAttachmentIds() {
        return this.selectedAttachmentIndexes;
    }

    void setSelectedAttachmentIndexes(byte[] selectedAttachmentIndexes) {
        if (!Arrays.equals(this.selectedAttachmentIndexes, selectedAttachmentIndexes)) {
            this.selectedAttachmentIndexes = selectedAttachmentIndexes;
            this.markDirty();
        }
    }

    public boolean isAttachmentZoomEnabled() {
        ItemAttachment<Weapon> scopeItem = this.getAttachmentItemWithCategory(AttachmentCategory.SCOPE);
        return scopeItem instanceof ItemScope;
    }

    public ItemAttachment<Weapon> getAttachmentItemWithCategory(AttachmentCategory category) {
        if (this.activeAttachmentIds == null || this.activeAttachmentIds.length <= category.ordinal()) {
            return null;
        }
        Item activeAttachment = Item.func_150899_d((int)this.activeAttachmentIds[category.ordinal()]);
        if (activeAttachment instanceof ItemAttachment) {
            return (ItemAttachment)activeAttachment;
        }
        return null;
    }

    public boolean isAwaitingCompoundInstructions() {
        return this.isAwaitingCompoundInstructions;
    }

    public void setIsAwaitingCompoundInstructions(boolean state) {
        this.isAwaitingCompoundInstructions = state;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        if (this.zoom != zoom && zoom > 0.0f) {
            this.zoom = zoom;
            this.markDirty();
        }
    }

    public boolean isLaserOn() {
        return this.laserOn;
    }

    public void setLaserOn(boolean laserOn) {
        if (this.laserOn != laserOn) {
            this.laserOn = laserOn;
            this.markDirty();
        }
    }

    public boolean isNightVisionOn() {
        return this.nightVisionOn;
    }

    public void setNightVisionOn(boolean nightVisionOn) {
        if (this.nightVisionOn != nightVisionOn) {
            this.nightVisionOn = nightVisionOn;
            this.markDirty();
        }
    }

    public int getActiveTextureIndex() {
        return this.activeTextureIndex;
    }

    public void setActiveTextureIndex(int activeTextureIndex) {
        if (this.activeTextureIndex != activeTextureIndex) {
            if (activeTextureIndex > 127) {
                throw new IllegalArgumentException("activeTextureIndex must be less than 127");
            }
            this.activeTextureIndex = (byte)activeTextureIndex;
            this.markDirty();
        }
    }

    @Override
    public Class<? extends Perspective<?>> getRequiredPerspectiveType() {
        ItemAttachment<Weapon> scope;
        Class<OpticalScopePerspective> result = null;
        if ((this.isAimed() || !this.isAimed()) && (scope = this.getAttachmentItemWithCategory(AttachmentCategory.SCOPE)) instanceof ItemScope && ((ItemScope)scope).isOptical()) {
            result = OpticalScopePerspective.class;
        }
        return result;
    }

    private boolean hasOpticScope() {
        ItemAttachment<Weapon> scope = this.getAttachmentItemWithCategory(AttachmentCategory.SCOPE);
        return scope instanceof ItemScope && ((ItemScope)scope).isOptical();
    }

    public ItemScope getScope() {
        ItemAttachment<Weapon> scope = this.getAttachmentItemWithCategory(AttachmentCategory.SCOPE);
        return scope instanceof ItemScope ? (ItemScope)scope : null;
    }

    @SideOnly(value=Side.CLIENT)
    private float getOpticScopeVignetteRadius(float partialTicks) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        float f2 = player.field_71107_bF + (player.field_71109_bG - player.field_71107_bF) * partialTicks;
        return 0.55f;
    }

    private float getAimChangeProgress() {
        float p = MiscUtils.clamp((float)(System.currentTimeMillis() - this.aimChangeTimestamp) / 1200.0f, 0.0f, 1.0f);
        if (!this.isAimed()) {
            p = 1.0f - p;
        }
        return p;
    }

    @Override
    public DynamicShaderGroupSource getShaderSource(DynamicShaderPhase phase) {
        ItemScope scope;
        if (this.isAimed() && phase == DynamicShaderPhase.POST_WORLD_OPTICAL_SCOPE_RENDER && (scope = this.getScope()).isOptical()) {
            return scope.hasNightVision() && this.nightVisionOn ? this.NIGHT_VISION_SOURCE : this.VIGNETTE_SOURCE;
        }
        float progress = this.getAimChangeProgress();
        return ModernConfigManager.enableBlurOnAim && phase == DynamicShaderPhase.PRE_ITEM_RENDER && (this.isAimed() || progress > 0.0f && progress < 1.0f) ? this.BLUR_SOURCE : null;
    }

    public void setLoadIterationCount(int loadIterationCount) {
        this.loadIterationCount = loadIterationCount;
    }

    public int getLoadIterationCount() {
        return this.loadIterationCount;
    }

    @Override
    protected void reconcile() {
        if (!this.player.field_70170_p.func_82736_K().func_82766_b("reconcileAmmunition") && !this.player.field_70170_p.func_82736_K().func_82766_b("reconcileAttachment")) {
            return;
        }
        ItemStack itemStack = this.getItemStack();
        if (itemStack != null) {
            int[] expectedAttachmentIds;
            int expectedStackAmmo;
            if (this.player.field_70170_p.func_82736_K().func_82766_b("reconcileAmmunition") && this.ammo != (expectedStackAmmo = Tags.getAmmo(itemStack))) {
                ModReference.LOG.debug("Reconciling ammunition. Expected ammunition: {}, Current ammunition: {}", (Object)expectedStackAmmo, (Object)this.ammo);
                this.ammo = expectedStackAmmo;
            }
            if (this.player.field_70170_p.func_82736_K().func_82766_b("reconcileAttachments") && !Arrays.equals(expectedAttachmentIds = Tags.getAttachmentIds(itemStack), this.activeAttachmentIds)) {
                ModReference.LOG.debug("Reconciling attachments. Expected attachments: {}, Current attachments: {}", (Object)Arrays.toString(expectedAttachmentIds), (Object)Arrays.toString(this.activeAttachmentIds));
                this.activeAttachmentIds = expectedAttachmentIds;
            }
            this.updateTimestamp = System.currentTimeMillis();
        }
    }

    public String toString() {
        return this.getWeapon().builder.name + "[" + this.getUuid() + "]";
    }

    public boolean isAltMofificationModeEnabled() {
        return this.altModificationModeEnabled;
    }

    public void setAltModificationModeEnabled(boolean altModificationModeEnabled) {
        this.altModificationModeEnabled = altModificationModeEnabled;
    }

    static {
        TypeRegistry.getINSTANCE().register(PlayerWeaponInstance.class);
        NIGHT_VISION_SOURCE_UUID = UUID.randomUUID();
        VIGNETTE_SOURCE_UUID = UUID.randomUUID();
        BLUR_SOURCE_UUID = UUID.randomUUID();
    }
}

