/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.paneedah.mwc.utils.ModReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public abstract class JSONDatabaseManager {
    protected static final Gson GSON_MANAGER = new GsonBuilder().setPrettyPrinting().create();
    protected static MessageDigest SHA_256_DIGEST;

    public abstract JsonObject toJSON();

    public abstract void fromJSON(JsonObject var1);

    public abstract File getDirectory();

    public abstract void loadDirectory();

    public static String getFileDigestHex(File file) {
        return Hex.encodeHexString((byte[])JSONDatabaseManager.getDigest(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getDigest(File f) {
        if (SHA_256_DIGEST == null) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(f);){
            byte[] byArray = JSONDatabaseManager.getDigest(is);
            return byArray;
        }
        catch (FileNotFoundException e) {
            ModReference.LOG.error("Could not find file {}", (Object)f);
            ModReference.LOG.catching((Throwable)e);
            return null;
        }
        catch (IOException e) {
            ModReference.LOG.error("Could not read file {}", (Object)f);
            ModReference.LOG.catching((Throwable)e);
        }
        return null;
    }

    public static byte[] getDigest(InputStream is) {
        try {
            byte[] byteArray = new byte[is.available()];
            is.read(byteArray);
            return byteArray;
        }
        catch (IOException e) {
            ModReference.LOG.error("Could not create SHA-256 digest for {}", (Object)is.toString());
            ModReference.LOG.catching((Throwable)e);
            return null;
        }
    }

    protected static Gson getGSON() {
        return GSON_MANAGER;
    }

    static {
        try {
            SHA_256_DIGEST = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            ModReference.LOG.error("Failed to create SHA-256 digester!");
            ModReference.LOG.catching((Throwable)e);
        }
    }
}

