/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LoggerBase {
    protected Logger modLogger;
    protected File debugFile;

    protected void Initialise(String modName, String debugLogFile) {
        this.modLogger = LogManager.getLogger((String)modName);
        this.debugFile = new File(debugLogFile);
    }

    public void debug(String message) {
        if (message == null) {
            return;
        }
        if (this.modLogger != null) {
            this.modLogger.debug(message);
        }
        this.writeLine("[DEBUG] " + message, true);
    }

    public void debug(String message, Boolean checkConfig) {
        this.debug(message);
    }

    public void error(String message) {
        if (message == null) {
            return;
        }
        if (this.modLogger != null) {
            this.modLogger.error(message);
        }
        this.writeLine("[ERROR] " + message, true);
    }

    public void fatal(String message) {
        if (message == null) {
            return;
        }
        if (this.modLogger != null) {
            this.modLogger.fatal(message);
        }
        this.writeLine("[FATAL] " + message, true);
    }

    public void info(String message) {
        if (message == null) {
            return;
        }
        if (this.modLogger != null) {
            this.modLogger.info(message);
        }
        this.writeLine("[INFO] " + message, true);
    }

    public void info(String message, Boolean checkConfig) {
        this.info(message);
    }

    public void trace(String message) {
        if (message == null) {
            return;
        }
        if (this.modLogger != null) {
            this.modLogger.trace(message);
        }
        this.writeLine("[TRACE] " + message, true);
    }

    public void warn(String message) {
        if (message == null) {
            return;
        }
        if (this.modLogger != null) {
            this.modLogger.warn(message);
        }
        this.writeLine("[WARN] " + message, true);
    }

    public void resetDebug() {
        this.writeLines(Collections.singletonList("Debug Log:"), false);
    }

    public void writeLine(String line, Boolean append) {
        this.writeLines(Collections.singletonList(line), append);
    }

    public void writeLines(Collection<String> lines, Boolean append) {
        if (this.debugFile == null) {
            return;
        }
        try {
            FileUtils.writeLines((File)this.debugFile, lines, (boolean)append);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

