/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.storage;

import bletch.common.Interfaces.IDesireEntity;
import bletch.common.storage.ItemDesire;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ItemDesireSet {
    protected List<ItemDesire> itemDesires = new ArrayList<ItemDesire>();
    protected boolean deliveryDirty = true;
    protected int deliveryId = 0;
    protected byte deliverySlot = (byte)-1;
    protected short deliveryCount = 0;
    protected int totalDeliverySize = 0;

    public void clear() {
        this.itemDesires.clear();
    }

    public void addItemDesire(ItemDesire desire) {
        this.itemDesires.add(desire);
    }

    public void forceUpdate() {
        this.itemDesires.forEach(d -> d.forceUpdate());
        this.deliveryDirty = true;
    }

    public void onStorageUpdated(IDesireEntity entity, ItemStack storageItem) {
        this.itemDesires.forEach(d -> d.onStorageUpdated(entity, storageItem));
    }

    public void onInventoryUpdated(IDesireEntity entity, ItemStack updatedItem) {
        this.itemDesires.forEach(d -> d.onInventoryUpdated(entity, updatedItem));
        this.deliveryDirty = true;
    }

    public ItemDesire getNeededDesire(IDesireEntity entity) {
        Collections.shuffle(this.itemDesires);
        for (ItemDesire desire : this.itemDesires) {
            if (!desire.shouldPickUp(entity)) continue;
            return desire;
        }
        return null;
    }
}

