/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.core;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import sereneseasons.api.ISSBlock;
import sereneseasons.core.CommonProxy;
import sereneseasons.util.inventory.CreativeTabSS;

public class ClientProxy
extends CommonProxy {
    @Override
    public void registerRenderers() {
    }

    @Override
    public void registerItemVariantModel(Item item, String name, int metadata) {
        Preconditions.checkNotNull((Object)item, (Object)("Cannot register models for null item " + name));
        Preconditions.checkArgument((item != Items.field_190931_a ? 1 : 0) != 0, (Object)("Cannot register models for air (" + name + ")"));
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("sereneseasons:" + name)});
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation("sereneseasons:" + name, "inventory"));
    }

    @Override
    public void registerBlockSided(Block block) {
        ISSBlock bopBlock;
        IProperty[] nonRenderingProperties;
        if (block instanceof ISSBlock && (nonRenderingProperties = (bopBlock = (ISSBlock)block).getNonRenderingProperties()) != null) {
            StateMap custom_mapper = new StateMap.Builder().func_178442_a(nonRenderingProperties).func_178441_a();
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)custom_mapper);
        }
    }

    @Override
    public void registerItemSided(Item item) {
        if (item.func_77614_k()) {
            NonNullList subItems = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabSS.instance, subItems);
            for (ItemStack subItem : subItems) {
                String subItemName = item.func_77667_c(subItem);
                subItemName = subItemName.substring(subItemName.indexOf(".") + 1);
                ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("sereneseasons", subItemName)});
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)subItem.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation("sereneseasons:" + subItemName, "inventory"));
            }
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("sereneseasons:" + item.delegate.name().func_110623_a(), "inventory"));
        }
    }

    private static <E extends Entity> void registerEntityRenderer(Class<E> entityClass, Class<? extends Render<E>> renderClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, new EntityRenderFactory(renderClass));
    }

    private static class EntityRenderFactory<E extends Entity>
    implements IRenderFactory<E> {
        private Class<? extends Render<E>> renderClass;

        private EntityRenderFactory(Class<? extends Render<E>> renderClass) {
            this.renderClass = renderClass;
        }

        public Render<E> createRenderFor(RenderManager manager) {
            Render<E> renderer = null;
            try {
                renderer = this.renderClass.getConstructor(RenderManager.class).newInstance(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return renderer;
        }
    }
}

