/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.node;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.rftoolscontrol.blocks.GenericRFToolsBlock;
import mcjty.rftoolscontrol.blocks.node.GuiNode;
import mcjty.rftoolscontrol.blocks.node.NodeTileEntity;
import mcjty.rftoolscontrol.setup.GuiProxy;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NodeBlock
extends GenericRFToolsBlock<NodeTileEntity, EmptyContainer> {
    public NodeBlock() {
        super(Material.field_151573_f, NodeTileEntity.class, EmptyContainer::new, "node", false);
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<NodeTileEntity, EmptyContainer, GenericGuiContainer<? super NodeTileEntity>> getGuiFactory() {
        return GuiNode::new;
    }

    public int getGuiID() {
        return GuiProxy.GUI_NODE;
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World playerIn, List<String> list, ITooltipFlag advanced) {
        super.func_190948_a(stack, playerIn, list, advanced);
        list.add("This node can be remotely accessed");
        list.add("by the processor that has a network");
        list.add("card installed");
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof NodeTileEntity) {
            NodeTileEntity node = (NodeTileEntity)te;
            probeInfo.text(TextFormatting.GREEN + "Channel: " + node.getChannelName());
            probeInfo.text(TextFormatting.GREEN + "Name: " + node.getNodeName());
        }
    }

    private int getInputStrength(World world, BlockPos pos, EnumFacing side) {
        return world.func_175651_c(pos.func_177972_a(side), side);
    }

    protected void checkRedstone(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof NodeBlock && te instanceof NodeTileEntity) {
            NodeTileEntity processor = (NodeTileEntity)te;
            int powered = 0;
            if (this.getInputStrength(world, pos, EnumFacing.DOWN) > 0) {
                ++powered;
            }
            if (this.getInputStrength(world, pos, EnumFacing.UP) > 0) {
                powered += 2;
            }
            if (this.getInputStrength(world, pos, EnumFacing.NORTH) > 0) {
                powered += 4;
            }
            if (this.getInputStrength(world, pos, EnumFacing.SOUTH) > 0) {
                powered += 8;
            }
            if (this.getInputStrength(world, pos, EnumFacing.WEST) > 0) {
                powered += 16;
            }
            if (this.getInputStrength(world, pos, EnumFacing.EAST) > 0) {
                powered += 32;
            }
            processor.setPowerInput(powered);
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof NodeBlock && te instanceof NodeTileEntity) {
            NodeTileEntity processor = (NodeTileEntity)te;
            return processor.getPowerOut(side.func_176734_d());
        }
        return 0;
    }
}

