/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.EnergyTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergyTask
extends EnergyTask {
    public static final ResourceLocation EMPTY_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/fe_empty.png");
    public static final ResourceLocation FULL_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/fe_full.png");

    public ForgeEnergyTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.FORGE_ENERGY;
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.task.ftbquests.forge_energy.text", (Object[])new Object[]{StringUtils.formatDouble((double)this.value, (boolean)true)});
    }

    @Override
    public void drawScreen(@Nullable TaskData data) {
        double r;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(EMPTY_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double x = -0.5;
        double y = -0.5;
        double w = 1.0;
        double h = 1.0;
        double z = 0.0;
        buffer.func_181662_b(x, y + h, z).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y + h, z).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y, z).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x, y, z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        double d = r = data == null ? 0.0 : (double)data.progress / (double)((Task)data.task).getMaxProgress();
        if (r > 0.0) {
            x -= 0.0078125;
            w += 0.015625;
            h = r * 30.0 / 32.0;
            y = 0.03125 + (1.0 - r) * 30.0 / 32.0 - 0.5;
            y -= 0.0078125;
            h += 0.015625;
            z = -0.003;
            double u0 = 0.0;
            double v0 = 0.03125 + 0.9375 * (1.0 - r);
            double u1 = 1.0;
            double v1 = 0.96875;
            mc.func_110434_K().func_110577_a(FULL_TEXTURE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(x, y + h, z).func_187315_a(u0, v1).func_181675_d();
            buffer.func_181662_b(x + w, y + h, z).func_187315_a(u1, v1).func_181675_d();
            buffer.func_181662_b(x + w, y, z).func_187315_a(u1, v0).func_181675_d();
            buffer.func_181662_b(x, y, z).func_187315_a(u0, v0).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<ForgeEnergyTask>
    implements IEnergyStorage {
        private Data(ForgeEnergyTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        @Override
        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CapabilityEnergy.ENERGY ? this : null);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (maxReceive > 0 && !this.isComplete()) {
                long add = Math.min((long)maxReceive, ((ForgeEnergyTask)this.task).value - this.progress);
                if (((ForgeEnergyTask)this.task).maxInput > 0L) {
                    add = Math.min(add, ((ForgeEnergyTask)this.task).maxInput);
                }
                if (add > 0L) {
                    if (!simulate) {
                        this.addProgress(add);
                    }
                    return (int)add;
                }
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return (int)Math.min(((ForgeEnergyTask)this.task).maxInput, Integer.MAX_VALUE);
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

