/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.terrain;

import java.util.Random;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.types.FeatureType;
import mcjty.rftoolsdim.dimensions.world.terrain.BaseTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.NormalTerrainGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.chunk.ChunkPrimer;

public class FlatTerrainGenerator
extends NormalTerrainGenerator {
    private final byte height;

    public FlatTerrainGenerator(byte height) {
        this.height = height;
    }

    @Override
    public void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        IBlockState baseBlock = this.provider.dimensionInformation.getBaseBlockForTerrain();
        int waterLevel = this.height;
        boolean elevated = false;
        if (this.provider.dimensionInformation.hasFeatureType(FeatureType.FEATURE_MAZE)) {
            long s2 = ((long)chunkX + this.provider.seed + 13L) * 314L + (long)chunkZ * 17L;
            Random rand = new Random(s2);
            rand.nextFloat();
            boolean bl = elevated = (chunkX & 1) == 0;
            if (rand.nextFloat() < 0.2f) {
                elevated = !elevated;
            }
            waterLevel = elevated ? 120 : 40;
        }
        int index = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height;
                for (height = 0; height < WorldgenConfiguration.bedrockLayer; ++height) {
                    BaseTerrainGenerator.setBlockState(primer, index++, Blocks.field_150357_h.func_176223_P());
                }
                while (height < waterLevel) {
                    BaseTerrainGenerator.setBlockState(primer, index++, baseBlock);
                    ++height;
                }
                while (height < 256) {
                    BaseTerrainGenerator.setBlockState(primer, index++, Blocks.field_150350_a.func_176223_P());
                    ++height;
                }
            }
        }
    }
}

